/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.gvt.ChisioMain;
import org.gvt.action.ChiBEAction;
import org.gvt.action.FileChooser;
import org.gvt.gui.ItemSelectionDialog;
import org.gvt.gui.ItemSelectionRunnable;
import org.gvt.model.basicsif.BasicSIFGraph;

public class ShowFormatSeriesAction
extends ChiBEAction {
    private String formatFilename;
    private BasicSIFGraph graph;
    private List<String> initialFormat;
    private List<String> names;
    private List<List<String>> series;

    public ShowFormatSeriesAction(ChisioMain main) {
        super("Load formatting...", null, main);
        this.addFilterExtension("FILE_KEY", new String[]{"*.format", "*.formatseries"});
        this.addFilterName("FILE_KEY", new String[]{"Format File (*.format)", "Format Series File (*.formatseries)"});
    }

    public void setFormatFilename(String formatFilename) {
        this.formatFilename = formatFilename;
    }

    @Override
    public void run() {
        if (!(this.main.getPathwayGraph() instanceof BasicSIFGraph)) {
            return;
        }
        this.graph = (BasicSIFGraph)this.main.getPathwayGraph();
        this.initialFormat = this.graph.getCurrentFormat();
        if (this.formatFilename == null) {
            this.formatFilename = new FileChooser(this).choose("FILE_KEY");
            if (this.formatFilename == null) {
                return;
            }
        }
        if (this.formatFilename.endsWith(".formatseries")) {
            this.series = this.loadFormattingSeries(this.formatFilename);
            this.names = this.getSeriesNames(this.series);
            if (!this.names.isEmpty()) {
                ItemSelectionDialog dialog = new ItemSelectionDialog(this.main.getShell(), 250, "Timepoint Selection Dialog", "Select timepoint of interest", new ArrayList<String>(this.names), new ArrayList<String>(Collections.singleton(this.names.get(0))), false, false, new Runner());
                dialog.setUpdateUponSelection(true);
                dialog.setDoSort(false);
                dialog.setMain(this.main);
                dialog.runAsIfSelected(this.names.get(0));
                Object lastItem = dialog.open();
                if (lastItem == null || !lastItem.equals("None")) {
                    dialog.runAsIfSelected("None");
                }
            }
        } else {
            List<String> format = this.loadFormat(this.formatFilename);
            this.graph.format(format);
        }
        this.graph = null;
        this.formatFilename = null;
        this.names = null;
        this.series = null;
        this.initialFormat = null;
    }

    private List<String> loadFormat(String filename) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            Scanner sc = new Scanner(new File(filename));
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                list.add(line);
            }
            return list;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<List<String>> loadFormattingSeries(String filename) {
        try {
            ArrayList<List<String>> list = new ArrayList<List<String>>();
            Scanner sc = new Scanner(new File(filename));
            ArrayList<String> current = null;
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                if (line.startsWith("group-name\t")) {
                    if (current != null) {
                        list.add(current);
                    }
                    current = new ArrayList<String>();
                }
                if (current == null) {
                    throw new RuntimeException("Invalid Series Format");
                }
                current.add(line);
            }
            list.add(current);
            return list;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<String> getSeriesNames(List<List<String>> series) {
        ArrayList<String> names = new ArrayList<String>(series.size());
        for (List<String> group : series) {
            names.add(group.get(0).substring(group.get(0).indexOf("\t") + 1));
            group.remove(0);
        }
        return names;
    }

    private class Runner
    implements ItemSelectionRunnable {
        private String lastName;

        private Runner() {
        }

        @Override
        public void run(Collection selectedTerms) {
            if (selectedTerms.isEmpty()) {
                return;
            }
            String id = selectedTerms.iterator().next().toString();
            this.run(id);
        }

        public void run(String name) {
            if (name.equals(this.lastName)) {
                return;
            }
            if (name.equals("None")) {
                ShowFormatSeriesAction.this.graph.format(ShowFormatSeriesAction.this.initialFormat);
            } else {
                ShowFormatSeriesAction.this.graph.format((List)ShowFormatSeriesAction.this.series.get(ShowFormatSeriesAction.this.names.indexOf(name)));
            }
            this.lastName = name;
        }
    }
}

