/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.command;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.gvt.model.CompoundModel;
import org.gvt.model.NodeModel;

public class MoveCommand
extends Command {
    private NodeModel child;
    private CompoundModel parent;
    private Rectangle constraint;
    private Rectangle oldConstraint;

    public MoveCommand(EditPart editPart, Rectangle rect) {
        this.child = (NodeModel)editPart.getModel();
        this.parent = (CompoundModel)editPart.getParent().getModel();
        this.constraint = rect;
    }

    public MoveCommand(NodeModel model, Rectangle rect) {
        this.child = model;
        this.parent = model.getParentModel();
        this.constraint = rect;
    }

    @Override
    public void execute() {
        this.oldConstraint = this.child.getConstraint().getCopy();
        this.child.setPositiveLocation(this.constraint);
        this.parent.calculateSizeUp();
    }

    @Override
    public void undo() {
        this.child.setConstraint(this.oldConstraint);
        this.parent.calculateSizeUp();
    }

    @Override
    public void redo() {
        this.execute();
    }

    public void setParent(CompoundModel parent) {
        this.parent = parent;
    }
}

