/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.command;

import org.eclipse.gef.commands.Command;
import org.gvt.model.EdgeModel;
import org.gvt.model.NodeModel;

public class ReconnectConnectionCommand
extends Command {
    private EdgeModel connection;
    private NodeModel newSource = null;
    private NodeModel newTarget = null;
    private NodeModel oldSource = null;
    private NodeModel oldTarget = null;

    @Override
    public void execute() {
        if (this.newSource != null) {
            this.oldSource = this.connection.getSource();
            this.reconnectSource(this.newSource);
        }
        if (this.newTarget != null) {
            this.oldTarget = this.connection.getTarget();
            this.reconnectTarget(this.newTarget);
        }
    }

    private void reconnectSource(NodeModel source) {
        this.connection.detachSource();
        this.connection.setSource(source);
        this.connection.attachSource();
    }

    private void reconnectTarget(NodeModel target) {
        this.connection.detachTarget();
        this.connection.setTarget(target);
        this.connection.attachTarget();
    }

    public void setConnectionModel(Object model) {
        this.connection = (EdgeModel)model;
    }

    public void setNewSource(Object model) {
        this.newSource = (NodeModel)model;
    }

    public void setNewTarget(Object model) {
        this.newTarget = (NodeModel)model;
    }

    @Override
    public void undo() {
        if (this.oldSource != null) {
            this.reconnectSource(this.oldSource);
        }
        if (this.oldTarget != null) {
            this.reconnectTarget(this.oldTarget);
        }
        this.oldSource = null;
        this.oldTarget = null;
    }
}

