/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.command;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.gvt.command.AddCommand;
import org.gvt.command.DeleteCommand;
import org.gvt.command.MoveCommand;
import org.gvt.command.OrphanChildCommand;
import org.gvt.model.CompoundModel;
import org.gvt.model.GraphObject;
import org.gvt.model.NodeModel;

public class RemoveCompoundCommand
extends Command {
    private CompoundModel model;
    private List sourceConnections = new ArrayList();
    private List targetConnections = new ArrayList();

    public RemoveCompoundCommand() {
        super("Remove Compound");
    }

    @Override
    public void execute() {
        List children = this.model.getChildren();
        HashSet<GraphObject> highlightedSet = new HashSet<GraphObject>();
        for (int size = children.size(); size > 0; --size) {
            NodeModel node = (NodeModel)children.get(0);
            this.collectHighlighted(node, highlightedSet);
            OrphanChildCommand cmd = new OrphanChildCommand();
            cmd.setParent(this.model);
            cmd.setChild(node);
            cmd.setOnlyRemoveCompound(true);
            cmd.execute();
            Rectangle rect = node.getConstraint().translate(this.model.getLocation());
            AddCommand add = new AddCommand();
            add.setParent(this.model.getParentModel());
            add.setChild(node);
            MoveCommand move = new MoveCommand(node, rect);
            move.setParent(this.model.getParentModel());
            add.chain(move);
            add.execute();
            for (GraphObject graphObject : highlightedSet) {
                graphObject.setHighlight(true);
            }
        }
        DeleteCommand cmd = new DeleteCommand();
        cmd.setChild(this.model);
        cmd.setParent(this.model.getParentModel());
        cmd.execute();
    }

    @Override
    public void redo() {
        this.execute();
    }

    private void restoreConnections() {
        this.sourceConnections.clear();
        this.targetConnections.clear();
    }

    @Override
    public void undo() {
    }

    public void setCompound(CompoundModel compoundModel) {
        this.model = compoundModel;
    }

    protected void collectHighlighted(GraphObject obj, Set<GraphObject> set) {
        if (obj.isHighlight()) {
            set.add(obj);
            obj.setHighlight(false);
        }
        if (obj instanceof CompoundModel) {
            for (Object o : ((CompoundModel)obj).getChildren()) {
                if (!(o instanceof GraphObject)) continue;
                this.collectHighlighted((GraphObject)o, set);
            }
        }
    }
}

