/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.editpart;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.gvt.GraphAnimation;
import org.gvt.editpolicy.ChsBendpointEditPolicy;
import org.gvt.editpolicy.ChsConnectionEditPolicy;
import org.gvt.editpolicy.ChsConnectionEndpointEditPolicy;
import org.gvt.figure.EdgeFigure;
import org.gvt.figure.HighlightLayer;
import org.gvt.model.EdgeBendpoint;
import org.gvt.model.EdgeModel;
import org.ivis.layout.LayoutOptionsPack;

public class ChsEdgeEditPart
extends AbstractConnectionEditPart
implements PropertyChangeListener {
    @Override
    protected IFigure createFigure() {
        EdgeModel model = this.getEdgeModel();
        EdgeFigure eFigure = new EdgeFigure(model.getText(), model.getTooltipText(), model.getTextFont(), model.getTextColor(), model.getColor(), model.getStyle(), model.getArrow(), model.getWidth(), model.getHighlightColor(), model.isHighlight());
        eFigure.updateHighlight((HighlightLayer)this.getLayer("Highlight Layer"), this.getEdgeModel().isHighlight());
        eFigure.setConnectionRouter(new BendpointConnectionRouter(){

            @Override
            public void route(Connection conn) {
                if (!LayoutOptionsPack.getInstance().getGeneral().animationDuringLayout || LayoutOptionsPack.getInstance().getGeneral().animationOnLayout) {
                    GraphAnimation.recordInitialState(conn);
                    if (GraphAnimation.playbackState(conn)) {
                        return;
                    }
                } else {
                    GraphAnimation.recordInitialState((IFigure)conn);
                    if (GraphAnimation.playbackState((IFigure)conn)) {
                        return;
                    }
                }
                super.route(conn);
            }
        });
        return eFigure;
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ConnectionEditPolicy", new ChsConnectionEditPolicy());
        this.installEditPolicy("Connection Bendpoint Policy", new ChsBendpointEditPolicy());
        this.installEditPolicy("Connection Endpoint Policy", new ChsConnectionEndpointEditPolicy());
    }

    protected void refreshBendpoints() {
        if (this.getConnectionFigure().getConnectionRouter() instanceof ManhattanConnectionRouter) {
            return;
        }
        List bendpoints = ((EdgeModel)this.getModel()).getBendpoints();
        ArrayList<EdgeBendpoint> figureConstraint = new ArrayList<EdgeBendpoint>();
        for (int i = 0; i < bendpoints.size(); ++i) {
            EdgeBendpoint bp = (EdgeBendpoint)bendpoints.get(i);
            bp.setConnection(this.getConnectionFigure());
            bp.setWeight((float)(i + 1) / ((float)bendpoints.size() + 1.0f));
            figureConstraint.add(bp);
        }
        this.getConnectionFigure().setRoutingConstraint(figureConstraint);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_text")) {
            ((EdgeFigure)this.figure).updateText((String)evt.getNewValue());
        } else if (evt.getPropertyName().equals("_textFont")) {
            ((EdgeFigure)this.figure).updateTextFont((Font)evt.getNewValue());
        } else if (evt.getPropertyName().equals("_textColor")) {
            ((EdgeFigure)this.figure).updateTextColor((Color)evt.getNewValue());
        } else if (evt.getPropertyName().equals("_color")) {
            ((EdgeFigure)this.figure).updateColor((Color)evt.getNewValue());
        } else if (evt.getPropertyName().equals("_style")) {
            ((EdgeFigure)this.figure).updateStyle((String)evt.getNewValue());
        } else if (evt.getPropertyName().equals("_arrow")) {
            ((EdgeFigure)this.figure).updateArrow((String)evt.getNewValue());
        } else if (evt.getPropertyName().equals("_width")) {
            ((EdgeFigure)this.figure).updateWidth((Integer)evt.getNewValue());
        } else if (evt.getPropertyName().equals("_bendpoint")) {
            this.refreshBendpoints();
        } else if (evt.getPropertyName().equals("_highlight")) {
            ((EdgeFigure)this.figure).updateHighlight((Layer)this.getLayer("Highlight Layer"), this.getEdgeModel().isHighlight());
        } else if (evt.getPropertyName().equals("_highlightColor")) {
            ((EdgeFigure)this.figure).updateHighlightColor((Color)evt.getNewValue());
        }
    }

    @Override
    public void activate() {
        this.getEdgeModel().addPropertyChangeListener(this);
        super.activate();
    }

    @Override
    public void deactivate() {
        this.getEdgeModel().removePropertyChangeListener(this);
        super.deactivate();
    }

    public EdgeModel getEdgeModel() {
        return (EdgeModel)this.getModel();
    }
}

