/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.editpart;

import java.beans.PropertyChangeEvent;
import java.util.List;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.gvt.ChsCellEditorLocator;
import org.gvt.ChsDirectEditManager;
import org.gvt.ChsDragEditPartsTracker;
import org.gvt.editpart.EditPartWithListener;
import org.gvt.editpolicy.ChsComponentEditPolicy;
import org.gvt.editpolicy.ChsDirectEditPolicy;
import org.gvt.editpolicy.ChsGraphicalNodeEditPolicy;
import org.gvt.figure.ChsChopboxAnchor;
import org.gvt.figure.HighlightLayer;
import org.gvt.figure.NodeFigure;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl3.Actor;
import org.gvt.model.custom.CustomNode;
import org.gvt.util.EntityHolder;

public class ChsNodeEditPart
extends EditPartWithListener
implements NodeEditPart {
    ChsDirectEditManager directManager = null;

    @Override
    protected IFigure createFigure() {
        NodeModel model = this.getNodeModel();
        NodeFigure nFigure = new NodeFigure(model.getLocationAbs(), model.getSize(), model.getText(), model.getTooltipText(), model.getTextFont(), model.getTextColor(), model.getColor(), model.getBorderColor(), model.getBorderWidth(), model.getShape(), model.getHighlightColor(), model.isHighlight(), model instanceof Actor ? ((Actor)model).getMultimerNo() : 1);
        nFigure.updateHighlight((HighlightLayer)this.getLayer("Highlight Layer"), this.getNodeModel().isHighlight());
        if (model instanceof Actor) {
            EntityHolder eh = ((Actor)model).getEntity();
            if (eh.l3pe instanceof SmallMolecule) {
                nFigure.setSmallMolecule(true);
                if (((Actor)model).isUbique()) {
                    nFigure.setDrawCloneMarker(true);
                }
            }
        } else if (model instanceof CustomNode && ((CustomNode)model).isDuplicate()) {
            nFigure.setDrawCloneMarker(true);
        }
        return nFigure;
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        return new ChsDragEditPartsTracker(this);
    }

    @Override
    public void performRequest(Request req) {
        if (req.getType().equals("direct edit")) {
            this.performDirectEdit();
            return;
        }
        super.performRequest(req);
    }

    private void performDirectEdit() {
        if (this.directManager == null) {
            this.directManager = new ChsDirectEditManager(this, TextCellEditor.class, new ChsCellEditorLocator(this.getFigure()));
        }
        this.directManager.show();
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", new ChsComponentEditPolicy());
        this.installEditPolicy("DirectEditPolicy", new ChsDirectEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolciy", new ChsGraphicalNodeEditPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_constraint")) {
            this.refreshVisuals();
        } else if (evt.getPropertyName().equals("_text")) {
            ((NodeFigure)this.figure).updateText((String)evt.getNewValue());
        } else if (evt.getPropertyName().equals("_tooltipText")) {
            ((NodeFigure)this.figure).updateTooltipText((String)evt.getNewValue());
        } else if (evt.getPropertyName().equals("_textFont")) {
            ((NodeFigure)this.figure).updateTextFont((Font)evt.getNewValue());
        } else if (evt.getPropertyName().equals("_textColor")) {
            ((NodeFigure)this.figure).updateTextColor((Color)evt.getNewValue());
        } else if (evt.getPropertyName().equals("_color")) {
            ((NodeFigure)this.figure).updateColor((Color)evt.getNewValue());
        } else if (evt.getPropertyName().equals("_borderColor")) {
            ((NodeFigure)this.figure).updateBorderColor((Color)evt.getNewValue());
        } else if (evt.getPropertyName().equals("_borderWidth")) {
            ((NodeFigure)this.figure).updateBorderWidth((Integer)evt.getNewValue());
        } else if (evt.getPropertyName().equals("_shape")) {
            ((NodeFigure)this.figure).updateShape((String)evt.getNewValue());
        } else if (evt.getPropertyName().equals("_connx_source")) {
            this.refreshSourceConnections();
        } else if (evt.getPropertyName().equals("_connx_target")) {
            this.refreshTargetConnections();
        } else if (evt.getPropertyName().equals("_highlight")) {
            ((NodeFigure)this.figure).updateHighlight((Layer)this.getLayer("Highlight Layer"), this.getNodeModel().isHighlight());
        } else if (evt.getPropertyName().equals("_highlightColor")) {
            ((NodeFigure)this.figure).updateHighlightColor((Color)evt.getNewValue());
        }
    }

    @Override
    protected void refreshVisuals() {
        Rectangle constraint = this.getNodeModel().getConstraint();
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint(this, this.getFigure(), constraint);
    }

    @Override
    protected List getModelSourceConnections() {
        return this.getNodeModel().getSourceConnections();
    }

    @Override
    protected List getModelTargetConnections() {
        return this.getNodeModel().getTargetConnections();
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChsChopboxAnchor(this.getFigure());
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ChsChopboxAnchor(this.getFigure());
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChsChopboxAnchor(this.getFigure());
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChsChopboxAnchor(this.getFigure());
    }
}

