/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.editpolicy;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.gvt.ChisioMain;

public class CompoundHighlightEditPolicy
extends GraphicalEditPolicy {
    private Figure selectionFigure;

    @Override
    public void eraseTargetFeedback(Request request) {
        if (this.selectionFigure != null) {
            this.getContainerFigure().remove(this.selectionFigure);
            this.selectionFigure = null;
        }
    }

    private IFigure getContainerFigure() {
        return ((GraphicalEditPart)this.getHost()).getFigure();
    }

    @Override
    public EditPart getTargetEditPart(Request request) {
        return request.getType().equals("selection hover") ? this.getHost() : null;
    }

    protected void showHighlight() {
        if (this.selectionFigure == null && ChisioMain.transferNode) {
            this.selectionFigure = new RectangleFigure(){

                @Override
                protected void fillShape(Graphics graphics) {
                    if (ChisioMain.runningOnWindows) {
                        graphics.setAlpha(100);
                    }
                    graphics.setBackgroundColor(ColorConstants.cyan);
                    graphics.fillRectangle(this.getBounds());
                }
            };
            this.selectionFigure.setBounds(this.getContainerFigure().getBounds());
            this.getContainerFigure().add((IFigure)this.selectionFigure, 0);
        }
    }

    @Override
    public void showTargetFeedback(Request request) {
        if (request.getType().equals("move") || request.getType().equals("add children") || request.getType().equals("clone") || request.getType().equals("connection start") || request.getType().equals("connection end") || request.getType().equals("create child")) {
            this.showHighlight();
        }
    }
}

