/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.figure;

import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.gvt.figure.CompoundFigure;
import org.gvt.figure.NodeFigure;
import org.gvt.util.ChsGeometry;

public class ChsChopboxAnchor
extends AbstractConnectionAnchor {
    protected ChsChopboxAnchor() {
    }

    public ChsChopboxAnchor(IFigure owner) {
        super(owner);
    }

    @Override
    public Point getLocation(Point reference) {
        if (!(this.getOwner() instanceof CompoundFigure)) {
            if (((NodeFigure)this.getOwner()).shape.equals("Ellipse")) {
                return this.getLocationEllipse(reference);
            }
            if (((NodeFigure)this.getOwner()).shape.equals("Triangle")) {
                return this.getLocationTriangle(reference);
            }
        }
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(this.getOwner().getBounds());
        r.translate(-1, -1);
        r.resize(1, 1);
        this.getOwner().translateToAbsolute(r);
        float centerX = (float)r.x + 0.5f * (float)r.width;
        float centerY = (float)r.y + 0.5f * (float)r.height;
        if (r.isEmpty() || reference.x == (int)centerX && reference.y == (int)centerY) {
            return new Point((int)centerX, (int)centerY);
        }
        float dx = (float)reference.x - centerX;
        float dy = (float)reference.y - centerY;
        float scale = 0.5f / Math.max(Math.abs(dx) / (float)r.width, Math.abs(dy) / (float)r.height);
        return new Point(Math.round(centerX += (dx *= scale)), Math.round(centerY += (dy *= scale)));
    }

    public Point getLocationEllipse(Point reference) {
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(this.getOwner().getBounds());
        r.translate(-1, -1);
        r.resize(1, 1);
        this.getOwner().translateToAbsolute(r);
        Point ref = r.getCenter().negate().translate(reference);
        if (ref.x == 0) {
            return new Point(reference.x, ref.y > 0 ? r.bottom() : r.y);
        }
        if (ref.y == 0) {
            return new Point(ref.x > 0 ? r.right() : r.x, reference.y);
        }
        float dx = ref.x > 0 ? 0.5f : -0.5f;
        float dy = ref.y > 0 ? 0.5f : -0.5f;
        float k = (float)(ref.y * r.width) / (float)(ref.x * r.height);
        k *= k;
        return r.getCenter().translate((int)((double)((float)r.width * dx) / Math.sqrt(1.0f + k)), (int)((double)((float)r.height * dy) / Math.sqrt(1.0f + 1.0f / k)));
    }

    public Point getLocationTriangle(Point reference) {
        Point intPoint;
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(this.getOwner().getBounds());
        r.translate(-1, -1);
        r.resize(1, 1);
        this.getOwner().translateToAbsolute(r);
        float centerX = (float)r.x + 0.5f * (float)r.width;
        float centerY = r.y + 2 * r.height / 3;
        PointList pl = ((NodeFigure)this.getOwner()).calculateTrianglePoints(r);
        Point p1 = ChsGeometry.getIntersection(reference, new Point(centerX, centerY), pl.getFirstPoint(), pl.getLastPoint());
        Point p2 = ChsGeometry.getIntersection(reference, new Point(centerX, centerY), pl.getFirstPoint(), pl.getMidpoint());
        Point p3 = ChsGeometry.getIntersection(reference, new Point(centerX, centerY), pl.getMidpoint(), pl.getLastPoint());
        Dimension diff = reference.getDifference(pl.getLastPoint());
        if (diff.height >= 0) {
            Point fixedP = pl.getLastPoint();
            boolean otherSide = false;
            if (centerX > (float)reference.x) {
                fixedP = pl.getMidpoint();
                otherSide = true;
            }
            int xx1 = (int)((float)fixedP.x - centerX);
            int xx2 = reference.x - fixedP.x;
            double yy1 = (float)fixedP.y - centerY;
            double yy2 = yy1 * ((double)xx2 / (double)xx1);
            intPoint = p3;
            if ((double)(reference.y - fixedP.y) <= yy2) {
                intPoint = p1;
                if (otherSide) {
                    intPoint = p2;
                }
            }
        } else {
            diff = reference.getDifference(pl.getFirstPoint());
            if (diff.width >= 0) {
                return p1;
            }
            return p2;
        }
        return intPoint;
    }
}

