/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.figure;

import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class CircleDecoration
extends Ellipse
implements RotatableDecoration {
    private int radius = 4;
    private Point center = new Point();
    private Point ref = new Point();
    private Point locToSet = new Point();

    public void setRadius(int radius) {
        this.erase();
        this.radius = Math.abs(radius);
        this.bounds = null;
        this.repaint();
    }

    @Override
    public void setLineWidth(int width) {
        super.setLineWidth(width);
    }

    @Override
    public Rectangle getBounds() {
        if (this.bounds == null) {
            int diameter = this.radius * 2;
            this.bounds = new Rectangle(this.center.x - this.radius, this.center.y - this.radius, diameter, diameter);
            this.bounds.expand(this.lineWidth / 2, this.lineWidth / 2);
        }
        return this.bounds;
    }

    @Override
    public void setLocation(Point p) {
        this.locToSet = p;
    }

    private void updateLocation(Point p) {
        if (this.center.equals(p)) {
            return;
        }
        this.center.setLocation(p);
        this.bounds = null;
    }

    @Override
    public void setReferencePoint(Point p) {
        this.ref = p;
        this.updateLocation(this.findBetterLocation(this.locToSet));
    }

    private Point findBetterLocation(Point loc) {
        Point p = new Point(loc);
        if (p.y == this.ref.y) {
            p.x = p.x + (this.ref.x > p.x ? this.radius - 1 : -this.radius + 1);
        } else {
            double r = Math.abs((double)(p.x - this.ref.x) / (double)(p.y - this.ref.y));
            double dy = (double)(this.radius - 1) / Math.sqrt(r * r + 1.0);
            double dx = dy * r;
            if (this.ref.x < p.x) {
                dx *= -1.0;
            }
            if (this.ref.y < p.y) {
                dy *= -1.0;
            }
            p.x = (int)Math.round((double)p.x + dx);
            p.y = (int)Math.round((double)p.y + dy);
        }
        return p;
    }
}

