/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.figure;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.gvt.figure.NodeFigure;

public class CompoundFigure
extends NodeFigure {
    int labelHeight;

    public CompoundFigure(Point locationAbs, Dimension size, int labelHeight, String text, String toolTipText, Font textFont, Color textColor, Color color, Color borderColor, int borderWidth, Color highlightColor, boolean highlight) {
        super(locationAbs, size, text, toolTipText, textFont, textColor, color, borderColor, borderWidth, "Rectangle", highlightColor, highlight, 1);
        this.labelHeight = labelHeight;
        this.label.setOpaque(true);
        this.label.setBackgroundColor(color);
        this.label.setBounds(new Rectangle(this.bounds.x, this.bounds.y + this.bounds.height - labelHeight, this.bounds.width, labelHeight));
        this.add(this.label);
        this.setBackgroundColor(ColorConstants.white);
        LineBorder border = new LineBorder(borderWidth);
        border.setColor(this.getForegroundColor());
        this.label.setBorder(border);
    }

    @Override
    public void updateColor(Color color) {
        this.label.setBackgroundColor(color);
    }

    @Override
    public void updateShape(String s) {
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        this.label.setBounds(new Rectangle(this.bounds.x, this.bounds.y + this.bounds.height - this.labelHeight, this.bounds.width, this.labelHeight));
        Rectangle rect = this.getBounds().getCopy();
        --rect.height;
        --rect.width;
        graphics.drawRectangle(rect);
    }
}

