/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.figure;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.MidpointLocator;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.gvt.figure.CircleDecoration;
import org.gvt.figure.HighlightLayer;

public class EdgeFigure
extends PolylineConnection {
    Label label;
    String style;
    String arrow;
    int[] dash;
    int width;
    boolean highlight;
    Color highlightColor;

    public EdgeFigure(String text, String tooltipText, Font textFont, Color textColor, Color color, String style, String arrow, int width, Color highlightColor, boolean highlight) {
        this.highlight = highlight;
        this.label = new Label();
        this.label.setOpaque(true);
        if (tooltipText != null) {
            this.label.setToolTip(new Label(tooltipText));
        }
        MidpointLocator locator = new MidpointLocator(this, 0);
        this.add((IFigure)this.label, locator);
        this.updateText(text);
        this.updateTextFont(textFont);
        this.updateTextColor(textColor);
        this.updateColor(color);
        this.updateStyle(style);
        this.updateArrow(arrow);
        this.updateWidth(width);
        this.updateHighlightColor(highlightColor);
    }

    public void updateText(String str) {
        this.label.setText(str);
        if (str.equals("")) {
            this.label.setVisible(false);
            this.label.setValid(false);
        } else {
            this.label.setVisible(true);
            this.label.setValid(true);
        }
    }

    public void updateTextFont(Font f) {
        this.label.setFont(f);
    }

    public void updateTextColor(Color c) {
        this.label.setForegroundColor(c);
    }

    public void updateColor(Color color) {
        this.setForegroundColor(color);
    }

    public void updateStyle(String s) {
        this.style = s;
        this.dash = (int[])(this.style.equals("Dashed") ? new int[]{5, 5} : null);
        this.repaint();
    }

    public void updateArrow(String s) {
        this.arrow = s;
        if (this.arrow.equals("None")) {
            this.setTargetDecoration(null);
            this.setSourceDecoration(null);
        } else if (this.arrow.equals("Target")) {
            this.setTargetDecoration(new PolygonDecoration());
            this.setSourceDecoration(null);
        } else if (this.arrow.equals("Source")) {
            this.setTargetDecoration(null);
            this.setSourceDecoration(new PolygonDecoration());
        } else if (this.arrow.equals("Both")) {
            this.setTargetDecoration(new PolygonDecoration());
            this.setSourceDecoration(new PolygonDecoration());
        } else if (this.arrow.equals("Modulation")) {
            PolygonDecoration pg = new PolygonDecoration();
            pg.setScale(4.0, 2.5);
            pg.setTemplate(new PointList(new int[]{-1, -1, -2, 0, -1, 1, 0, 0}));
            pg.setBackgroundColor(new Color(null, 255, 255, 255));
            this.setSourceDecoration(null);
            this.setTargetDecoration(pg);
        } else if (this.arrow.equals("Stimulation")) {
            PolygonDecoration pg = new PolygonDecoration();
            pg.setBackgroundColor(new Color(null, 255, 255, 255));
            this.setSourceDecoration(null);
            this.setTargetDecoration(pg);
        } else if (this.arrow.equals("Catalysis")) {
            CircleDecoration el = new CircleDecoration();
            this.setTargetDecoration(el);
        } else if (this.arrow.equals("Inhibition")) {
            PolylineDecoration pl = new PolylineDecoration();
            pl.setTemplate(new PointList(new int[]{0, -1, 0, 0, 0, 1}));
            pl.setLineWidth(3);
            this.setSourceDecoration(null);
            this.setTargetDecoration(pl);
        }
    }

    public void updateWidth(int w) {
        this.width = w;
        this.repaint();
    }

    public void updateHighlight(Layer highlight, boolean isHighlight) {
        this.highlight = isHighlight;
        if (this.highlight) {
            ((HighlightLayer)highlight).addHighlightToEdge(this);
        } else {
            ((HighlightLayer)highlight).removeHighlight(this);
        }
        this.repaint();
    }

    public void updateHighlightColor(Color color) {
        this.highlightColor = color;
        this.repaint();
    }

    @Override
    public void paintFigure(Graphics graphics) {
        this.fillShape(graphics);
        graphics.setLineWidth(this.width);
        if (this.dash != null) {
            graphics.setLineDash(this.dash);
        }
        this.outlineShape(graphics);
    }
}

