/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.figure;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class InfoFigure
extends Figure {
    private String info;
    private boolean not;
    private int i;
    private Dimension dim;
    protected static final Font FONT = new Font(null, "Segoe UI", 7, 0);
    protected static final Color DIGIT_BACK_COLOR = new Color(null, 250, 250, 250);
    protected static final Color DIGIT_FORE_COLOR = new Color(null, 0, 0, 0);
    protected static final Color DEFAULT_BACK_COLOR = new Color(null, 255, 255, 255);
    protected static final Color DEFAULT_FORE_COLOR = new Color(null, 50, 50, 50);
    protected static final Color DEFAULT_BORD_COLOR = new Color(null, 0, 0, 0);
    protected static final Color DEFAULT_NOT_COLOR = new Color(null, 200, 0, 0);
    protected static final Map<String, Color> backColorMap = new HashMap<String, Color>();
    protected static final Map<String, Color> foreColorMap = new HashMap<String, Color>();
    protected static final Map<String, Color> bordColorMap = new HashMap<String, Color>();
    protected static final Map<String, String> letterMap = new HashMap<String, String>();
    protected static final int OVAL = 0;
    protected static final int RECT = 1;

    public InfoFigure(String info, int i, Rectangle parentBounds, Dimension dim) {
        this.i = i;
        this.dim = dim;
        this.updateBounds(parentBounds);
        this.info = info.indexOf("@") > 0 ? info.substring(0, info.indexOf("@")).trim() : (info.indexOf("[") > 0 ? info.substring(0, info.indexOf("[")).trim() : info);
        this.not = false;
        if (info.startsWith("-")) {
            this.info = info.substring(1);
            this.not = true;
        }
        Label label = new Label(this.getLetter(this.info));
        this.setToolTip(new Label(this.getTooltipText(info)));
        Rectangle r = this.getBounds().getCopy();
        --r.y;
        ++r.x;
        label.setBounds(r);
        label.setFont(FONT);
        label.setForegroundColor(this.getForeColor(this.info));
        this.add(label);
    }

    protected String getTooltipText(String info) {
        return info;
    }

    @Override
    protected void paintFigure(Graphics g) {
        g.setAntialias(1);
        Rectangle r = this.getParent().getBounds().getCopy();
        r.x += 2;
        r.width -= 4;
        this.updateBounds(r);
        String lett = this.getLetter(this.info);
        Point p = this.getLoc(r);
        g.setBackgroundColor(this.getBackColor(this.info));
        g.setForegroundColor(this.getBordColor(this.info));
        int shp = this.getInfoShape(lett);
        int xoff = 1;
        int yoff = 1;
        switch (shp) {
            case 0: {
                g.fillOval(p.x + xoff, p.y, this.dim.width - xoff, this.dim.height - yoff);
                g.drawOval(p.x + xoff, p.y, this.dim.width - 1 - xoff, this.dim.height - 1 - yoff);
                break;
            }
            case 1: {
                g.fillRectangle(p.x + xoff, p.y, this.dim.width - xoff, this.dim.height - yoff);
                g.drawRectangle(p.x + xoff, p.y, this.dim.width - 1 - xoff, this.dim.height - 1 - yoff);
            }
        }
        if (this.not) {
            g.setForegroundColor(DEFAULT_NOT_COLOR);
            g.drawLine(p.x, p.y, p.x + this.dim.width, p.y + this.dim.height);
            g.drawLine(p.x + this.dim.width, p.y, p.x, p.y + this.dim.height);
        }
    }

    private void updateBounds(Rectangle parentBounds) {
        this.setBounds(new Rectangle(this.getLoc(parentBounds), this.dim));
    }

    private Point getLoc(Rectangle rec) {
        int spannum = this.i / 4;
        int spansign = this.i % 2 == 0 ? 1 : -1;
        int y = this.i % 4 < 2 ? rec.y : rec.height + rec.y - this.dim.height;
        int x = (this.i % 2 == 0 ? rec.x : rec.width + rec.x - this.dim.width) + spannum * spansign * this.dim.width;
        return new Point(x, y);
    }

    protected Color getBackColor(String info) {
        Color c = backColorMap.get(info.toLowerCase());
        return c == null ? (Character.isDigit(info.charAt(0)) ? DIGIT_BACK_COLOR : DEFAULT_BACK_COLOR) : c;
    }

    protected Color getForeColor(String info) {
        Color c = foreColorMap.get(info.toLowerCase());
        return c == null ? (Character.isDigit(info.charAt(0)) ? DIGIT_FORE_COLOR : DEFAULT_FORE_COLOR) : c;
    }

    protected Color getBordColor(String info) {
        Color c = bordColorMap.get(info.toLowerCase());
        return c == null ? DEFAULT_BORD_COLOR : c;
    }

    protected int getInfoShape(String letter) {
        if (Character.isDigit(letter.charAt(0)) || this.info.equals("active") || this.info.equals("active tf") || this.info.equals("native") || this.info.equals("inactive") || this.info.equals("residue modification, active") || this.info.equals("residue modification, inactive")) {
            return 1;
        }
        return 0;
    }

    protected String getLetter(String info) {
        String let = letterMap.get(info.toLowerCase());
        return let == null ? info.substring(0, 1).toLowerCase() : let;
    }

    private static void put(String s, Color b, Color f, String l) {
        assert (s != null);
        if (b != null) {
            backColorMap.put(s, b);
        }
        if (f != null) {
            foreColorMap.put(s, f);
        }
        if (l != null) {
            letterMap.put(s, l);
        }
    }

    static {
        Color WHITE = new Color(null, 255, 255, 255);
        Color PHOSPHO_BG = new Color(null, 230, 230, 100);
        Color PHOSPHO_FORE = new Color(null, 0, 0, 50);
        Color ACTIVE_BG = new Color(null, 50, 150, 50);
        Color ACTIVE_FORE = WHITE;
        Color INACTIVE_BG = new Color(null, 150, 50, 50);
        Color INACTIVE_FORE = WHITE;
        Color METHYL_FORE = new Color(null, 20, 20, 200);
        Color GLYCOSYL_FORE = new Color(null, 20, 20, 100);
        Color FUCOSYL_FORE = new Color(null, 20, 20, 100);
        Color UBIQUITIN_FORE = new Color(null, 100, 20, 20);
        InfoFigure.put("phosphorylation", PHOSPHO_BG, PHOSPHO_FORE, null);
        InfoFigure.put("phosphorylation site", PHOSPHO_BG, PHOSPHO_FORE, null);
        InfoFigure.put("phosphate group", PHOSPHO_BG, PHOSPHO_FORE, null);
        InfoFigure.put("phosphorylated residue", PHOSPHO_BG, PHOSPHO_FORE, null);
        InfoFigure.put("phosphorylated", PHOSPHO_BG, PHOSPHO_FORE, null);
        InfoFigure.put("o-phospho-l-serine", PHOSPHO_BG, PHOSPHO_FORE, "p");
        InfoFigure.put("o-phospho-l-threonine", PHOSPHO_BG, PHOSPHO_FORE, "p");
        InfoFigure.put("o-phospho-l-tyrosine", PHOSPHO_BG, PHOSPHO_FORE, "p");
        InfoFigure.put("o4'-phospho-l-tyrosine", PHOSPHO_BG, PHOSPHO_FORE, "p");
        InfoFigure.put("mi:0170", PHOSPHO_BG, PHOSPHO_FORE, "p");
        InfoFigure.put("phosres", PHOSPHO_BG, PHOSPHO_FORE, "p");
        InfoFigure.put("optyr", PHOSPHO_BG, PHOSPHO_FORE, "p");
        InfoFigure.put("opthr", PHOSPHO_BG, PHOSPHO_FORE, "p");
        InfoFigure.put("opser", PHOSPHO_BG, PHOSPHO_FORE, "p");
        InfoFigure.put("opser-6", PHOSPHO_BG, PHOSPHO_FORE, "p");
        InfoFigure.put("opthr-24", PHOSPHO_BG, PHOSPHO_FORE, "p");
        InfoFigure.put("opthr-10", PHOSPHO_BG, PHOSPHO_FORE, "p");
        InfoFigure.put("active", ACTIVE_BG, ACTIVE_FORE, null);
        InfoFigure.put("inactive", INACTIVE_BG, INACTIVE_FORE, null);
        InfoFigure.put("residue modification, inactive", INACTIVE_BG, INACTIVE_FORE, "i");
        InfoFigure.put("residue modification, active", ACTIVE_BG, ACTIVE_FORE, "a");
        InfoFigure.put("native", new Color(null, 200, 200, 200), new Color(null, 100, 100, 100), null);
        InfoFigure.put("ubiquitination site", null, UBIQUITIN_FORE, null);
        InfoFigure.put("ubiquitination", null, UBIQUITIN_FORE, null);
        InfoFigure.put("ubiquitinylated lysine", null, UBIQUITIN_FORE, null);
        InfoFigure.put("chain coordinates", new Color(null, 150, 150, 150), WHITE, null);
        InfoFigure.put("methylated lysine", null, METHYL_FORE, null);
        InfoFigure.put("n6,n6-dimethyl-l-lysine", null, METHYL_FORE, "m");
        InfoFigure.put("n6-methyl-l-lysine", null, METHYL_FORE, "m");
        InfoFigure.put("n-acetylated l-lysine", null, new Color(null, 20, 80, 20), "a");
        InfoFigure.put("n4-glycosyl-l-asparagine", null, GLYCOSYL_FORE, "g");
        InfoFigure.put("o-glycosyl-l-threonine", null, GLYCOSYL_FORE, "g");
        InfoFigure.put("o-glucosyl-l-serine", null, GLYCOSYL_FORE, "g");
        InfoFigure.put("o-fucosyl-l-threonine", null, FUCOSYL_FORE, "f");
        InfoFigure.put("o-fucosyl-l-serine", null, FUCOSYL_FORE, "f");
    }
}

