/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.cbio.causality.idmapping.HGNC;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gvt.ChisioMain;
import org.gvt.gui.AddEntityDialog;
import org.gvt.gui.ExportToSIFL3Dialog;
import org.gvt.model.sifl3.SIFGraph;
import org.gvt.util.EntityHolder;
import org.gvt.util.QueryOptionsPack;

public abstract class AbstractQueryParamDialog
extends Dialog {
    protected Label infoLabel;
    protected Button addButton;
    protected Button removeButton;
    protected org.eclipse.swt.widgets.List entityList;
    protected Group resultViewGroup;
    protected Button currentViewButton;
    protected Button newViewButton;
    protected Group exeCancelDefaultGroup;
    protected Button executeButton;
    protected Button cancelButton;
    protected Button defaultButton;
    protected Label lengthLimitLabel;
    protected Text lengthLimit;
    protected Button shortestPlusKButton;
    protected Text shortestPlusK;
    protected Button strictButton;
    protected Group streamDirectionGroup;
    protected Button downstreamButton;
    protected Button upstreamButton;
    protected Button bothButton;
    protected EntityListGroup sourceElg;
    protected EntityListGroup targetElg;
    protected SymbolText sourceST;
    protected SymbolText targetST;
    protected boolean forSIF;
    protected Button sifTypeButton;
    protected List<SIFType> selectedTypes;
    protected Shell shell;
    protected ChisioMain main;
    protected KeyAdapter keyAdapter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent arg0) {
            arg0.doit = this.isDigit(arg0.keyCode);
        }

        public boolean isDigit(int keyCode) {
            return Character.isDigit(keyCode) || keyCode == 127 || keyCode == 8 || keyCode == 0x1000003 || keyCode == 0x1000004;
        }
    };
    public static final boolean DOWNSTREAM = true;
    public static final boolean UPSTREAM = false;
    public static final boolean CURRENT_VIEW = true;
    public static final int DEFAULT_LENGTH_LIMIT = 1;
    public static final int DEFAULT_SHORTEST_PLUS_K = 0;
    public static final boolean LIMIT_TYPE = true;
    public static final boolean STRICT = false;

    public AbstractQueryParamDialog(ChisioMain main) {
        this(main, false);
    }

    public AbstractQueryParamDialog(ChisioMain main, boolean forSIF) {
        super(main.getShell(), 0);
        this.main = main;
        this.forSIF = forSIF;
    }

    protected void createContents(QueryOptionsPack opt) {
        this.shell = new Shell(this.getParent(), 67696);
        this.infoLabel = new Label(this.shell, 0);
        GridData gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 8;
        gridData.verticalSpan = 6;
        this.infoLabel.setLayoutData(gridData);
        if (this.forSIF) {
            this.selectedTypes = opt.getSifTypes();
        }
    }

    protected void createList(int horizontalSpan, int verticalSpan, int widthHint, int numberOfItems) {
        this.entityList = new org.eclipse.swt.widgets.List(this.shell, 2818);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = verticalSpan;
        gridData.horizontalSpan = horizontalSpan;
        gridData.heightHint = this.entityList.getItemHeight() * numberOfItems;
        gridData.widthHint = widthHint;
        this.entityList.setLayoutData(gridData);
    }

    protected void createResultViewGroup(int horizontalSpan, int verticalSpan) {
        this.resultViewGroup = new Group(this.shell, 0);
        this.resultViewGroup.setText("Show result in");
        GridData gridData = new GridData(4, 1, false, false);
        gridData.horizontalSpan = horizontalSpan;
        gridData.verticalSpan = verticalSpan;
        this.resultViewGroup.setLayoutData(gridData);
        this.resultViewGroup.setLayout(new GridLayout());
        this.currentViewButton = new Button(this.resultViewGroup, 16);
        this.currentViewButton.setText("Current view");
        gridData = new GridData(1, 2, false, false);
        this.currentViewButton.setLayoutData(gridData);
        this.newViewButton = new Button(this.resultViewGroup, 16);
        this.newViewButton.setText("New view");
        gridData = new GridData(1, 2, false, false);
        this.newViewButton.setLayoutData(gridData);
    }

    protected void createLengthLimit(int horizontalSpanLabel, int verticalSpanLabel, int horizontalSpanText, int verticalSpanText, int minTextWidth) {
        this.lengthLimitLabel = new Label(this.shell, 0);
        this.lengthLimitLabel.setText("Length limit");
        GridData gridData = new GridData(3, 2, false, false);
        gridData.horizontalSpan = horizontalSpanLabel;
        gridData.verticalSpan = verticalSpanLabel;
        this.lengthLimitLabel.setLayoutData(gridData);
        this.lengthLimit = new Text(this.shell, 2048);
        this.lengthLimit.addKeyListener(this.keyAdapter);
        gridData = new GridData(1, 2, false, false);
        gridData.horizontalSpan = horizontalSpanText;
        gridData.verticalSpan = verticalSpanText;
        gridData.widthHint = minTextWidth;
        this.lengthLimit.setLayoutData(gridData);
    }

    protected void createCancelButton(GridData gridData) {
        this.cancelButton.setText("Cancel");
        this.cancelButton.setLayoutData(gridData);
        this.cancelButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                AbstractQueryParamDialog.this.shell.close();
            }
        });
    }

    protected void createExeCancDefGroup(final QueryOptionsPack opt, int horizontalSpan) {
        this.exeCancelDefaultGroup = new Group(this.shell, 0);
        GridData gridData = new GridData(4, 2, false, false);
        gridData.horizontalSpan = horizontalSpan;
        this.exeCancelDefaultGroup.setLayoutData(gridData);
        this.exeCancelDefaultGroup.setLayout(new GridLayout(4, true));
        if (this.forSIF) {
            this.sifTypeButton = new Button(this.exeCancelDefaultGroup, 0);
            this.sifTypeButton.setBackground(new Color(null, 255, 255, 255));
            gridData = new GridData(1, 2, true, false);
            this.sifTypeButton.setLayoutData(gridData);
            this.sifTypeButton.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    ArrayList<SIFType> selection = new ArrayList<SIFType>(AbstractQueryParamDialog.this.selectedTypes);
                    ExportToSIFL3Dialog dialog = new ExportToSIFL3Dialog(AbstractQueryParamDialog.this.main.getShell(), SIFGraph.getPossibleRuleTypes(), selection);
                    if (dialog.open()) {
                        AbstractQueryParamDialog.this.selectedTypes.clear();
                        AbstractQueryParamDialog.this.selectedTypes.addAll(selection);
                        AbstractQueryParamDialog.this.updateSIFTypeButtonText();
                    }
                }
            });
            if (this.selectedTypes == null) {
                this.selectedTypes = new ArrayList<SIFType>();
            }
            this.updateSIFTypeButtonText();
        }
        this.executeButton = new Button(this.exeCancelDefaultGroup, 0);
        this.executeButton.setText("Execute");
        gridData = new GridData(3, 2, true, false);
        this.executeButton.setLayoutData(gridData);
        this.executeButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                if (AbstractQueryParamDialog.this.sourceElg != null && AbstractQueryParamDialog.this.getAddedSourceEntities().isEmpty() || AbstractQueryParamDialog.this.sourceST != null && AbstractQueryParamDialog.this.sourceST.getSymbols().isEmpty()) {
                    MessageDialog.openError(AbstractQueryParamDialog.this.main.getShell(), "Error!", "Add Source Molecule!");
                    return;
                }
                if (AbstractQueryParamDialog.this.targetElg != null && AbstractQueryParamDialog.this.getAddedTargetEntities().isEmpty() || AbstractQueryParamDialog.this.targetST != null && AbstractQueryParamDialog.this.targetST.getSymbols().isEmpty()) {
                    MessageDialog.openError(AbstractQueryParamDialog.this.main.getShell(), "Error!", "Add Target Molecule!");
                    return;
                }
                if (AbstractQueryParamDialog.this.forSIF && AbstractQueryParamDialog.this.selectedTypes.isEmpty()) {
                    MessageDialog.openError(AbstractQueryParamDialog.this.main.getShell(), "Error!", "Please select at least one interaction type.");
                    return;
                }
                List<String> unkwn = AbstractQueryParamDialog.this.getUnknownSymbols();
                if (!unkwn.isEmpty()) {
                    String s = "";
                    for (String us : unkwn) {
                        s = s + " " + us;
                    }
                    MessageDialog.openError(AbstractQueryParamDialog.this.main.getShell(), "Error!", "Unknown symbol" + (unkwn.size() > 1 ? "s" : "") + ": " + s);
                    return;
                }
                AbstractQueryParamDialog.this.storeValuesToOptionsPack(opt);
                opt.setCancel(false);
                AbstractQueryParamDialog.this.shell.close();
            }
        });
        this.cancelButton = new Button(this.exeCancelDefaultGroup, 0);
        gridData = new GridData(2, 2, true, false);
        this.createCancelButton(gridData);
        this.defaultButton = new Button(this.exeCancelDefaultGroup, 0);
        this.defaultButton.setText("Default");
        gridData = new GridData(1, 2, true, false);
        this.defaultButton.setLayoutData(gridData);
        this.defaultButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                AbstractQueryParamDialog.this.setDefaultQueryDialogOptions();
            }
        });
    }

    private void updateSIFTypeButtonText() {
        if (this.selectedTypes.isEmpty()) {
            this.sifTypeButton.setText("Select interaction type");
        } else {
            this.sifTypeButton.setText(this.selectedTypes.size() + " type" + (this.selectedTypes.size() > 1 ? "s" : "") + " selected");
        }
    }

    protected void createStreamDirectionGroup(int horizontalSpan, int verticalSpan, boolean isBothButton) {
        this.streamDirectionGroup = new Group(this.shell, 0);
        this.streamDirectionGroup.setText("Stream direction");
        GridData gridData = new GridData(4, 1, false, false);
        gridData.horizontalSpan = horizontalSpan;
        gridData.verticalSpan = verticalSpan;
        this.streamDirectionGroup.setLayoutData(gridData);
        this.streamDirectionGroup.setLayout(new GridLayout());
        this.downstreamButton = new Button(this.streamDirectionGroup, 16);
        this.downstreamButton.setText("Downstream");
        gridData = new GridData(1, 2, false, false);
        this.downstreamButton.setLayoutData(gridData);
        this.upstreamButton = new Button(this.streamDirectionGroup, 16);
        this.upstreamButton.setText("Upstream");
        gridData = new GridData(1, 2, false, false);
        this.upstreamButton.setLayoutData(gridData);
        if (isBothButton) {
            this.bothButton = new Button(this.streamDirectionGroup, 16);
            this.bothButton.setText("Both");
            gridData = new GridData(1, 2, false, false);
            this.bothButton.setLayoutData(gridData);
        }
    }

    protected void createLimitTypesGroup() {
        Group limitTypeGroup = new Group(this.shell, 0);
        limitTypeGroup.setText("Stop distance");
        GridData gridData = new GridData(4, 1, false, false);
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 2;
        limitTypeGroup.setLayoutData(gridData);
        limitTypeGroup.setLayout(new GridLayout(2, true));
        this.lengthLimitLabel = new Label(limitTypeGroup, 0);
        this.lengthLimitLabel.setText("Length limit");
        gridData = new GridData(1, 2, false, false);
        this.lengthLimitLabel.setLayoutData(gridData);
        this.lengthLimit = new Text(limitTypeGroup, 2048);
        this.lengthLimit.addKeyListener(this.keyAdapter);
        gridData = new GridData(4, 2, false, false);
        this.lengthLimit.setLayoutData(gridData);
        this.shortestPlusKButton = new Button(limitTypeGroup, 32);
        this.shortestPlusKButton.setText("Shortest+k");
        gridData = new GridData(1, 2, false, false);
        this.shortestPlusKButton.setLayoutData(gridData);
        this.shortestPlusKButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                AbstractQueryParamDialog.this.shortestPlusK.setEnabled(AbstractQueryParamDialog.this.shortestPlusKButton.getSelection());
            }
        });
        this.shortestPlusK = new Text(limitTypeGroup, 2048);
        this.shortestPlusK.addKeyListener(this.keyAdapter);
        gridData = new GridData(4, 2, false, false);
        this.shortestPlusK.setLayoutData(gridData);
        this.strictButton = new Button(this.shell, 96);
        this.strictButton.setText("Ignore source-source/target-target paths");
        gridData = new GridData(2, 2, false, false);
        gridData.verticalSpan = 2;
        gridData.horizontalSpan = 4;
        this.strictButton.setLayoutData(gridData);
    }

    public void setDefaultQueryDialogOptions() {
        if (!this.currentViewButton.isEnabled()) {
            this.currentViewButton.setSelection(false);
            this.newViewButton.setSelection(true);
        } else {
            this.currentViewButton.setSelection(true);
            this.newViewButton.setSelection(false);
        }
        this.lengthLimit.setText(String.valueOf(1));
        if (this.bothButton != null) {
            this.bothButton.setSelection(true);
            this.downstreamButton.setSelection(false);
            this.upstreamButton.setSelection(false);
        } else if (this.downstreamButton != null) {
            this.downstreamButton.setSelection(true);
            this.upstreamButton.setSelection(false);
        }
        if (this.shortestPlusK != null) {
            this.shortestPlusK.setText(String.valueOf(0));
            this.shortestPlusKButton.setSelection(false);
            this.strictButton.setSelection(false);
        }
    }

    public void setInitialValues(QueryOptionsPack opt) {
        if (this.main.getPathwayGraph() == null) {
            this.newViewButton.setSelection(true);
            this.currentViewButton.setSelection(false);
            this.currentViewButton.setEnabled(false);
            opt.setCurrentView(false);
        }
        if (opt.isCurrentView()) {
            this.currentViewButton.setSelection(true);
        } else {
            this.newViewButton.setSelection(true);
        }
        this.lengthLimit.setText(String.valueOf(opt.getLengthLimit()));
        if (this.sourceST != null && opt.getSourceList() != null) {
            this.sourceST.symbolText.setText(opt.getOneStringSources());
        }
        if (this.targetST != null && opt.getTargetList() != null) {
            this.targetST.symbolText.setText(opt.getOneStringTargets());
        }
        if (this.downstreamButton != null) {
            if (opt.isDownstream() && opt.isUpstream() && this.bothButton != null) {
                this.bothButton.setSelection(true);
            } else if (opt.isDownstream()) {
                this.downstreamButton.setSelection(true);
            } else if (opt.isUpstream()) {
                this.upstreamButton.setSelection(true);
            }
        }
        if (this.strictButton != null && opt.isStrict()) {
            this.strictButton.setSelection(true);
        }
        if (this.shortestPlusK != null) {
            this.shortestPlusK.setText(String.valueOf(opt.getShortestPlusKLimit()));
        }
        if (this.shortestPlusKButton != null) {
            this.shortestPlusKButton.setSelection(!opt.getLimitType());
        }
    }

    public void storeValuesToOptionsPack(QueryOptionsPack opt) {
        opt.setLengthLimit(Integer.parseInt(this.lengthLimit.getText()));
        if (this.currentViewButton.getSelection()) {
            opt.setCurrentView(true);
        } else {
            opt.setCurrentView(false);
        }
        if (this.downstreamButton != null) {
            if (this.downstreamButton.getSelection()) {
                opt.setDownstream(true);
                opt.setUpstream(false);
            } else if (this.upstreamButton.getSelection()) {
                opt.setDownstream(false);
                opt.setUpstream(true);
            } else {
                opt.setDownstream(true);
                opt.setUpstream(true);
            }
        }
        if (this.shortestPlusKButton != null) {
            opt.setLimitType(!this.shortestPlusKButton.getSelection());
            opt.setShortestPlusKLimit(Integer.parseInt(this.shortestPlusK.getText()));
        }
        if (this.strictButton != null && this.strictButton.getSelection()) {
            opt.setStrict(true);
        } else {
            opt.setStrict(false);
        }
        if (this.sourceST != null) {
            opt.setSourceList(this.sourceST.getSymbols());
        }
        if (this.targetST != null) {
            opt.setTargetList(this.targetST.getSymbols());
        }
        if (this.forSIF) {
            opt.setSifTypes(this.selectedTypes);
        }
    }

    public List<EntityHolder> getAddedSourceEntities() {
        if (this.sourceElg != null) {
            return this.sourceElg.addedEntities;
        }
        return Collections.emptyList();
    }

    public List<EntityHolder> getAddedTargetEntities() {
        if (this.targetElg != null) {
            return this.targetElg.addedEntities;
        }
        return Collections.emptyList();
    }

    public QueryOptionsPack open(QueryOptionsPack opt) {
        this.createContents(opt);
        this.shell.setLocation(this.getParent().getLocation().x + this.getParent().getSize().x / 2 - this.shell.getSize().x / 2, this.getParent().getLocation().y + this.getParent().getSize().y / 2 - this.shell.getSize().y / 2);
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return opt;
    }

    protected List<String> getUnknownSymbols() {
        ArrayList<String> list = new ArrayList<String>();
        this.collectUnknownSymbols(this.sourceST, list);
        this.collectUnknownSymbols(this.targetST, list);
        return list;
    }

    private void collectUnknownSymbols(SymbolText st, List<String> unkwn) {
        if (st != null) {
            for (String s : st.getSymbols()) {
                if (QueryOptionsPack.isChemID(s) || HGNC.getSymbol(s) != null || unkwn.contains(s)) continue;
                unkwn.add(s);
            }
        }
    }

    class SymbolText
    extends Composite {
        protected Label label;
        protected Text symbolText;

        SymbolText(Composite composite, int i) {
            super(composite, i);
        }

        public void init(String labelText) {
            GridLayout lay = new GridLayout();
            lay.numColumns = 1;
            this.setLayout(lay);
            this.label = new Label(this, 0);
            this.label.setText(labelText == null ? "Gene symbols:" : labelText);
            GridData gridData = new GridData(4, 4, true, false);
            gridData.verticalSpan = 1;
            gridData.horizontalSpan = 1;
            this.label.setLayoutData(gridData);
            this.symbolText = new Text(this, 2626);
            gridData = new GridData(4, 4, true, true);
            gridData.verticalSpan = 1;
            gridData.horizontalSpan = 1;
            this.symbolText.setLayoutData(gridData);
        }

        public List<String> getSymbols() {
            ArrayList<String> list = new ArrayList<String>();
            String text = this.symbolText.getText();
            for (String s : text.replaceAll(",", " ").split("\\s+")) {
                if (s == null || (s = s.trim()).length() <= 0 || list.contains(s)) continue;
                list.add(s);
            }
            return list;
        }
    }

    class EntityListGroup
    extends Composite {
        protected org.eclipse.swt.widgets.List entityList;
        protected Button addButton;
        protected Button removeButton;
        Collection<EntityHolder> allEntities;
        List<EntityHolder> addedEntities;

        public EntityListGroup(Composite composite, int i, Collection<EntityHolder> allEntities) {
            super(composite, i);
            this.allEntities = allEntities;
        }

        public void init() {
            GridLayout lay = new GridLayout();
            lay.numColumns = 2;
            lay.makeColumnsEqualWidth = true;
            this.setLayout(lay);
            this.addedEntities = new ArrayList<EntityHolder>();
            this.entityList = new org.eclipse.swt.widgets.List(this, 2818);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.verticalSpan = 1;
            gridData.horizontalSpan = 2;
            this.entityList.setLayoutData(gridData);
            this.addButton = new Button(this, 0);
            this.addButton.setText("Add...");
            gridData = new GridData(3, 1, true, false);
            gridData.minimumWidth = 50;
            gridData.horizontalIndent = 5;
            this.addButton.setLayoutData(gridData);
            this.addButton.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    AddEntityDialog addEntityDialog = new AddEntityDialog(new Shell(), EntityListGroup.this.allEntities);
                    boolean addPressed = addEntityDialog.open();
                    if (addPressed) {
                        for (EntityHolder entity2 : addEntityDialog.getSelectedEntities()) {
                            if (EntityListGroup.this.addedEntities.contains(entity2)) continue;
                            EntityListGroup.this.entityList.add(entity2.getName());
                            EntityListGroup.this.addedEntities.add(entity2);
                        }
                    }
                }
            });
            this.removeButton = new Button(this, 0);
            this.removeButton.setText("Remove");
            gridData = new GridData(1, 1, true, false);
            gridData.horizontalIndent = 5;
            gridData.minimumWidth = 50;
            this.removeButton.setLayoutData(gridData);
            this.removeButton.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    String[] selectionResult;
                    for (String selected : selectionResult = EntityListGroup.this.entityList.getSelection()) {
                        for (int j = 0; j < EntityListGroup.this.addedEntities.size(); ++j) {
                            EntityHolder entity2 = EntityListGroup.this.addedEntities.get(j);
                            if (selected == null || !selected.equals(entity2.getName())) continue;
                            EntityListGroup.this.addedEntities.remove(j);
                            EntityListGroup.this.entityList.remove(selected);
                        }
                    }
                }
            });
        }
    }
}

