/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gvt.util.EntityHolder;

public class AddEntityDialog
extends Dialog {
    private ArrayList<EntityHolder> possibleEntities;
    private List<EntityHolder> selectedEntities;
    private Collection<EntityHolder> allEntities;
    private Map<String, EntityHolder> entityKeyNameMap;
    private boolean addPressed;
    private Text searchKey;
    private Button filterButton;
    private org.eclipse.swt.widgets.List entityList;
    private Set<String> possibleEntityNames;
    private String[] allEntityNames;
    private Button addButton;
    private Button cancelButton;
    private Button showAllButton;
    private Shell shell;
    protected KeyAdapter keyAdapter = new KeyAdapter(){};

    public AddEntityDialog(Shell shell, Collection<EntityHolder> allEntities) {
        super(shell);
        this.entityKeyNameMap = new HashMap<String, EntityHolder>();
        this.selectedEntities = new ArrayList<EntityHolder>();
        this.possibleEntities = new ArrayList();
        this.possibleEntityNames = new HashSet<String>();
        for (EntityHolder entity2 : allEntities) {
            String keyName = entity2.getName();
            this.possibleEntityNames.add(keyName);
            this.entityKeyNameMap.put(keyName, entity2);
            this.possibleEntities.add(entity2);
        }
        this.allEntityNames = this.toSortedArray(this.possibleEntityNames);
        this.allEntities = allEntities;
        this.shell = shell;
        this.addPressed = false;
    }

    public boolean open() {
        this.createContents();
        this.shell.setLocation(this.getParent().getLocation().x + this.getParent().getSize().x / 2 - this.shell.getSize().x / 2, this.getParent().getLocation().y + this.getParent().getSize().y / 2 - this.shell.getSize().y / 2);
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.addPressed;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setText("Add Entity");
        ButtonAdapter adapter = new ButtonAdapter();
        ImageDescriptor id = ImageDescriptor.createFromFile(AddEntityDialog.class, "../icon/cbe-icon.png");
        this.shell.setImage(id.createImage());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.shell.setLayout(gridLayout);
        this.searchKey = new Text(this.shell, 2048);
        this.searchKey.addKeyListener(this.keyAdapter);
        GridData gridData = new GridData(4, 2, true, false);
        gridData.horizontalSpan = 2;
        gridData.minimumWidth = 200;
        this.searchKey.setLayoutData(gridData);
        this.filterButton = new Button(this.shell, 0);
        this.filterButton.setText("Filter");
        this.filterButton.addSelectionListener(adapter);
        gridData = new GridData(4, 2, false, false);
        this.filterButton.setLayoutData(gridData);
        this.entityList = new org.eclipse.swt.widgets.List(this.shell, 2818);
        this.entityList.setItems(this.allEntityNames);
        gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = 20;
        gridData.horizontalSpan = 3;
        gridData.heightHint = this.entityList.getItemHeight() * 10;
        gridData.widthHint = 500;
        this.entityList.setLayoutData(gridData);
        this.showAllButton = new Button(this.shell, 0);
        this.showAllButton.setText("Show All");
        this.showAllButton.addSelectionListener(adapter);
        gridData = new GridData(2, 2, false, false);
        this.showAllButton.setLayoutData(gridData);
        this.addButton = new Button(this.shell, 0);
        this.addButton.setText("Add");
        this.addButton.addSelectionListener(adapter);
        gridData = new GridData(2, 2, true, false);
        gridData.minimumWidth = 100;
        gridData.horizontalIndent = 5;
        this.addButton.setLayoutData(gridData);
        this.cancelButton = new Button(this.shell, 0);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addSelectionListener(adapter);
        gridData = new GridData(2, 2, false, false);
        gridData.horizontalIndent = 5;
        this.cancelButton.setLayoutData(gridData);
        this.shell.pack();
    }

    public void filterEntities() {
        String searchKeyWord = this.searchKey.getText();
        this.selectedEntities.clear();
        if (searchKeyWord == null) {
            this.possibleEntities = new ArrayList<EntityHolder>(this.allEntities);
            return;
        }
        this.possibleEntities.clear();
        this.possibleEntityNames.clear();
        for (EntityHolder entity2 : this.allEntities) {
            String name = entity2.getName();
            if (!entity2.containsWord(searchKeyWord)) continue;
            this.possibleEntities.add(entity2);
            this.possibleEntityNames.add(name);
        }
    }

    private void saveSelectedEntities() {
        String[] selectionResult;
        this.selectedEntities.clear();
        for (String selected : selectionResult = this.entityList.getSelection()) {
            for (EntityHolder entity2 : this.possibleEntities) {
                if (selected == null || !selected.equals(entity2.getName())) continue;
                this.selectedEntities.add(entity2);
            }
        }
    }

    public List<EntityHolder> getSelectedEntities() {
        return this.selectedEntities;
    }

    private String[] toSortedArray(Set<String> entityNames) {
        Object[] entityNameArray = new String[entityNames.size()];
        entityNameArray = entityNames.toArray(entityNameArray);
        Arrays.sort(entityNameArray);
        return entityNameArray;
    }

    private void showAllEntities() {
        this.possibleEntities = new ArrayList<EntityHolder>(this.allEntities);
        this.selectedEntities.clear();
        this.entityList.removeAll();
        this.entityList.setItems(this.allEntityNames);
        this.searchKey.setText("");
    }

    private void updateList() {
        this.entityList.removeAll();
        this.entityList.setItems(this.toSortedArray(this.possibleEntityNames));
    }

    class ButtonAdapter
    extends SelectionAdapter {
        ButtonAdapter() {
        }

        @Override
        public void widgetSelected(SelectionEvent arg) {
            Button button = (Button)arg.widget;
            if (button == AddEntityDialog.this.addButton) {
                AddEntityDialog.this.saveSelectedEntities();
                AddEntityDialog.this.addPressed = true;
                AddEntityDialog.this.shell.dispose();
            } else if (button == AddEntityDialog.this.cancelButton) {
                AddEntityDialog.this.addPressed = false;
                AddEntityDialog.this.shell.dispose();
            } else if (button == AddEntityDialog.this.filterButton) {
                AddEntityDialog.this.filterEntities();
                AddEntityDialog.this.updateList();
            } else if (button == AddEntityDialog.this.showAllButton) {
                AddEntityDialog.this.showAllEntities();
            }
        }
    }
}

