/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.gui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gvt.ChisioMain;
import org.gvt.gui.AbstractQueryParamDialog;
import org.gvt.gui.AddCompartmentDialog;
import org.gvt.util.BioPAXUtil;
import org.gvt.util.QueryOptionsPack;

public class CompartmentQueryParamWithEntitiesDialog
extends AbstractQueryParamDialog {
    private org.eclipse.swt.widgets.List targetCompartmentList;
    List<String> allCompartments;
    List<String> sourceAddedCompartments;
    List<String> targetAddedCompartments;

    public List<String> getSourceAddedCompartments() {
        return this.sourceAddedCompartments;
    }

    public List<String> getTargetAddedCompartments() {
        return this.targetAddedCompartments;
    }

    public CompartmentQueryParamWithEntitiesDialog(ChisioMain main) {
        super(main);
        this.allCompartments = new ArrayList<String>(BioPAXUtil.getCellularLocations(main.getBioPAXModel()));
        this.sourceAddedCompartments = new ArrayList<String>();
        this.targetAddedCompartments = new ArrayList<String>();
    }

    @Override
    protected void createContents(QueryOptionsPack opt) {
        super.createContents(opt);
        this.shell.setText("Compartment Query Properties");
        this.infoLabel.setText("Find all paths of specified length limit that originate in one compartment and end in another compartment");
        ImageDescriptor id = ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbe-icon.png");
        this.shell.setImage(id.createImage());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 8;
        this.shell.setLayout(gridLayout);
        Label sourceLabel = new Label(this.shell, 0);
        sourceLabel.setText("Source");
        GridData gridData = new GridData(2, 3, false, false);
        gridData.horizontalSpan = 2;
        sourceLabel.setLayoutData(gridData);
        Label targetLabel = new Label(this.shell, 0);
        targetLabel.setText("Target");
        gridData = new GridData(2, 3, false, false);
        gridData.horizontalSpan = 2;
        targetLabel.setLayoutData(gridData);
        this.createResultViewGroup(2, 2);
        Group limitTypeGroup = new Group(this.shell, 0);
        limitTypeGroup.setText("Stop distance");
        gridData = new GridData(4, 1, false, false);
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 2;
        limitTypeGroup.setLayoutData(gridData);
        limitTypeGroup.setLayout(new GridLayout(2, true));
        this.lengthLimitLabel = new Label(limitTypeGroup, 0);
        this.lengthLimitLabel.setText("Length limit");
        gridData = new GridData(1, 2, false, false);
        this.lengthLimitLabel.setLayoutData(gridData);
        this.lengthLimit = new Text(limitTypeGroup, 2048);
        this.lengthLimit.addKeyListener(this.keyAdapter);
        gridData = new GridData(4, 2, false, false);
        this.lengthLimit.setLayoutData(gridData);
        this.shortestPlusKButton = new Button(limitTypeGroup, 32);
        this.shortestPlusKButton.setText("Shortest+k");
        gridData = new GridData(1, 2, false, false);
        this.shortestPlusKButton.setLayoutData(gridData);
        this.shortestPlusK = new Text(limitTypeGroup, 2048);
        this.shortestPlusK.addKeyListener(this.keyAdapter);
        gridData = new GridData(4, 2, false, false);
        this.shortestPlusK.setLayoutData(gridData);
        this.createList(2, 2, 150, 5);
        this.targetCompartmentList = new org.eclipse.swt.widgets.List(this.shell, 2818);
        gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = 2;
        gridData.horizontalSpan = 2;
        gridData.heightHint = this.targetCompartmentList.getItemHeight() * 5;
        gridData.widthHint = 150;
        this.targetCompartmentList.setLayoutData(gridData);
        this.strictButton = new Button(this.shell, 96);
        this.strictButton.setText("Ignore source-source/target-target paths");
        gridData = new GridData(2, 2, false, false);
        gridData.verticalSpan = 2;
        gridData.horizontalSpan = 4;
        this.strictButton.setLayoutData(gridData);
        this.addButton = new Button(this.shell, 0);
        this.addButton.setText("Add...");
        gridData = new GridData(3, 1, true, false);
        gridData.minimumWidth = 100;
        gridData.horizontalIndent = 5;
        this.addButton.setLayoutData(gridData);
        this.addButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                AddCompartmentDialog addCompartment = new AddCompartmentDialog(new Shell(), CompartmentQueryParamWithEntitiesDialog.this.allCompartments);
                boolean addPressed = addCompartment.open();
                if (addPressed) {
                    for (String compartment : addCompartment.getSelectedCompartments()) {
                        if (CompartmentQueryParamWithEntitiesDialog.this.sourceAddedCompartments.contains(compartment)) continue;
                        CompartmentQueryParamWithEntitiesDialog.this.entityList.add(compartment);
                        CompartmentQueryParamWithEntitiesDialog.this.sourceAddedCompartments.add(compartment);
                    }
                }
            }
        });
        this.removeButton = new Button(this.shell, 0);
        this.removeButton.setText("Remove");
        gridData = new GridData(1, 1, true, false);
        gridData.horizontalIndent = 5;
        gridData.minimumWidth = 100;
        this.removeButton.setLayoutData(gridData);
        this.removeButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                String[] selectionResult;
                for (String selected : selectionResult = CompartmentQueryParamWithEntitiesDialog.this.entityList.getSelection()) {
                    for (int j = 0; j < CompartmentQueryParamWithEntitiesDialog.this.sourceAddedCompartments.size(); ++j) {
                        String compartment = CompartmentQueryParamWithEntitiesDialog.this.sourceAddedCompartments.get(j);
                        if (selected == null || !selected.equals(compartment)) continue;
                        CompartmentQueryParamWithEntitiesDialog.this.sourceAddedCompartments.remove(j);
                        CompartmentQueryParamWithEntitiesDialog.this.entityList.remove(selected);
                    }
                }
            }
        });
        Button targetAddButton = new Button(this.shell, 0);
        targetAddButton.setText("Add...");
        gridData = new GridData(3, 1, true, false);
        gridData.minimumWidth = 100;
        gridData.horizontalIndent = 5;
        targetAddButton.setLayoutData(gridData);
        targetAddButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                AddCompartmentDialog addCompartment = new AddCompartmentDialog(new Shell(), CompartmentQueryParamWithEntitiesDialog.this.allCompartments);
                boolean addPressed = addCompartment.open();
                if (addPressed) {
                    for (String compartment : addCompartment.getSelectedCompartments()) {
                        if (CompartmentQueryParamWithEntitiesDialog.this.targetAddedCompartments.contains(compartment)) continue;
                        CompartmentQueryParamWithEntitiesDialog.this.targetCompartmentList.add(compartment);
                        CompartmentQueryParamWithEntitiesDialog.this.targetAddedCompartments.add(compartment);
                    }
                }
            }
        });
        Button targetRemoveButton = new Button(this.shell, 0);
        targetRemoveButton.setText("Remove");
        gridData = new GridData(1, 1, true, false);
        gridData.horizontalIndent = 5;
        gridData.minimumWidth = 100;
        targetRemoveButton.setLayoutData(gridData);
        targetRemoveButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                String[] selectionResult;
                for (String selected : selectionResult = CompartmentQueryParamWithEntitiesDialog.this.targetCompartmentList.getSelection()) {
                    for (int j = 0; j < CompartmentQueryParamWithEntitiesDialog.this.targetAddedCompartments.size(); ++j) {
                        String compartment = CompartmentQueryParamWithEntitiesDialog.this.targetAddedCompartments.get(j);
                        if (selected == null || !selected.equals(compartment)) continue;
                        CompartmentQueryParamWithEntitiesDialog.this.targetAddedCompartments.remove(j);
                        CompartmentQueryParamWithEntitiesDialog.this.targetCompartmentList.remove(selected);
                    }
                }
            }
        });
        this.createExeCancDefGroup(opt, 8);
        this.shell.pack();
        this.setInitialValues(opt);
    }
}

