/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.gui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.gvt.ChisioMain;

public class ConnectToDAVIDDialog
extends Dialog {
    private ChisioMain main;
    private Shell shell;
    private Button button1;
    private Button button2;
    private Button button3;
    private Button button4;
    private String toolName;
    private boolean okPressed;

    public ConnectToDAVIDDialog(ChisioMain main) {
        super(main.getShell(), 0);
        this.main = main;
        this.okPressed = false;
    }

    public boolean open() {
        this.createContents();
        this.shell.pack();
        this.shell.setLocation(this.getParent().getLocation().x + this.getParent().getSize().x / 2 - this.shell.getSize().x / 2, this.getParent().getLocation().y + this.getParent().getSize().y / 2 - this.shell.getSize().y / 2);
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.okPressed;
    }

    public void createContents() {
        this.shell = new Shell(this.getParent(), 67680);
        this.shell.setText("Connect to DAVID");
        ImageDescriptor id = ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbe-icon.png");
        this.shell.setImage(id.createImage());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.shell.setLayout(gridLayout);
        Group buttonGroup = new Group(this.shell, 0);
        buttonGroup.setText("Select one of the DAVID tools");
        GridData gridData = new GridData(4, 1, false, false);
        gridData.horizontalSpan = 2;
        buttonGroup.setLayoutData(gridData);
        buttonGroup.setLayout(new GridLayout());
        this.button1 = new Button(buttonGroup, 16);
        this.button1.setText("Functional Annotation Summary");
        gridData = new GridData(1, 2, false, false);
        this.button1.setLayoutData(gridData);
        this.button2 = new Button(buttonGroup, 16);
        this.button2.setText("Gene Functional Classification");
        gridData = new GridData(1, 2, false, false);
        this.button2.setLayoutData(gridData);
        this.button3 = new Button(buttonGroup, 16);
        this.button3.setText("Gene Report");
        gridData = new GridData(1, 2, false, false);
        this.button3.setLayoutData(gridData);
        this.button4 = new Button(buttonGroup, 16);
        this.button4.setText("Gene Name Batch Viewer");
        gridData = new GridData(1, 2, false, false);
        this.button4.setLayoutData(gridData);
        Button okButton = new Button(this.shell, 0);
        okButton.setText("OK");
        gridData = new GridData(3, 2, true, false);
        okButton.setLayoutData(gridData);
        okButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                if (ConnectToDAVIDDialog.this.button1.getSelection()) {
                    ConnectToDAVIDDialog.this.toolName = "summary";
                } else if (ConnectToDAVIDDialog.this.button2.getSelection()) {
                    ConnectToDAVIDDialog.this.toolName = "gene2gene";
                } else if (ConnectToDAVIDDialog.this.button3.getSelection()) {
                    ConnectToDAVIDDialog.this.toolName = "geneReportFull";
                } else if (ConnectToDAVIDDialog.this.button4.getSelection()) {
                    ConnectToDAVIDDialog.this.toolName = "list";
                }
                ConnectToDAVIDDialog.this.okPressed = true;
                ConnectToDAVIDDialog.this.shell.close();
            }
        });
        Button cancelButton = new Button(this.shell, 0);
        cancelButton.setText("Cancel");
        gridData = new GridData(1, 2, true, false);
        cancelButton.setLayoutData(gridData);
        cancelButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                ConnectToDAVIDDialog.this.shell.close();
            }
        });
    }

    public String getToolName() {
        return this.toolName;
    }
}

