/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.gui;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.layout.CellLayout;
import org.gvt.ChisioMain;
import org.patika.mada.util.AlterationData;
import org.patika.mada.util.ExperimentData;

public class DataLegendDialog
extends Dialog {
    private Shell shell;
    private ExperimentData data;

    public DataLegendDialog(ChisioMain main, ExperimentData data) {
        super(main.getShell(), 0);
        this.data = data;
    }

    public void open() {
        this.createContents();
        this.shell.pack();
        this.shell.setLocation(this.getParent().getLocation().x + this.getParent().getSize().x / 2 - this.shell.getSize().x / 2, this.getParent().getLocation().y + this.getParent().getSize().y / 2 - this.shell.getSize().y / 2);
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void createContents() {
        this.shell = new Shell(this.getParent(), 2144);
        this.shell.setText("Legend");
        ImageDescriptor id = ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbe-icon.png");
        this.shell.setImage(id.createImage());
        this.shell.setBackground(ColorConstants.white);
        this.shell.setLayout(new FillLayout());
        Group legendGroup = new Group(this.shell, 0);
        legendGroup.setBackground(ColorConstants.white);
        legendGroup.setLayout(new CellLayout(1));
        if (this.data instanceof AlterationData) {
            for (int i = 0; i <= 10; ++i) {
                Label lab = new Label(legendGroup, 0);
                double v = (double)i / 10.0;
                v *= v * v;
                v = (double)Math.round(v * 1000.0) / 1000.0;
                lab.setText("       " + v + "        ");
                Color color = AlterationData.getNodeColor(v);
                lab.setBackground(color);
            }
        } else {
            double i;
            for (i = ExperimentData.low; i <= ExperimentData.mid_l; i += 0.2) {
                i = this.addExperimentColor(legendGroup, i);
            }
            for (i = ExperimentData.mid_h; i <= ExperimentData.high; i += 0.2) {
                i = this.addExperimentColor(legendGroup, i);
            }
        }
    }

    private double addExperimentColor(Group legendGroup, double i) {
        i = (double)Math.round(i * 10.0) / 10.0;
        Label lab = new Label(legendGroup, 0);
        lab.setText("       " + i + "        ");
        Color color = ExperimentData.getNodeColor(i);
        lab.setBackground(color);
        return i;
    }
}

