/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.gui;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gvt.ChisioMain;

public class GOIofSIFParameterDialog
extends Dialog {
    private List<SIFType> possibleRules;
    private List<SIFType> selectedRules;
    private Map<String, SIFType> ruleTagMap;
    private String siffile;
    private String genefile;
    private Boolean directed;
    private Integer limit;
    private boolean okPressed;
    private Shell shell;
    private Button okButton;
    private Button cancelButton;
    private Button sifBrowseButton;
    private Button geneBrowseButton;
    private Button directedButton;
    private Text sifText;
    private Text geneText;
    private Combo limitCombo;

    public GOIofSIFParameterDialog(Shell shell, List<SIFType> possibleRules, List<SIFType> selectedRules, String siffile, String genefile, Integer limit, Boolean directed) {
        super(shell);
        this.possibleRules = possibleRules;
        this.selectedRules = selectedRules;
        this.siffile = siffile;
        this.genefile = genefile;
        this.limit = limit;
        this.directed = directed;
        this.ruleTagMap = new HashMap<String, SIFType>();
        for (SIFType rule : possibleRules) {
            this.ruleTagMap.put(rule.getTag(), rule);
        }
        this.okPressed = false;
    }

    public boolean open() {
        this.createContents();
        this.shell.pack();
        this.shell.setLocation(this.getParent().getLocation().x + this.getParent().getSize().x / 2 - this.shell.getSize().x / 2, this.getParent().getLocation().y + this.getParent().getSize().y / 2 - this.shell.getSize().y / 2);
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.okPressed;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67680);
        this.shell.setText("Paths Between Query on SIF File");
        this.shell.setImage(ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbe-icon.png").createImage());
        this.shell.setLayout(new GridLayout());
        Label infoLabel = new Label(this.shell, 0);
        infoLabel.setText("Find all paths of specified length limit \nbetween any two entities of the specified set");
        infoLabel.setLayoutData(new GridData(4, 4, false, false, 1, 8));
        ButtonAdapter adapter = new ButtonAdapter();
        Group sifGroup = new Group(this.shell, 0);
        sifGroup.setText("SIF graph file name");
        sifGroup.setLayout(new RowLayout());
        this.sifText = new Text(sifGroup, 2052);
        this.sifText.setLayoutData(new RowData(200, 20));
        if (this.siffile != null) {
            this.sifText.setText(this.siffile);
        }
        this.sifBrowseButton = new Button(sifGroup, 8);
        this.sifBrowseButton.setText("Browse");
        this.sifBrowseButton.addSelectionListener(adapter);
        Group geneGroup = new Group(this.shell, 0);
        geneGroup.setText("Genes-of-interest file name");
        geneGroup.setLayout(new RowLayout());
        this.geneText = new Text(geneGroup, 2052);
        this.geneText.setLayoutData(new RowData(200, 20));
        if (this.genefile != null) {
            this.geneText.setText(this.genefile);
        }
        this.geneBrowseButton = new Button(geneGroup, 8);
        this.geneBrowseButton.setText("Browse");
        this.geneBrowseButton.addSelectionListener(adapter);
        Group paramsGroup = new Group(this.shell, 0);
        paramsGroup.setLayout(new RowLayout());
        paramsGroup.setText("Parameters");
        new Label(paramsGroup, 0).setText("Search distance: ");
        this.limitCombo = new Combo(paramsGroup, 8);
        this.limitCombo.setItems(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"});
        this.limitCombo.select(this.limit != null ? this.limit - 1 : 0);
        Label stub = new Label(paramsGroup, 0);
        stub.setLayoutData(new RowData(70, 20));
        this.directedButton = new Button(paramsGroup, 32);
        this.directedButton.setText("Directed");
        this.directedButton.setSelection(this.directed != null ? this.directed : false);
        this.directedButton.setEnabled(false);
        Group rulesGroup = new Group(this.shell, 0);
        rulesGroup.setLayout(new GridLayout());
        rulesGroup.setText("Select rules to use");
        for (SIFType rule : this.possibleRules) {
            Button ruleBox = new Button(rulesGroup, 32);
            ruleBox.setText(rule.getTag());
            ruleBox.setToolTipText(this.prepareToolTipText(rule.getDescription()));
            ruleBox.addSelectionListener(adapter);
            if (!this.selectedRules.contains(rule)) continue;
            ruleBox.setSelection(true);
        }
        Composite buttonsGroup = new Composite(this.shell, 0);
        buttonsGroup.setLayout(new RowLayout());
        this.okButton = new Button(buttonsGroup, 0);
        this.okButton.setText("OK");
        this.okButton.addSelectionListener(adapter);
        this.cancelButton = new Button(buttonsGroup, 0);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addSelectionListener(adapter);
        this.checkButtons();
    }

    private String prepareToolTipText(String text) {
        String tooltip = "";
        String line = "";
        StringTokenizer tokenizer = new StringTokenizer(text);
        while (tokenizer.hasMoreTokens()) {
            String token = (line.length() == 0 ? "" : " ") + tokenizer.nextToken();
            tooltip = tooltip + token;
            if ((line = line + token).length() <= 50) continue;
            tooltip = tooltip + "\n";
            line = "";
        }
        return tooltip;
    }

    public String getGenefile() {
        return this.genefile;
    }

    public String getSiffile() {
        return this.siffile;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Boolean getDirected() {
        return this.directed;
    }

    private void checkButtons() {
        this.okButton.setEnabled(!this.selectedRules.isEmpty() && this.sifText.getText().length() > 0 && new File(this.sifText.getText()).exists() && this.geneText.getText().length() > 0 && new File(this.geneText.getText()).exists());
        if (this.directedButton.getSelection() == this.undirectedRuleSelected()) {
            this.directedButton.setSelection(!this.directedButton.getSelection());
        }
    }

    private boolean undirectedRuleSelected() {
        for (SIFType type : this.selectedRules) {
            if (type.isDirected()) continue;
            return true;
        }
        return false;
    }

    class ButtonAdapter
    extends SelectionAdapter {
        ButtonAdapter() {
        }

        @Override
        public void widgetSelected(SelectionEvent arg) {
            Button button = (Button)arg.widget;
            if ((button.getStyle() & 0x20) > 0) {
                String ruleTag = button.getText();
                SIFType rule = (SIFType)GOIofSIFParameterDialog.this.ruleTagMap.get(ruleTag);
                if (button.getSelection()) {
                    assert (!GOIofSIFParameterDialog.this.selectedRules.contains(rule));
                    GOIofSIFParameterDialog.this.selectedRules.add(rule);
                } else {
                    assert (GOIofSIFParameterDialog.this.selectedRules.contains(rule));
                    GOIofSIFParameterDialog.this.selectedRules.remove(rule);
                }
                GOIofSIFParameterDialog.this.checkButtons();
            } else if (button == GOIofSIFParameterDialog.this.okButton) {
                GOIofSIFParameterDialog.this.directed = GOIofSIFParameterDialog.this.directedButton.getSelection();
                GOIofSIFParameterDialog.this.limit = GOIofSIFParameterDialog.this.limitCombo.getSelectionIndex() + 1;
                GOIofSIFParameterDialog.this.okPressed = true;
                GOIofSIFParameterDialog.this.shell.dispose();
            } else if (button == GOIofSIFParameterDialog.this.cancelButton) {
                GOIofSIFParameterDialog.this.okPressed = false;
                GOIofSIFParameterDialog.this.shell.dispose();
            } else if (button == GOIofSIFParameterDialog.this.sifBrowseButton) {
                FileDialog dialog = new FileDialog(GOIofSIFParameterDialog.this.shell, 4096);
                if (GOIofSIFParameterDialog.this.siffile != null) {
                    dialog.setFileName(GOIofSIFParameterDialog.this.siffile);
                }
                dialog.setFilterNames(new String[]{"Simple Interaction Format (*.sif)"});
                dialog.setFilterExtensions(new String[]{"*.sif"});
                String file = dialog.open();
                if (file != null) {
                    GOIofSIFParameterDialog.this.siffile = file;
                    GOIofSIFParameterDialog.this.sifText.setText(GOIofSIFParameterDialog.this.siffile);
                }
                GOIofSIFParameterDialog.this.checkButtons();
            } else if (button == GOIofSIFParameterDialog.this.geneBrowseButton) {
                FileDialog dialog = new FileDialog(GOIofSIFParameterDialog.this.shell, 4096);
                if (GOIofSIFParameterDialog.this.genefile != null) {
                    dialog.setFileName(GOIofSIFParameterDialog.this.genefile);
                }
                dialog.setFilterNames(new String[]{"Genes of Interest List (*.txt)"});
                dialog.setFilterExtensions(new String[]{"*.txt"});
                String file = dialog.open();
                if (file != null) {
                    GOIofSIFParameterDialog.this.genefile = file;
                    GOIofSIFParameterDialog.this.geneText.setText(GOIofSIFParameterDialog.this.genefile);
                }
                GOIofSIFParameterDialog.this.checkButtons();
            }
        }
    }
}

