/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.layout.CellData;
import org.eclipse.ui.internal.layout.CellLayout;
import org.gvt.ChisioMain;
import org.gvt.gui.TCGAGenesDialog;

public class GeneSetSelectionDialog
extends Dialog {
    private List<String> genes;
    private List<String> studyCodes;
    private Shell shell;
    private Button okButton;
    private Button cancelButton;
    private Button tcgaButton;
    private Text genesText;

    public GeneSetSelectionDialog(Shell shell) {
        super(shell);
    }

    public List<String> open() {
        this.createContents();
        this.shell.pack();
        this.shell.setLocation(this.getParent().getLocation().x + this.getParent().getSize().x / 2 - this.shell.getSize().x / 2, this.getParent().getLocation().y + this.getParent().getSize().y / 2 - this.shell.getSize().y / 2);
        this.shell.setImage(ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbe-icon.png").createImage());
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.genes;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67680);
        this.shell.setLayout(new CellLayout(1));
        this.shell.setText("Find Enriched Reactions");
        this.shell.setMinimumSize(200, 200);
        ButtonAdapter adapter = new ButtonAdapter();
        Group middleGroup = new Group(this.shell, 0);
        middleGroup.setLayout(new CellLayout(1));
        middleGroup.setText("Enter gene symbols to look for enrichment");
        this.tcgaButton = new Button(middleGroup, 8);
        this.tcgaButton.setText("Use TCGA genes");
        CellData data = new CellData();
        data.align(131072, 0x1000000);
        this.tcgaButton.setLayoutData(data);
        this.tcgaButton.addSelectionListener(adapter);
        this.genesText = new Text(middleGroup, 66);
        data = new CellData();
        data.widthHint = 400;
        data.heightHint = 100;
        this.genesText.setLayoutData(data);
        Composite buttonsGroup = new Composite(this.shell, 0);
        buttonsGroup.setLayout(new CellLayout(2));
        this.okButton = new Button(buttonsGroup, 0);
        this.okButton.setText("OK");
        this.okButton.addSelectionListener(adapter);
        data = new CellData();
        data.align(131072, 0x1000000);
        this.okButton.setLayoutData(data);
        this.cancelButton = new Button(buttonsGroup, 0);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addSelectionListener(adapter);
        data = new CellData();
        data.align(16384, 0x1000000);
        this.cancelButton.setLayoutData(data);
    }

    private void cancelPressed() {
        this.shell.dispose();
    }

    private void okPressed() {
        this.readGenesInBox();
        this.shell.dispose();
    }

    private void readGenesInBox() {
        this.genes = new ArrayList<String>();
        for (String s : this.genesText.getText().split("\\s+")) {
            if (s.isEmpty()) continue;
            this.genes.add(s);
        }
    }

    private void tcgaPressed() {
        this.readGenesInBox();
        TCGAGenesDialog d = new TCGAGenesDialog(this.shell);
        Set<String> selected = d.open();
        if (selected == null) {
            return;
        }
        if (selected.isEmpty()) {
            MessageDialog.openInformation(this.shell, "", "No genes found.");
            return;
        }
        this.genes.addAll(selected);
        Collections.sort(this.genes);
        String s = "";
        for (String gene : this.genes) {
            s = s + gene + " ";
        }
        this.genesText.setText(s.trim());
    }

    class ButtonAdapter
    extends SelectionAdapter {
        ButtonAdapter() {
        }

        @Override
        public void widgetSelected(SelectionEvent arg) {
            Button button = (Button)arg.widget;
            if (button == GeneSetSelectionDialog.this.okButton) {
                GeneSetSelectionDialog.this.okPressed();
            } else if (button == GeneSetSelectionDialog.this.cancelButton) {
                GeneSetSelectionDialog.this.cancelPressed();
            } else if (button == GeneSetSelectionDialog.this.tcgaButton) {
                GeneSetSelectionDialog.this.tcgaPressed();
            }
        }
    }
}

