/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.ScalableLayeredPane;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.gvt.ChisioMain;
import org.gvt.action.SaveAsImageAction;
import org.gvt.editpart.ChsScalableRootEditPart;
import org.gvt.gui.ItemSelectionRunnable;
import org.gvt.util.AnimatedGIF;

public class ItemSelectionDialog
extends Dialog {
    private List possibleItems;
    private List selectedItems;
    private boolean multipleSelect;
    private String title;
    private String message;
    boolean modal;
    int minValidSelect;
    private ItemSelectionRunnable selectionRun;
    boolean updateUponSelection;
    private boolean pressedCancel;
    private int width;
    private boolean doSort;
    private boolean use3dots;
    private Shell shell;
    private Button okButton;
    private Button cancelButton;
    private Button imageButton;
    private Button allButton;
    private Button noneButton;
    private Button[] itemButtonArray;
    Map<Button, Object> but2orig;
    ChisioMain main;
    public static final String NONE = "None";
    public static final int MAX_HEIGHT = 500;

    public ItemSelectionDialog(Shell shell, int width, String title, String message, List possibleItems, List selectedItems, boolean multipleSelect, boolean modal, ItemSelectionRunnable selectionRun) {
        super(shell, modal ? 65536 : 0);
        this.width = width;
        this.title = title;
        this.message = message;
        this.possibleItems = possibleItems;
        this.selectedItems = selectedItems != null ? selectedItems : new ArrayList();
        this.multipleSelect = multipleSelect;
        this.modal = modal;
        this.selectionRun = selectionRun;
        this.updateUponSelection = false;
        this.doSort = true;
        this.minValidSelect = 0;
        this.use3dots = modal;
        this.but2orig = new HashMap<Button, Object>();
    }

    public boolean isUpdateUponSelection() {
        return this.updateUponSelection;
    }

    public void setUpdateUponSelection(boolean updateUponSelection) {
        this.updateUponSelection = updateUponSelection;
    }

    public void setDoSort(boolean doSort) {
        this.doSort = doSort;
    }

    public int getMinValidSelect() {
        return this.minValidSelect;
    }

    public void setMinValidSelect(int minValidSelect) {
        this.minValidSelect = minValidSelect;
    }

    public boolean isUse3dots() {
        return this.use3dots;
    }

    public void setUse3dots(boolean use3dots) {
        this.use3dots = use3dots;
    }

    public void setMain(ChisioMain main) {
        this.main = main;
    }

    public Object open() {
        this.pressedCancel = true;
        this.createContents();
        this.shell.setText(this.title);
        this.shell.setImage(ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbe-icon.png").createImage());
        this.shell.pack();
        if (this.shell.getSize().y > 500) {
            this.shell.setSize(new Point(this.shell.getSize().x, 500));
        }
        this.shell.setLocation(this.getParent().getLocation().x + this.getParent().getSize().x / 2 - this.shell.getSize().x / 2, this.getParent().getLocation().y + this.getParent().getSize().y / 2 - this.shell.getSize().y / 2);
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (this.selectedItems.size() == 1 && !this.pressedCancel) {
            return this.selectedItems.get(0);
        }
        return null;
    }

    private void createContents() {
        if (this.doSort) {
            Collections.sort(this.possibleItems);
        }
        if (!this.modal && !this.multipleSelect) {
            this.possibleItems.add(0, NONE);
        }
        this.shell = new Shell(this.getParent(), 0x860 | (this.modal ? 65536 : 0) | 0x10);
        GridLayout grLy = new GridLayout();
        grLy.numColumns = 2;
        this.shell.setLayout(grLy);
        this.shell.setText("Selection Dialog");
        Group outerGroup = new Group(this.shell, 0);
        outerGroup.setText(this.message);
        outerGroup.setLayout(new GridLayout());
        outerGroup.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        ScrolledComposite scroll = new ScrolledComposite(outerGroup, 2816);
        scroll.setLayout(new GridLayout());
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(true);
        scroll.setLayoutData(new GridData(4, 4, true, true));
        Composite itemsGroup = new Composite(scroll, 0);
        scroll.setContent(itemsGroup);
        grLy = new GridLayout();
        grLy.numColumns = 1;
        itemsGroup.setLayout(grLy);
        itemsGroup.setLayoutData(new GridData(4, 4, true, true));
        ButtonAdapter adapter = new ButtonAdapter();
        this.itemButtonArray = new Button[this.possibleItems.size()];
        int i = 0;
        for (Object pItem : this.possibleItems) {
            Button itemBox = new Button(itemsGroup, this.multipleSelect ? 32 : 16);
            this.itemButtonArray[i++] = itemBox;
            itemBox.setLayoutData(new GridData(1, 4, true, false));
            this.but2orig.put(itemBox, pItem);
            if (this.use3dots) {
                String txt = this.truncate(pItem.toString(), itemBox.getFont(), this.width - 87);
                if (!txt.equals(pItem)) {
                    itemBox.setToolTipText(pItem.toString());
                }
                itemBox.setText(txt);
            } else {
                itemBox.setText(pItem.toString());
            }
            itemBox.addSelectionListener(adapter);
            itemBox.setSelection(this.selectedItems.contains(this.but2orig.get(itemBox)));
        }
        itemsGroup.pack();
        scroll.setMinSize(itemsGroup.getSize());
        Composite leftButtonsGroup = new Composite(this.shell, 0);
        leftButtonsGroup.setLayoutData(new GridData(0x1000000, 4, false, false));
        leftButtonsGroup.setLayout(new RowLayout());
        if (this.modal && this.multipleSelect && !this.updateUponSelection) {
            this.allButton = new Button(leftButtonsGroup, 0);
            this.allButton.setText("All");
            this.allButton.addSelectionListener(adapter);
            this.noneButton = new Button(leftButtonsGroup, 0);
            this.noneButton.setText(NONE);
            this.noneButton.addSelectionListener(adapter);
        }
        Composite rightButtonGroup = new Composite(this.shell, 0);
        rightButtonGroup.setLayoutData(new GridData(0x1000000, 4, true, false));
        rightButtonGroup.setLayout(new RowLayout());
        this.okButton = new Button(rightButtonGroup, 0);
        this.okButton.setText(this.modal ? "OK" : "Update");
        this.okButton.addSelectionListener(adapter);
        this.okButton.setEnabled(!this.isUpdateUponSelection() && this.selectedItems.size() >= this.minValidSelect && (this.selectedItems.isEmpty() || !this.selectedItems.get(0).equals(NONE)));
        this.cancelButton = new Button(rightButtonGroup, 0);
        this.cancelButton.setText(this.modal ? "Cancel" : "Close");
        this.cancelButton.addSelectionListener(adapter);
        if (!this.modal && !this.multipleSelect && this.isUpdateUponSelection() && this.main != null) {
            this.imageButton = new Button(rightButtonGroup, 0);
            this.imageButton.setText("Image");
            this.imageButton.addSelectionListener(adapter);
        }
    }

    private String truncate(String s, Font f, int limit) {
        int w = TextUtilities.INSTANCE.getStringExtents((String)s, (Font)f).width;
        boolean truncated = false;
        while (w > limit) {
            s = s.substring(0, s.length() - 1);
            w = TextUtilities.INSTANCE.getStringExtents((String)new StringBuilder().append((String)s).append((String)"...").toString(), (Font)f).width;
            truncated = true;
        }
        return truncated ? s + "..." : s;
    }

    public boolean isCancelled() {
        return this.pressedCancel;
    }

    public List getSelectedItems() {
        return this.selectedItems;
    }

    public void selectItem(Object item) {
        int index = this.possibleItems.indexOf(item);
        this.itemButtonArray[index].setSelection(true);
    }

    public void runAsIfSelected(List list) {
        this.selectionRun.run(list);
    }

    public void runAsIfSelected(Object item) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(item);
        this.selectionRun.run(list);
    }

    protected String getImageDirectory() {
        DirectoryDialog dialog = new DirectoryDialog(this.getParent());
        return dialog.open();
    }

    protected String saveImage(String tag, String directory) {
        String filename = directory + File.separator + tag + ".png";
        Figure rootFigure = (Figure)((ChsScalableRootEditPart)this.main.getViewer().getRootEditPart()).getFigure();
        rootFigure = (Figure)rootFigure.getChildren().get(0);
        ScalableLayeredPane layer = (ScalableLayeredPane)rootFigure.getChildren().get(0);
        double scale = layer.getScale();
        Rectangle bounds = SaveAsImageAction.getBounds(this.main.getViewer(), rootFigure, scale);
        Image image = new Image((Device)this.shell.getDisplay(), bounds);
        GC gc = new GC(image);
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        SWTGraphics graphics = new SWTGraphics(gc);
        rootFigure.paint(graphics);
        ((Graphics)graphics).drawText(tag, 3, 3);
        ((Graphics)graphics).dispose();
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image.getImageData()};
        loader.save(filename, 5);
        return filename;
    }

    class ButtonAdapter
    extends SelectionAdapter {
        ButtonAdapter() {
        }

        @Override
        public void widgetSelected(SelectionEvent arg) {
            Button button = (Button)arg.widget;
            if ((button.getStyle() & 0x20) > 0 || (button.getStyle() & 0x10) > 0) {
                Object item = ItemSelectionDialog.this.but2orig.get(button);
                if (button.getSelection()) {
                    if (!ItemSelectionDialog.this.selectedItems.contains(item)) {
                        ItemSelectionDialog.this.selectedItems.add(item);
                    }
                } else {
                    ItemSelectionDialog.this.selectedItems.remove(item);
                }
                if (ItemSelectionDialog.this.isUpdateUponSelection() && (ItemSelectionDialog.this.multipleSelect || !ItemSelectionDialog.this.selectedItems.isEmpty())) {
                    Event e = new Event();
                    e.item = ItemSelectionDialog.this.okButton;
                    e.data = ItemSelectionDialog.this.okButton;
                    e.widget = ItemSelectionDialog.this.okButton;
                    SelectionEvent event = new SelectionEvent(e);
                    this.widgetSelected(event);
                } else {
                    ItemSelectionDialog.this.okButton.setEnabled(ItemSelectionDialog.this.minValidSelect <= ItemSelectionDialog.this.selectedItems.size());
                }
            } else if (button == ItemSelectionDialog.this.okButton) {
                ItemSelectionDialog.this.pressedCancel = false;
                if (ItemSelectionDialog.this.modal) {
                    ItemSelectionDialog.this.shell.dispose();
                } else if (ItemSelectionDialog.this.selectionRun != null) {
                    ItemSelectionDialog.this.selectionRun.run(ItemSelectionDialog.this.selectedItems);
                    ItemSelectionDialog.this.okButton.setEnabled(false);
                }
            } else if (button == ItemSelectionDialog.this.cancelButton) {
                ItemSelectionDialog.this.pressedCancel = true;
                ItemSelectionDialog.this.shell.dispose();
            } else if (button == ItemSelectionDialog.this.imageButton) {
                String dir = ItemSelectionDialog.this.getImageDirectory();
                if (dir == null) {
                    return;
                }
                Object origItem = ItemSelectionDialog.this.getSelectedItems().iterator().next();
                ArrayList<String> files = new ArrayList<String>();
                for (Object item : ItemSelectionDialog.this.possibleItems) {
                    if (item == ItemSelectionDialog.NONE) continue;
                    ItemSelectionDialog.this.runAsIfSelected(item);
                    files.add(ItemSelectionDialog.this.saveImage(item.toString(), dir));
                }
                ItemSelectionDialog.this.runAsIfSelected(origItem);
                try {
                    AnimatedGIF.generate(files.toArray(new String[0]), dir + File.separator + "animated.gif", 200);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (button == ItemSelectionDialog.this.allButton || button == ItemSelectionDialog.this.noneButton) {
                boolean selected = button == ItemSelectionDialog.this.allButton;
                for (Button item : ItemSelectionDialog.this.itemButtonArray) {
                    item.setSelection(selected);
                }
                ItemSelectionDialog.this.selectedItems.clear();
                if (selected) {
                    ItemSelectionDialog.this.selectedItems.addAll(ItemSelectionDialog.this.possibleItems);
                }
                ItemSelectionDialog.this.okButton.setEnabled(ItemSelectionDialog.this.selectedItems.size() >= ItemSelectionDialog.this.minValidSelect);
            }
        }
    }
}

