/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.gui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.gvt.ChisioMain;
import org.gvt.action.CoSELayoutAction;
import org.gvt.action.SpringLayoutAction;
import org.ivis.layout.LayoutOptionsPack;

public class LayoutInspector
extends Dialog {
    private Button incremental;
    private Button proofButton;
    private Button defaultButton;
    private Button draftButton;
    private Group tuningGroup;
    private Scale animationPeriod;
    protected Button animateDuringLayoutButton;
    protected Button animateOnLayoutButton;
    private Button createBendsAsButton;
    private Button uniformLeafNodeSizesButton;
    private Scale gravityStrength;
    private Scale gravityRange;
    private Scale springStrength;
    private Scale repulsionStrength;
    private Scale compoundGravityStrength;
    private Scale compoundGravityRange;
    private Text desiredEdgeLengthCoSE;
    private Button smartEdgeLengthCalc;
    private Button multiLevelScaling;
    private Button smartRepulsionRangeCalc;
    private Text disconnectedNodeDistanceSpringRestLength;
    private Text nodeDistanceRestLength;
    protected Object result;
    protected Shell shell;
    private ChisioMain main;
    public static int lastTab = 0;
    private KeyAdapter keyAdapter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent arg0) {
            arg0.doit = this.isDigit(arg0.keyCode);
        }

        public boolean isDigit(int keyCode) {
            return Character.isDigit(keyCode) || keyCode == 127 || keyCode == 8 || keyCode == 0x1000003 || keyCode == 0x1000004;
        }
    };

    public static void main(String[] args) {
    }

    public LayoutInspector(ChisioMain main) {
        super(main.getShell(), 0);
        this.main = main;
    }

    public Object open() {
        this.createContents();
        this.shell.pack();
        this.shell.setLocation(this.getParent().getLocation().x + this.getParent().getSize().x / 2 - this.shell.getSize().x / 2, this.getParent().getLocation().y + this.getParent().getSize().y / 2 - this.shell.getSize().y / 2);
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67680);
        this.shell.setText("Layout Properties");
        ImageDescriptor id = ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbe-icon.png");
        this.shell.setImage(id.createImage());
        GridLayout gridLy = new GridLayout();
        gridLy.numColumns = 1;
        this.shell.setLayout(gridLy);
        final TabFolder tabFolder = new TabFolder(this.shell, 0);
        GridData gridDt = new GridData();
        gridDt.grabExcessVerticalSpace = true;
        tabFolder.setLayoutData(gridDt);
        TabItem generalTabItem = new TabItem(tabFolder, 0);
        generalTabItem.setText("General");
        Composite compositeGeneral = new Composite(tabFolder, 0);
        generalTabItem.setControl(compositeGeneral);
        gridLy = new GridLayout();
        gridLy.numColumns = 2;
        compositeGeneral.setLayout(gridLy);
        Group animationGroup = new Group(compositeGeneral, 0);
        animationGroup.setText("Animation");
        animationGroup.setLayoutData(new GridData(512));
        gridLy = new GridLayout();
        gridLy.numColumns = 1;
        animationGroup.setLayout(gridLy);
        this.animateOnLayoutButton = new Button(animationGroup, 32);
        this.animateOnLayoutButton.setText("Animate on Layout");
        this.animateDuringLayoutButton = new Button(animationGroup, 32);
        this.animateDuringLayoutButton.setAlignment(128);
        this.animateDuringLayoutButton.setText("Animate during Layout");
        Composite periodComposite = new Composite(animationGroup, 0);
        gridLy = new GridLayout();
        gridLy.numColumns = 2;
        periodComposite.setLayout(gridLy);
        Label animationPeriodLabel = new Label(periodComposite, 0);
        animationPeriodLabel.setText("Animation Period");
        gridDt = new GridData(4);
        animationPeriodLabel.setLayoutData(gridDt);
        this.animationPeriod = new Scale(periodComposite, 0);
        this.animationPeriod.setSelection(50);
        this.animationPeriod.setIncrement(5);
        gridDt = new GridData(4);
        gridDt.widthHint = 50;
        this.animationPeriod.setLayoutData(gridDt);
        Group layoutQualityGroup = new Group(compositeGeneral, 0);
        layoutQualityGroup.setText("Layout Quality");
        gridLy = new GridLayout();
        gridLy.numColumns = 1;
        layoutQualityGroup.setLayout(gridLy);
        this.draftButton = new Button(layoutQualityGroup, 16);
        this.draftButton.setText("Draft");
        this.defaultButton = new Button(layoutQualityGroup, 16);
        this.defaultButton.setText("Default");
        this.proofButton = new Button(layoutQualityGroup, 16);
        this.proofButton.setText("Proof");
        Composite extra = new Composite(compositeGeneral, 0);
        gridDt = new GridData(32);
        gridDt.horizontalSpan = 2;
        extra.setLayoutData(gridDt);
        gridLy = new GridLayout();
        gridLy.numColumns = 1;
        extra.setLayout(gridLy);
        this.incremental = new Button(extra, 32);
        this.incremental.setText("Incremental");
        this.createBendsAsButton = new Button(extra, 32);
        this.createBendsAsButton.setText("Create Bends as Needed");
        this.uniformLeafNodeSizesButton = new Button(extra, 32);
        this.uniformLeafNodeSizesButton.setText("Uniform Leaf Node Sizes");
        TabItem coseTabItem = new TabItem(tabFolder, 0);
        coseTabItem.setText("CoSE");
        TabItem springTabItem = new TabItem(tabFolder, 0);
        springTabItem.setText("Spring");
        Composite compositeCoSE = new Composite(tabFolder, 0);
        coseTabItem.setControl(compositeCoSE);
        gridLy = new GridLayout();
        gridLy.numColumns = 1;
        compositeCoSE.setLayout(gridLy);
        this.tuningGroup = new Group(compositeCoSE, 0);
        this.tuningGroup.setText("Tuning");
        gridLy = new GridLayout();
        gridLy.numColumns = 2;
        this.tuningGroup.setLayout(gridLy);
        Label springStrengthLabel = new Label(this.tuningGroup, 0);
        springStrengthLabel.setText("Spring Strength");
        this.springStrength = new Scale(this.tuningGroup, 0);
        this.springStrength.setIncrement(5);
        gridDt = new GridData();
        gridDt.widthHint = 100;
        this.springStrength.setLayoutData(gridDt);
        Label repulsionStrengthLabel = new Label(this.tuningGroup, 0);
        repulsionStrengthLabel.setText("Repulsion");
        this.repulsionStrength = new Scale(this.tuningGroup, 0);
        this.repulsionStrength.setIncrement(5);
        this.repulsionStrength.setLayoutData(gridDt);
        Label gravityLevelLabel = new Label(this.tuningGroup, 0);
        gravityLevelLabel.setText("Gravity");
        this.gravityStrength = new Scale(this.tuningGroup, 0);
        this.gravityStrength.setIncrement(5);
        this.gravityStrength.setLayoutData(gridDt);
        Label gravityRangeLabel = new Label(this.tuningGroup, 0);
        gravityRangeLabel.setText("Gravity Range");
        this.gravityRange = new Scale(this.tuningGroup, 0);
        this.gravityRange.setIncrement(5);
        this.gravityRange.setLayoutData(gridDt);
        Label compoundGravityStrengthLabel = new Label(this.tuningGroup, 0);
        compoundGravityStrengthLabel.setText("Compound Gravity");
        this.compoundGravityStrength = new Scale(this.tuningGroup, 0);
        this.compoundGravityStrength.setIncrement(5);
        this.compoundGravityStrength.setLayoutData(gridDt);
        compositeCoSE.setTabList(new Control[]{this.tuningGroup});
        Label compoundGravityRangeLabel = new Label(this.tuningGroup, 0);
        compoundGravityRangeLabel.setText("Compound Gravity Range");
        this.compoundGravityRange = new Scale(this.tuningGroup, 0);
        this.compoundGravityRange.setIncrement(5);
        this.compoundGravityRange.setLayoutData(gridDt);
        this.smartRepulsionRangeCalc = new Button(this.tuningGroup, 32);
        this.smartRepulsionRangeCalc.setText("Smart Range Calculation");
        Composite desire = new Composite(compositeCoSE, 0);
        gridLy = new GridLayout();
        gridLy.numColumns = 2;
        desire.setLayout(gridLy);
        Label desiredEdgeLengthLabel = new Label(desire, 0);
        desiredEdgeLengthLabel.setText("Desired Edge Length    ");
        gridDt = new GridData(4);
        desiredEdgeLengthLabel.setLayoutData(gridDt);
        this.desiredEdgeLengthCoSE = new Text(desire, 2048);
        this.desiredEdgeLengthCoSE.addKeyListener(this.keyAdapter);
        gridDt = new GridData();
        gridDt.widthHint = 30;
        this.desiredEdgeLengthCoSE.setLayoutData(gridDt);
        this.smartEdgeLengthCalc = new Button(compositeCoSE, 32);
        this.smartEdgeLengthCalc.setText("Smart Edge Length Calculation");
        this.multiLevelScaling = new Button(compositeCoSE, 32);
        this.multiLevelScaling.setText("Multi-Level Scaling");
        compositeCoSE.setTabList(new Control[]{this.tuningGroup});
        Composite compositeSpring = new Composite(tabFolder, 0);
        springTabItem.setControl(compositeSpring);
        gridLy = new GridLayout();
        gridLy.numColumns = 2;
        compositeSpring.setLayout(gridLy);
        Label nodedistancerestlengthLabel = new Label(compositeSpring, 0);
        nodedistancerestlengthLabel.setText("Desired Edge Length");
        this.nodeDistanceRestLength = new Text(compositeSpring, 2048);
        this.nodeDistanceRestLength.addKeyListener(this.keyAdapter);
        gridDt = new GridData();
        gridDt.widthHint = 30;
        this.nodeDistanceRestLength.setLayoutData(gridDt);
        Label disconnectednodedistancespringrestlengthLabel = new Label(compositeSpring, 0);
        disconnectednodedistancespringrestlengthLabel.setText("Disconnected Component Separation");
        this.disconnectedNodeDistanceSpringRestLength = new Text(compositeSpring, 2048);
        this.disconnectedNodeDistanceSpringRestLength.addKeyListener(this.keyAdapter);
        gridDt = new GridData();
        gridDt.widthHint = 30;
        this.disconnectedNodeDistanceSpringRestLength.setLayoutData(gridDt);
        Composite buttons = new Composite(this.shell, 0);
        buttons.setLayout(new RowLayout());
        gridDt = new GridData();
        gridDt.horizontalAlignment = 128;
        Button okButton = new Button(buttons, 0);
        okButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                LayoutInspector.this.storeValuesToOptionsPack();
                lastTab = tabFolder.getSelectionIndex();
                LayoutInspector.this.shell.close();
            }
        });
        okButton.setText("OK");
        final Button layoutButton = new Button(buttons, 0);
        layoutButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                int i = tabFolder.getSelectionIndex();
                LayoutInspector.this.storeValuesToOptionsPack();
                switch (i) {
                    case 1: {
                        new CoSELayoutAction(LayoutInspector.this.main).run();
                        break;
                    }
                    case 2: {
                        new SpringLayoutAction(LayoutInspector.this.main).run();
                    }
                }
            }
        });
        layoutButton.setText("Layout");
        Button cancelButton = new Button(buttons, 0);
        cancelButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                lastTab = tabFolder.getSelectionIndex();
                LayoutInspector.this.shell.close();
            }
        });
        cancelButton.setText("Cancel");
        Button defaultButton2 = new Button(buttons, 0);
        defaultButton2.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                int i = tabFolder.getSelectionIndex();
                LayoutInspector.this.setDefaultLayoutProperties(i);
            }
        });
        defaultButton2.setText("Default");
        if (lastTab == 0) {
            layoutButton.setEnabled(false);
        }
        tabFolder.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                if (tabFolder.getSelectionIndex() == 0) {
                    layoutButton.setEnabled(false);
                } else {
                    layoutButton.setEnabled(true);
                }
            }
        });
        this.setInitialValues();
        tabFolder.setSelection(lastTab);
    }

    public void storeValuesToOptionsPack() {
        LayoutOptionsPack lop = LayoutOptionsPack.getInstance();
        lop.getGeneral().layoutQuality = this.proofButton.getSelection() ? 0 : (this.draftButton.getSelection() ? 2 : 1);
        lop.getGeneral().animationPeriod = this.animationPeriod.getSelection();
        lop.getGeneral().animationDuringLayout = this.animateDuringLayoutButton.getSelection();
        lop.getGeneral().animationOnLayout = this.animateOnLayoutButton.getSelection();
        lop.getGeneral().incremental = this.incremental.getSelection();
        lop.getGeneral().createBendsAsNeeded = this.createBendsAsButton.getSelection();
        lop.getGeneral().uniformLeafNodeSizes = this.uniformLeafNodeSizesButton.getSelection();
        lop.getCoSE().idealEdgeLength = Integer.parseInt(this.desiredEdgeLengthCoSE.getText());
        lop.getCoSE().springStrength = this.springStrength.getSelection();
        lop.getCoSE().repulsionStrength = this.repulsionStrength.getSelection();
        lop.getCoSE().smartRepulsionRangeCalc = this.smartRepulsionRangeCalc.getSelection();
        lop.getCoSE().gravityStrength = this.gravityStrength.getSelection();
        lop.getCoSE().gravityRange = this.gravityRange.getSelection();
        lop.getCoSE().compoundGravityStrength = this.compoundGravityStrength.getSelection();
        lop.getCoSE().compoundGravityRange = this.compoundGravityRange.getSelection();
        lop.getCoSE().smartEdgeLengthCalc = this.smartEdgeLengthCalc.getSelection();
        lop.getCoSE().multiLevelScaling = this.multiLevelScaling.getSelection();
    }

    public void setInitialValues() {
        LayoutOptionsPack lop = LayoutOptionsPack.getInstance();
        if (lop.getGeneral().layoutQuality == 0) {
            this.proofButton.setSelection(true);
        } else if (lop.getGeneral().layoutQuality == 2) {
            this.draftButton.setSelection(true);
        } else {
            this.defaultButton.setSelection(true);
        }
        this.animateDuringLayoutButton.setSelection(lop.getGeneral().animationDuringLayout);
        this.animateOnLayoutButton.setSelection(lop.getGeneral().animationOnLayout);
        this.animationPeriod.setSelection(lop.getGeneral().animationPeriod);
        this.incremental.setSelection(lop.getGeneral().incremental);
        this.createBendsAsButton.setSelection(lop.getGeneral().createBendsAsNeeded);
        this.uniformLeafNodeSizesButton.setSelection(lop.getGeneral().uniformLeafNodeSizes);
        this.desiredEdgeLengthCoSE.setText(String.valueOf(lop.getCoSE().idealEdgeLength));
        this.springStrength.setSelection(lop.getCoSE().springStrength);
        this.repulsionStrength.setSelection(lop.getCoSE().repulsionStrength);
        this.smartRepulsionRangeCalc.setSelection(lop.getCoSE().smartRepulsionRangeCalc);
        this.gravityStrength.setSelection(lop.getCoSE().gravityStrength);
        this.gravityRange.setSelection(lop.getCoSE().gravityRange);
        this.compoundGravityStrength.setSelection(lop.getCoSE().compoundGravityStrength);
        this.compoundGravityRange.setSelection(lop.getCoSE().compoundGravityRange);
        this.smartEdgeLengthCalc.setSelection(lop.getCoSE().smartEdgeLengthCalc);
        this.multiLevelScaling.setSelection(lop.getCoSE().multiLevelScaling);
    }

    public void setDefaultLayoutProperties(int select) {
        LayoutOptionsPack lop = LayoutOptionsPack.getInstance();
        if (select == 0) {
            if (lop.getGeneral().defaultLayoutQuality == 0) {
                this.proofButton.setSelection(true);
            } else if (lop.getGeneral().defaultLayoutQuality == 2) {
                this.draftButton.setSelection(true);
            } else {
                this.defaultButton.setSelection(true);
            }
            this.animateDuringLayoutButton.setSelection(lop.getGeneral().defaultAnimationDuringLayout);
            this.animateOnLayoutButton.setSelection(lop.getGeneral().defaultAnimationOnLayout);
            this.animationPeriod.setSelection(lop.getGeneral().defaultAnimationPeriod);
            this.incremental.setSelection(lop.getGeneral().defaultIncremental);
            this.createBendsAsButton.setSelection(lop.getGeneral().defaultCreateBendsAsNeeded);
            this.uniformLeafNodeSizesButton.setSelection(lop.getGeneral().defaultUniformLeafNodeSizes);
        } else if (select == 1) {
            this.desiredEdgeLengthCoSE.setText(String.valueOf(lop.getCoSE().defaultIdealEdgeLength));
            this.springStrength.setSelection(lop.getCoSE().defaultSpringStrength);
            this.repulsionStrength.setSelection(lop.getCoSE().defaultRepulsionStrength);
            this.smartRepulsionRangeCalc.setSelection(lop.getCoSE().defaultSmartRepulsionRangeCalc);
            this.gravityStrength.setSelection(lop.getCoSE().defaultGravityStrength);
            this.gravityRange.setSelection(lop.getCoSE().defaultGravityRange);
            this.compoundGravityStrength.setSelection(lop.getCoSE().defaultCompoundGravityStrength);
            this.compoundGravityRange.setSelection(lop.getCoSE().defaultCompoundGravityRange);
            this.smartEdgeLengthCalc.setSelection(lop.getCoSE().defaultSmartEdgeLengthCalc);
            this.multiLevelScaling.setSelection(lop.getCoSE().defaultMultiLevelScaling);
        }
    }
}

