/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.gui;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cbio.causality.data.portal.BroadAccessor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.layout.CellLayout;
import org.gvt.ChisioMain;

public class TCGAGenesDialog
extends Dialog {
    private static double lastMutsigThr = 0.05;
    private static double lastGisticThr = 0.05;
    private static int lastStudyIndex = 0;
    private Set<String> genes;
    private List<String> studyCodes;
    private Shell shell;
    private Combo studyCombo;
    private Button okButton;
    private Button cancelButton;
    private Button mutsigButton;
    private Button gisticButton;
    private Text mutsigThrField;
    private Text gisticThrField;

    public TCGAGenesDialog(Shell shell) {
        super(shell);
    }

    public Set<String> open() {
        this.createContents();
        this.shell.pack();
        this.shell.setLocation(this.getParent().getLocation().x + this.getParent().getSize().x / 2 - this.shell.getSize().x / 2, this.getParent().getLocation().y + this.getParent().getSize().y / 2 - this.shell.getSize().y / 2);
        this.shell.setImage(ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbe-icon.png").createImage());
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.genes;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67680);
        this.shell.setLayout(new CellLayout(1));
        this.shell.setText("Retrieve significantly altered genes in a TCGA study");
        Group studyGroup = new Group(this.shell, 0);
        studyGroup.setLayout(new RowLayout());
        Label studyLabel = new Label(studyGroup, 0);
        studyLabel.setText("TCGA Study:");
        this.studyCombo = new Combo(studyGroup, 8);
        this.studyCodes = BroadAccessor.getStudyCodes();
        this.studyCombo.setItems(this.studyCodes.toArray(new String[this.studyCodes.size()]));
        this.studyCombo.select(lastStudyIndex);
        ButtonAdapter adapter = new ButtonAdapter();
        Group middleGroup = new Group(this.shell, 0);
        middleGroup.setLayout(new GridLayout(2, false));
        this.mutsigButton = new Button(middleGroup, 32);
        this.mutsigThrField = new Text(middleGroup, 4);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.grabExcessVerticalSpace = false;
        data.horizontalAlignment = 16384;
        data.verticalAlignment = 1024;
        this.mutsigThrField.setLayoutData(data);
        this.gisticButton = new Button(middleGroup, 32);
        this.gisticThrField = new Text(middleGroup, 4);
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.grabExcessVerticalSpace = false;
        data.horizontalAlignment = 16384;
        data.verticalAlignment = 1024;
        this.gisticThrField.setLayoutData(data);
        this.mutsigButton.setSelection(true);
        this.mutsigButton.setText("Get mutated genes\nwith a MutSig q-value threshold");
        this.gisticButton.setText("Get copy number altered genes\nwith a Gistic q-value threshold");
        this.mutsigThrField.setText("" + lastMutsigThr);
        this.gisticThrField.setText("" + lastGisticThr);
        this.gisticThrField.setEnabled(false);
        this.mutsigButton.addSelectionListener(adapter);
        this.gisticButton.addSelectionListener(adapter);
        Composite buttonsGroup = new Composite(this.shell, 0);
        buttonsGroup.setLayout(new RowLayout());
        this.okButton = new Button(buttonsGroup, 0);
        this.okButton.setText("OK");
        this.okButton.addSelectionListener(adapter);
        this.cancelButton = new Button(buttonsGroup, 0);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addSelectionListener(adapter);
    }

    private void cancelPressed() {
        this.shell.dispose();
    }

    private void okPressed() {
        this.genes = new HashSet<String>();
        String study = this.studyCodes.get(this.studyCombo.getSelectionIndex());
        if (this.mutsigButton.getSelection()) {
            try {
                lastMutsigThr = Double.parseDouble(this.mutsigThrField.getText());
            }
            catch (NumberFormatException e) {
                MessageDialog.openError(this.shell, "Error", "Cannot read MutSig q-value threshold.");
                return;
            }
            this.genes.addAll(BroadAccessor.getMutsigGenes(study, lastMutsigThr, true));
        }
        if (this.gisticButton.getSelection()) {
            try {
                lastGisticThr = Double.parseDouble(this.gisticThrField.getText());
            }
            catch (NumberFormatException e) {
                MessageDialog.openError(this.shell, "Error", "Cannot read Gistic q-value threshold.");
                return;
            }
            this.genes.addAll(BroadAccessor.getGisticGenes(study, lastGisticThr));
        }
        lastStudyIndex = this.studyCombo.getSelectionIndex();
        this.shell.dispose();
    }

    class ButtonAdapter
    extends SelectionAdapter {
        ButtonAdapter() {
        }

        @Override
        public void widgetSelected(SelectionEvent arg) {
            Button button = (Button)arg.widget;
            TCGAGenesDialog.this.okButton.setEnabled(TCGAGenesDialog.this.mutsigButton.getSelection() || TCGAGenesDialog.this.gisticButton.getSelection());
            if (button == TCGAGenesDialog.this.okButton) {
                TCGAGenesDialog.this.okPressed();
            } else if (button == TCGAGenesDialog.this.cancelButton) {
                TCGAGenesDialog.this.cancelPressed();
            } else if (button == TCGAGenesDialog.this.mutsigButton) {
                TCGAGenesDialog.this.mutsigThrField.setEnabled(TCGAGenesDialog.this.mutsigButton.getSelection());
            } else if (button == TCGAGenesDialog.this.gisticButton) {
                TCGAGenesDialog.this.gisticThrField.setEnabled(TCGAGenesDialog.this.gisticButton.getSelection());
            }
        }
    }
}

