/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.inspector;

import java.util.Iterator;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.TableItem;
import org.gvt.ChisioMain;
import org.gvt.inspector.Inspector;
import org.gvt.model.CompoundModel;
import org.ivis.layout.Cluster;
import org.patika.mada.graph.GraphObject;

public class CompoundInspector
extends Inspector {
    private CompoundInspector(org.gvt.model.GraphObject model, String title, ChisioMain main) {
        super(model, title, main);
    }

    private void prepare() {
        TableItem item = this.addRow(this.table, "Text");
        item.setText(1, this.model.getText());
        item = this.addRow(this.table, "Text Font");
        Font font = this.model.getTextFont();
        String fontName = font.getFontData()[0].getName();
        int fontSize = font.getFontData()[0].getHeight();
        int fontStyle = font.getFontData()[0].getStyle();
        if (fontSize > 14) {
            fontSize = 14;
        }
        item.setText(1, fontName);
        item.setFont(1, new Font(null, fontName, fontSize, fontStyle));
        item.setForeground(1, this.model.getTextColor());
        item = this.addRow(this.table, "Color");
        item.setBackground(1, this.model.getColor());
        item = this.addRow(this.table, "Border Color");
        item.setBackground(1, ((CompoundModel)this.model).getBorderColor());
        item = this.addRow(this.table, "Cluster ID");
        String clusterText = "";
        Iterator<Cluster> itr = ((CompoundModel)this.model).getClusters().iterator();
        if (!itr.hasNext()) {
            item.setText(1, "0");
        } else {
            clusterText = clusterText + itr.next().getClusterID();
            while (itr.hasNext()) {
                clusterText = clusterText + ", " + itr.next().getClusterID();
            }
            item.setText(1, clusterText);
        }
    }

    private void prepareForGraphObject() {
        GraphObject go = (GraphObject)((Object)this.model);
        for (String[] property : go.getInspectable()) {
            this.addRow(this.table, property[0]).setText(1, property[1]);
        }
        this.table.getColumn(1).pack();
        this.table.pack();
    }

    private void show() {
        this.createContents(this.shell);
        this.shell.setLocation(this.calculateInspectorLocation(this.main.clickLocation.x, this.main.clickLocation.y));
        this.shell.open();
    }

    public static void getInstance(org.gvt.model.GraphObject model, String title, ChisioMain main) {
        if (CompoundInspector.isSingle(model)) {
            CompoundInspector inspector = new CompoundInspector(model, title, main);
            instances.add(inspector);
            inspector.prepare();
            if (model instanceof GraphObject) {
                inspector.prepareForGraphObject();
            }
            inspector.show();
        }
    }

    public void setAsDefault() {
        TableItem[] items;
        for (TableItem item : items = this.table.getItems()) {
            if (item.getText().equals("Name")) {
                CompoundModel.DEFAULT_TEXT = item.getText(1);
                continue;
            }
            if (item.getText().equals("Text Font")) {
                CompoundModel.DEFAULT_TEXT_FONT = this.newFont;
                CompoundModel.DEFAULT_TEXT_COLOR = item.getForeground(1);
                continue;
            }
            if (item.getText().equals("Color")) {
                CompoundModel.DEFAULT_COLOR = item.getBackground(1);
                continue;
            }
            if (item.getText().equals("Border Color")) {
                CompoundModel.DEFAULT_BORDER_COLOR = item.getBackground(1);
                continue;
            }
            if (!item.getText().equals("Cluster ID")) continue;
            CompoundModel.DEFAULT_CLUSTER_ID = Integer.parseInt(item.getText(1));
        }
    }
}

