/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.inspector;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.TableItem;
import org.gvt.ChisioMain;
import org.gvt.inspector.Inspector;
import org.gvt.model.BioPAXGraph;
import org.gvt.model.CompoundModel;
import org.gvt.model.GraphObject;

public class GraphInspector
extends Inspector {
    private GraphInspector(GraphObject model, String title, ChisioMain main) {
        super(model, title, main);
    }

    private void show() {
        this.createContents(this.shell);
        Point loc = this.shell.getParent().getShell().getLocation();
        Point size = this.shell.getParent().getShell().getSize();
        Point s = this.shell.getSize();
        this.shell.setLocation(size.x / 2 + loc.x - s.x / 2, size.y / 2 + loc.y - s.y / 2);
        this.shell.open();
    }

    private void prepare() {
        TableItem item = this.addRow(this.table, "Margin");
        item.setText(1, String.valueOf(CompoundModel.MARGIN_SIZE));
        item = this.addRow(this.table, "Highlight Color");
        item.setBackground(1, ChisioMain.higlightColor);
    }

    private void prepareForBioPAXGraph() {
        BioPAXGraph graph = (BioPAXGraph)this.model;
        for (String[] property : graph.getInspectable()) {
            this.addRow(this.table, property[0]).setText(1, property[1]);
        }
        this.table.getColumn(1).pack();
        this.table.pack();
    }

    public void setAsDefault() {
    }

    public static void getInstance(GraphObject model, String title, ChisioMain main) {
        if (GraphInspector.isSingle(model)) {
            GraphInspector ins = new GraphInspector(model, title, main);
            instances.add(ins);
            ins.prepare();
            if (model instanceof BioPAXGraph) {
                ins.prepareForBioPAXGraph();
            }
            ins.show();
        }
    }
}

