/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.inspector;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.gvt.ChisioMain;
import org.gvt.action.ChangeMarginAction;
import org.gvt.model.CompoundModel;
import org.gvt.model.EdgeModel;
import org.gvt.model.GraphObject;
import org.gvt.model.NodeModel;
import org.gvt.util.SystemBrowserDisplay;

public abstract class Inspector
extends Dialog {
    protected Table table;
    protected GraphObject model;
    protected ChisioMain main;
    protected static List<Inspector> instances = new ArrayList<Inspector>();
    protected Shell shell;
    protected Font newFont;
    protected KeyAdapter keyAdapter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent arg0) {
            arg0.doit = this.isDigit(arg0.keyCode);
        }

        public boolean isDigit(int keyCode) {
            return Character.isDigit(keyCode) || keyCode == 127 || keyCode == 8 || keyCode == 0x1000003 || keyCode == 0x1000004;
        }
    };
    protected static int col0Width = 75;
    protected static int col1Width = 250;
    protected static int rowHeight = 20;
    protected static int MAX_HEIGHT = 500;
    protected static int INSPECTOR_WIDTH = 350;
    protected static final RGB hyperlinkRGB = new RGB(0, 20, 120);

    protected Inspector(GraphObject model, String title, ChisioMain main) {
        super(main.getShell(), 0);
        this.main = main;
        this.shell = new Shell(main.getShell(), 2160);
        this.shell.setText(title + " Properties");
        ImageDescriptor id = ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbe-icon.png");
        this.shell.setImage(id.createImage());
        GridLayout layout = new GridLayout();
        this.shell.setLayout(layout);
        ScrolledComposite sc = new ScrolledComposite(this.shell, 784);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        gridData.heightHint = 400;
        sc.setLayoutData(gridData);
        this.model = model;
        this.table = this.createTable(sc);
        this.newFont = model.getTextFont();
    }

    public Table createTable(ScrolledComposite sc) {
        Table table = new Table(sc, 101140);
        table.setLinesVisible(true);
        sc.setContent(table);
        TableColumn attributes = new TableColumn(table, 16384, 0);
        attributes.pack();
        TableColumn values = new TableColumn(table, 16384, 1);
        values.pack();
        return table;
    }

    public TableItem addRow(Table table, String label) {
        TableItem item = new TableItem(table, 0);
        item.setText(0, label);
        table.getColumn(0).pack();
        if (item.getText(0).equals("Reference")) {
            item.setForeground(1, new Color(this.shell.getDisplay(), hyperlinkRGB));
        }
        return item;
    }

    public void createContents(final Shell shell) {
        final TableEditor editor = new TableEditor(this.table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        this.table.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                TableItem item;
                Control old = editor.getEditor();
                if (old != null) {
                    old.dispose();
                }
                if ((item = (TableItem)event.item) != null) {
                    if (item.getText().equals("Style") || item.getText().equals("Arrow") || item.getText().equals("Shape")) {
                        final CCombo combo = new CCombo(Inspector.this.table, 8);
                        if (item.getText().equals("Style")) {
                            String[] styleOfEdge = new String[]{"Solid", "Dashed"};
                            combo.setItems(styleOfEdge);
                        } else if (item.getText().equals("Arrow")) {
                            String[] arrowOfEdge = new String[]{"None", "Source", "Target", "Both", "Modulation", "Stimulation", "Catalysis", "Inhibition"};
                            combo.setItems(arrowOfEdge);
                        } else if (item.getText().equals("Shape")) {
                            combo.setItems(NodeModel.shapes);
                        }
                        combo.select(combo.indexOf(item.getText(1)));
                        editor.setEditor(combo, item, 1);
                        combo.addSelectionListener(new SelectionAdapter(){

                            @Override
                            public void widgetSelected(SelectionEvent event) {
                                item.setText(1, combo.getText());
                                combo.dispose();
                            }
                        });
                    } else if (item.getText().equals("Text")) {
                        final Text text = new Text(Inspector.this.table, 16384);
                        text.setText(item.getText(1));
                        text.selectAll();
                        text.setFocus();
                        editor.setEditor(text, item, 1);
                        text.addModifyListener(new ModifyListener(){

                            @Override
                            public void modifyText(ModifyEvent event) {
                                item.setText(1, text.getText());
                            }
                        });
                    } else if (item.getText().equals("Margin") || item.getText().equals("Cluster ID") || item.getText().equals("Width")) {
                        final Text text = new Text(Inspector.this.table, 16384);
                        text.setText(item.getText(1));
                        text.selectAll();
                        text.setFocus();
                        editor.setEditor(text, item, 1);
                        text.addModifyListener(new ModifyListener(){

                            @Override
                            public void modifyText(ModifyEvent event) {
                                item.setText(1, text.getText());
                            }
                        });
                        text.addKeyListener(Inspector.this.keyAdapter);
                    } else if (item.getText().equals("Border Color") || item.getText().equals("Color") || item.getText().equals("Highlight Color")) {
                        ColorDialog dialog = new ColorDialog(shell);
                        dialog.setRGB(item.getBackground(1).getRGB());
                        RGB rgb = dialog.open();
                        if (rgb != null) {
                            item.setBackground(1, new Color(shell.getDisplay(), rgb));
                        }
                    } else if (item.getText().equals("Text Font")) {
                        FontDialog dlg = new FontDialog(shell);
                        dlg.setFontList(Inspector.this.newFont.getFontData());
                        dlg.setRGB(item.getForeground(1).getRGB());
                        if (dlg.open() != null) {
                            Inspector.this.newFont = new Font((Device)shell.getDisplay(), dlg.getFontList());
                            String name = Inspector.this.newFont.getFontData()[0].getName();
                            int size = Inspector.this.newFont.getFontData()[0].getHeight();
                            int style = Inspector.this.newFont.getFontData()[0].getStyle();
                            if (size > 14) {
                                size = 14;
                            }
                            item.setText(1, name);
                            item.setFont(1, new Font(null, name, size, style));
                            item.setForeground(1, new Color(shell.getDisplay(), dlg.getRGB()));
                        }
                    } else if (item.getText().equals("Reference")) {
                        String[] s = item.getText(1).split(":");
                        String hpl = null;
                        if (s[0].equalsIgnoreCase("GO") || s[0].equalsIgnoreCase("GENE_ONTOLOGY") || s[0].equalsIgnoreCase("GENE ONTOLOGY")) {
                            hpl = "http://amigo.geneontology.org/cgi-bin/amigo/term-details.cgi?term=GO:" + s[1];
                        } else if (s[0].equalsIgnoreCase("Reactome")) {
                            hpl = s[1].startsWith("R") ? "http://http://www.reactome.org/content/detail/" + s[1] : "http://www.reactome.org/cgi-bin/eventbrowser?DB=gk_current&ID=" + s[1];
                        } else if (s[0].equalsIgnoreCase("UniProt")) {
                            hpl = "http://www.uniprot.org/uniprot/" + s[1];
                        } else if (s[0].equalsIgnoreCase("REF_SEQ") || s[0].equalsIgnoreCase("REFSEQ")) {
                            hpl = "http://www.ncbi.nlm.nih.gov/sites/gquery?term=" + s[1];
                        } else if (s[0].equalsIgnoreCase("CPATH")) {
                            hpl = "http://www.pathwaycommons.org/pc/record2.do?id=" + s[1];
                        } else if (s[0].equalsIgnoreCase("ENTREZ_GENE") || s[0].equalsIgnoreCase("ENTREZGENE")) {
                            hpl = "http://www.ncbi.nlm.nih.gov/sites/entrez?db=gene&term=" + s[1];
                        } else if (s[0].equalsIgnoreCase("chebi")) {
                            hpl = "http://www.ebi.ac.uk/chebi/advancedSearchFT.do?searchString=" + s[1];
                        } else if (s[0].equalsIgnoreCase("HGNC SYMBOL")) {
                            hpl = "http://www.genenames.org/data/hgnc_data.php?gd_app_sym=" + s[1];
                        } else if (s[0].equalsIgnoreCase("PUBMED")) {
                            hpl = "http://www.ncbi.nlm.nih.gov/pubmed/" + s[1];
                        } else if (s[0].equalsIgnoreCase("PMC International")) {
                            hpl = "https://www.ncbi.nlm.nih.gov/pmc/articles/" + s[1];
                        } else if (s[0].equalsIgnoreCase("NCBI_TAXONOMY") || s[0].equalsIgnoreCase("NCBI TAXONOMY")) {
                            hpl = "http://www.ncbi.nlm.nih.gov/Taxonomy/Browser/wwwtax.cgi?id=" + s[1];
                        } else if (s[0].equalsIgnoreCase("HumanCyc")) {
                            hpl = "http://biocyc.org/HUMAN/NEW-IMAGE?object=" + s[1];
                        } else if (s[0].equalsIgnoreCase("LIGAND") || s[0].equalsIgnoreCase("COMPOUND")) {
                            hpl = "http://www.genome.jp/dbget-bin/www_bget?compound+" + s[1];
                        } else if (s[0].equalsIgnoreCase("INTERPRO")) {
                            hpl = "http://www.ebi.ac.uk/interpro/ISearch?query=" + s[1];
                        } else if (s[0].equalsIgnoreCase("ENSEMBL")) {
                            hpl = "http://www.ensembl.org/Homo_sapiens/Search/Summary?species=all;idx=;q=" + s[1];
                        }
                        if (hpl != null) {
                            SystemBrowserDisplay.openURL(hpl);
                        }
                    } else {
                        Text text = new Text(Inspector.this.table, 16384);
                        text.setText(item.getText(1));
                        editor.setEditor(text, item, 1);
                    }
                    Inspector.this.table.setSelection(-1);
                }
            }
        });
        Composite buttons = new Composite(shell, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        buttons.setLayout(gridLayout);
        Button okButton = new Button(buttons, 0);
        okButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                for (TableItem item : items = Inspector.this.table.getItems()) {
                    if (item.getText().equals("Text")) {
                        Inspector.this.model.setText(item.getText(1));
                        continue;
                    }
                    if (item.getText().equals("Text Font")) {
                        Inspector.this.model.setTextFont(Inspector.this.newFont);
                        Inspector.this.model.setTextColor(item.getForeground(1));
                        continue;
                    }
                    if (item.getText().equals("Color")) {
                        Inspector.this.model.setColor(item.getBackground(1));
                        continue;
                    }
                    if (item.getText().equals("Border Color")) {
                        ((NodeModel)Inspector.this.model).setBorderColor(item.getBackground(1));
                        continue;
                    }
                    if (item.getText().equals("Highlight Color")) {
                        ChisioMain.higlightColor = item.getBackground(1);
                        continue;
                    }
                    if (item.getText().equals("Shape")) {
                        ((NodeModel)Inspector.this.model).setShape(item.getText(1));
                        continue;
                    }
                    if (item.getText().equals("Style")) {
                        ((EdgeModel)Inspector.this.model).setStyle(item.getText(1));
                        continue;
                    }
                    if (item.getText().equals("Arrow")) {
                        ((EdgeModel)Inspector.this.model).setArrow(item.getText(1));
                        continue;
                    }
                    if (item.getText().equals("Width")) {
                        ((EdgeModel)Inspector.this.model).setWidth(Integer.parseInt(item.getText(1)));
                        continue;
                    }
                    if (!item.getText().equals("Margin")) continue;
                    new ChangeMarginAction((CompoundModel)Inspector.this.model, Integer.parseInt(item.getText(1))).run();
                }
                shell.close();
            }
        });
        okButton.setText("OK");
        Button cancelButton = new Button(buttons, 0);
        cancelButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                shell.close();
            }
        });
        cancelButton.setText("Cancel");
        GridData data = new GridData();
        data.horizontalAlignment = 0x1000000;
        buttons.setLayoutData(data);
        int numOfRow = this.table.getItemCount();
        int heightOfRow = numOfRow > 0 ? this.table.getItem((int)0).getBounds((int)0).height + 1 : 0;
        shell.setSize(INSPECTOR_WIDTH, Math.min(115 + numOfRow * heightOfRow, MAX_HEIGHT));
    }

    protected static boolean isSingle(GraphObject model) {
        if (instances.size() == 0) {
            return true;
        }
        for (Inspector inspector : instances) {
            if (!inspector.model.equals(model)) continue;
            if (inspector.shell.isDisposed()) {
                instances.remove(inspector);
                return true;
            }
            inspector.shell.forceActive();
            return false;
        }
        return true;
    }

    public Point calculateInspectorLocation(int clickLocX, int clickLocY) {
        Point loc = this.shell.getParent().getShell().getLocation();
        Point inspectorLoc = new Point(clickLocX + 10, clickLocY + 80);
        int height = this.shell.getParent().getSize().y;
        int width = this.shell.getParent().getSize().x;
        int diffY = inspectorLoc.y + this.shell.getSize().y - height;
        int diffX = inspectorLoc.x + this.shell.getSize().x - width;
        if (diffY < 0) {
            diffY = 0;
        }
        if (diffX < 0) {
            diffX = 0;
        }
        return new Point(loc.x + inspectorLoc.x - diffX, loc.y + inspectorLoc.y - diffY);
    }
}

