/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.layout;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gvt.layout.BiPaNode;
import org.gvt.model.NodeModel;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraph;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LNode;
import org.ivis.layout.cose.CoSELayout;

public class BiPaLayout
extends CoSELayout {
    Map<BiPaNode, LGraph> childGraphMap = new HashMap<BiPaNode, LGraph>();
    Map<BiPaNode, MemberPack> memberPackMap = new HashMap<BiPaNode, MemberPack>();
    private static final int COMPLEX_MEM_HORIZONTAL_BUFFER = 5;
    private static final int COMPLEX_MEM_VERTICAL_BUFFER = 5;
    private static final double COMPLEX_CHILD_GRAPH_BUFFER = 10.0;
    private static final double COMPLEX_LABEL_HEIGHT = 20.0;
    private static final double COMPLEX_MIN_WIDTH = 20.0;

    @Override
    public LNode newNode(Object vNode) {
        return new BiPaNode(this.graphManager, vNode);
    }

    public LNode newNode(LGraphManager gm, Point loc, Dimension size, Object vNode) {
        return new BiPaNode(gm, loc, size, vNode);
    }

    public LNode createNewLNode(LGraphManager gm, NodeModel model) {
        return new BiPaNode(gm, (Object)model);
    }

    protected void clearComplexes() {
        for (Object o : this.getAllNodes()) {
            BiPaNode comp;
            if (!(o instanceof BiPaNode) || !((BiPaNode)o).isComplex() || (comp = (BiPaNode)o).getChild().getNodes().isEmpty()) continue;
            LGraph childGr = comp.getChild();
            this.childGraphMap.put(comp, childGr);
            MemberPack pack = new MemberPack(childGr);
            this.memberPackMap.put(comp, pack);
            this.getGraphManager().getGraphs().remove(childGr);
            comp.setChild(null);
            comp.setWidth(pack.getWidth());
            comp.setHeight(pack.getHeight());
            for (Object ch : childGr.getNodes()) {
                BiPaNode chNd = (BiPaNode)ch;
                for (Object obj : new ArrayList(chNd.getEdges())) {
                    LEdge edge = (LEdge)obj;
                    if (edge.getSource() == chNd) {
                        chNd.getEdges().remove(edge);
                        edge.setSource(comp);
                        comp.getEdges().add(edge);
                        continue;
                    }
                    if (edge.getTarget() != chNd) continue;
                    chNd.getEdges().remove(edge);
                    edge.setTarget(comp);
                    comp.getEdges().add(edge);
                }
            }
        }
        this.getGraphManager().resetAllNodes();
        this.getGraphManager().resetAllNodesToApplyGravitation();
        this.getGraphManager().resetAllEdges();
    }

    protected void repopulateComplexes() {
        for (BiPaNode comp : this.childGraphMap.keySet()) {
            LGraph chGr = this.childGraphMap.get(comp);
            comp.setChild(chGr);
            this.getGraphManager().getGraphs().add(chGr);
            MemberPack pack = this.memberPackMap.get(comp);
            pack.adjustLocations(comp.getLeft(), comp.getTop());
        }
        this.getGraphManager().resetAllNodes();
        this.getGraphManager().resetAllNodesToApplyGravitation();
        this.getGraphManager().resetAllEdges();
    }

    @Override
    public boolean layout() {
        this.clearComplexes();
        boolean b = super.layout();
        this.repopulateComplexes();
        return b;
    }

    protected class Organization {
        public static final int FAVOR_DIM_HORIZONTAL = 0;
        public static final int FAVOR_DIM_VERTICAL = 1;
        private double width;
        private double height;
        private double idealRowWidth;
        private List<Double> rowWidth;
        private List<LinkedList<BiPaNode>> rows;
        private List<BiPaNode> members;
        private int favorDim;

        public Organization(List<BiPaNode> members, int favorDim) {
            this.members = members;
            this.favorDim = favorDim;
            this.width = 20.0;
            this.height = 40.0;
            this.rowWidth = new ArrayList<Double>();
            this.rows = new ArrayList<LinkedList<BiPaNode>>();
            this.idealRowWidth = this.calcIdealRowWidth();
            for (BiPaNode node : members) {
                this.insertNode(node);
            }
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height + (double)(this.firstRowHasInfo() ? 6 : 0) + (double)(this.lastRowHasInfo() ? 6 : 0);
        }

        public double getRatio() {
            double height;
            double width = this.getWidth();
            double ratio = width / (height = this.getHeight());
            if (ratio < 1.0) {
                ratio = 1.0 / ratio;
            }
            return ratio;
        }

        private double calcIdealRowWidth() {
            int membersSize = this.members.size();
            double totalWidth = 0.0;
            double totalHeight = 0.0;
            double maxWidth = Double.MIN_VALUE;
            for (BiPaNode node : this.members) {
                totalWidth += node.getWidth();
                totalHeight += node.getHeight();
                if (!(node.getWidth() > maxWidth)) continue;
                maxWidth = node.getWidth();
            }
            double averageWidth = totalWidth / (double)membersSize;
            double averageHeight = totalHeight / (double)membersSize;
            double delta = Math.pow(0.0, 2.0) + 4.0 * (averageWidth + 5.0) * (averageHeight + 5.0) * (double)membersSize;
            double horizontalCountDouble = (0.0 + Math.sqrt(delta)) / (2.0 * (averageWidth + 5.0));
            int horizontalCount = this.favorDim == 0 ? (int)Math.ceil(horizontalCountDouble) : (int)Math.floor(horizontalCountDouble);
            double idealWidth = (double)horizontalCount * (averageWidth + 5.0) - 5.0;
            if (maxWidth > idealWidth) {
                idealWidth = maxWidth;
            }
            return idealWidth += 20.0;
        }

        public void insertNode(BiPaNode node) {
            if (this.rows.isEmpty()) {
                this.insertNodeToRow(node, 0);
            } else if (this.canBeAddedToRow(node.getWidth(), this.rows.size() - 1)) {
                this.insertNodeToRow(node, this.rows.size() - 1);
            } else {
                this.insertNodeToRow(node, this.rows.size());
            }
        }

        private boolean canBeAddedToRow(double nodeWidth, int rowIndex) {
            double currentWidth = this.rowWidth.get(rowIndex);
            return currentWidth + nodeWidth + 5.0 <= this.idealRowWidth;
        }

        private void insertNodeToRow(BiPaNode node, int rowIndex) {
            if (rowIndex == this.rows.size()) {
                if (!this.rows.isEmpty()) {
                    this.height += 5.0;
                }
                this.rows.add(new LinkedList());
                this.height += 20.0;
                this.rowWidth.add(20.0);
                assert (this.rows.size() == this.rowWidth.size());
            }
            double w = this.rowWidth.get(rowIndex) + node.getWidth();
            if (!this.rows.get(rowIndex).isEmpty()) {
                w += 5.0;
            }
            this.rowWidth.set(rowIndex, w);
            this.rows.get(rowIndex).add(node);
            if (this.width < w) {
                this.width = w;
            }
        }

        private boolean firstRowHasInfo() {
            return this.rowHasInfo(this.rows.get(0));
        }

        private boolean lastRowHasInfo() {
            return this.rowHasInfo(this.rows.get(this.rows.size() - 1));
        }

        private boolean rowHasInfo(LinkedList<BiPaNode> row) {
            for (BiPaNode node : row) {
                if (!node.hasInfo()) continue;
                return true;
            }
            return false;
        }

        public void adjustLocations(double x, double y) {
            y += 10.0 + (double)(this.firstRowHasInfo() ? 6 : 0);
            double left = x += 10.0;
            for (LinkedList<BiPaNode> row : this.rows) {
                x = left;
                for (BiPaNode node : row) {
                    double yy = node.getHeight() - 1.0E-4 > 20.0 ? y - 6.0 : y;
                    node.setLocation(x, yy);
                    x += node.getWidth() + 5.0;
                }
                y += 25.0;
            }
        }
    }

    protected class ComparableNode
    implements Comparable {
        private BiPaNode node;

        public ComparableNode(BiPaNode node) {
            this.node = node;
        }

        public BiPaNode getNode() {
            return this.node;
        }

        public int compareTo(Object o) {
            return new Double(((ComparableNode)o).getNode().getWidth()).compareTo(this.node.getWidth());
        }
    }

    protected class MemberPack {
        private List<BiPaNode> members = new ArrayList<BiPaNode>();
        private Organization org;

        public MemberPack(LGraph childG) {
            this.members.addAll(childG.getNodes());
            this.sortMembers();
            this.org = this.getBestOrganizationForMembers(this.members);
        }

        private Organization getBestOrganizationForMembers(List<BiPaNode> members) {
            Organization horizontalOrg = new Organization(members, 0);
            Organization verticalOrg = new Organization(members, 1);
            double horizontalRatio = horizontalOrg.getRatio();
            double verticalRatio = verticalOrg.getRatio();
            Organization bestOrg = verticalRatio < horizontalRatio ? verticalOrg : horizontalOrg;
            return bestOrg;
        }

        private void sortMembers() {
            Collections.sort(this.members, new Comparator<BiPaNode>(){

                @Override
                public int compare(BiPaNode o1, BiPaNode o2) {
                    return o1.getText().compareTo(o2.getText());
                }
            });
        }

        public double getWidth() {
            return this.org.getWidth();
        }

        public double getHeight() {
            return this.org.getHeight();
        }

        public void adjustLocations(double x, double y) {
            this.org.adjustLocations(x, y);
        }
    }
}

