/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.eclipse.swt.graphics.Color;
import org.gvt.model.CompoundModel;
import org.gvt.model.EntityAssociated;
import org.gvt.model.GraphObject;
import org.gvt.model.biopaxl2.BioPAXL2Graph;
import org.gvt.model.biopaxl3.BioPAXL3Graph;
import org.gvt.util.EntityHolder;
import org.gvt.util.PathwayHolder;
import org.patika.mada.graph.Edge;
import org.patika.mada.graph.Graph;
import org.patika.mada.graph.Node;
import org.patika.mada.util.Path;
import org.patika.mada.util.XRef;

public abstract class BioPAXGraph
extends CompoundModel
implements Graph {
    protected Model biopaxModel;
    protected String graphType;
    protected Map<org.patika.mada.graph.GraphObject, org.patika.mada.graph.GraphObject> excisionMapOrigToThis;
    protected Map<org.patika.mada.graph.GraphObject, org.patika.mada.graph.GraphObject> excisionMapThisToOrig;
    protected Map<EntityHolder, List<Node>> entityToNodeMap;
    protected String lastAppliedColoring;
    public static final Color noDataC = new Color(null, 255, 255, 255);
    public static final Color noDataC_Protein = new Color(null, 255, 255, 200);
    public static final String noDataText = "No Data";
    public static final String EXCISED_FROM = "EXCISED_FROM";
    public static final String CHIBE_TAG = "#chibedata";
    public static final String LAYOUT_TAG = "Layout";
    public static final String PATHWAY_CONTENT_TAG = "#chibedata-pathwaymember";
    public static final String MODEL_TAG_SEPARATOR = "@";
    public static final String DEPLETING_REACTION_TAG = "DEPLETING_REACTION";
    public static final String TRANSCRIPTION_TAG = "TRANSCRIPTION_TAG";
    public static final String PROCESS_DIAGRAM = "PROCESS_DIAGRAM";
    public static final String SIF_LEVEL2 = "SIF_LEVEL2";
    public static final String SIF_LEVEL3 = "SIF_LEVEL3";
    public static final String BASIC_SIF = "BASIC_SIF";

    public boolean isMechanistic() {
        return this.graphType.equals(PROCESS_DIAGRAM);
    }

    public Model getBiopaxModel() {
        return this.biopaxModel;
    }

    public String getGraphType() {
        return this.graphType;
    }

    public Set<GraphObject> getGraphObjects() {
        HashSet<GraphObject> set = new HashSet<GraphObject>(this.getNodes());
        set.addAll(this.getEdges());
        return set;
    }

    public void setGraphType(String graphType) {
        this.graphType = graphType;
    }

    public void setBiopaxModel(Model biopaxModel) {
        this.biopaxModel = biopaxModel;
    }

    public String getName() {
        return this.getText();
    }

    public void setName(String name) {
        this.setText(name);
    }

    public String getLastAppliedColoring() {
        return this.lastAppliedColoring;
    }

    public void setLastAppliedColoring(String lastAppliedColoring) {
        this.lastAppliedColoring = lastAppliedColoring;
    }

    @Override
    public void removeLabels(Collection labels) {
        for (Object o : this.getNodes()) {
            Node node = (Node)o;
            for (Object label : labels) {
                node.removeLabel(label);
            }
        }
    }

    public abstract String getPathwayRDFID();

    public abstract List<String[]> getInspectable();

    public void putInExcisionMap(org.patika.mada.graph.GraphObject original, org.patika.mada.graph.GraphObject member) {
        if (this.excisionMapOrigToThis == null) {
            this.excisionMapOrigToThis = new HashMap<org.patika.mada.graph.GraphObject, org.patika.mada.graph.GraphObject>();
            this.excisionMapThisToOrig = new HashMap<org.patika.mada.graph.GraphObject, org.patika.mada.graph.GraphObject>();
        }
        this.excisionMapOrigToThis.put(original, member);
        this.excisionMapThisToOrig.put(member, original);
    }

    public org.patika.mada.graph.GraphObject getCorrespMember(org.patika.mada.graph.GraphObject orig) {
        return this.excisionMapOrigToThis.get(orig);
    }

    public Set<org.patika.mada.graph.GraphObject> getCorrespMember(Collection<org.patika.mada.graph.GraphObject> origs) {
        HashSet<org.patika.mada.graph.GraphObject> members = new HashSet<org.patika.mada.graph.GraphObject>();
        for (org.patika.mada.graph.GraphObject orig : origs) {
            org.patika.mada.graph.GraphObject mem = this.getCorrespMember(orig);
            if (mem == null) continue;
            members.add(mem);
        }
        return members;
    }

    public org.patika.mada.graph.GraphObject getCorrespOrig(org.patika.mada.graph.GraphObject member) {
        return this.excisionMapThisToOrig.get(member);
    }

    public Set<org.patika.mada.graph.GraphObject> getCorrespOrig(Collection<org.patika.mada.graph.GraphObject> members) {
        HashSet<org.patika.mada.graph.GraphObject> origs = new HashSet<org.patika.mada.graph.GraphObject>();
        for (org.patika.mada.graph.GraphObject member : members) {
            org.patika.mada.graph.GraphObject orig = this.getCorrespOrig(member);
            if (orig == null) continue;
            origs.add(orig);
        }
        return origs;
    }

    @Override
    public BioPAXGraph excise(Collection<org.patika.mada.graph.GraphObject> objects) {
        return this.excise(objects, false);
    }

    public abstract BioPAXGraph excise(Collection<org.patika.mada.graph.GraphObject> var1, boolean var2);

    public BioPAXGraph excise(Collection<Path> paths, boolean keepHighlights, boolean whatever) {
        HashSet<org.patika.mada.graph.GraphObject> set = new HashSet<org.patika.mada.graph.GraphObject>();
        for (Path path : paths) {
            set.addAll(path.getObjects());
        }
        return this.excise(set, keepHighlights);
    }

    public Map<EntityHolder, List<Node>> getEntityToNodeMap() {
        this.prepareEntityToNodeMap();
        return this.entityToNodeMap;
    }

    protected abstract void prepareEntityToNodeMap();

    public Set<EntityHolder> getAllEntities() {
        this.prepareEntityToNodeMap();
        return this.entityToNodeMap.keySet();
    }

    public abstract void representDataOnActors(String var1);

    public abstract void removeRepresentations();

    public abstract boolean fetchLayout();

    public abstract boolean fetchLayout(String var1);

    public abstract void recordLayout();

    public abstract void forgetLayout();

    public void hihglightRelatedNodes(Collection<EntityHolder> entities) {
        Map<EntityHolder, List<Node>> map = this.getEntityToNodeMap();
        for (EntityHolder entity2 : entities) {
            if (!map.containsKey(entity2)) continue;
            List<Node> nodes = map.get(entity2);
            for (Node node : nodes) {
                assert (this.getNodes().contains(node));
                node.setHighlight(true);
            }
        }
    }

    public Set<EntityHolder> getRelatedEntities(Collection<XRef> refs) {
        HashSet<EntityHolder> entities = new HashSet<EntityHolder>();
        block0: for (Object o : this.getNodes()) {
            if (!(o instanceof EntityAssociated)) continue;
            EntityAssociated node = (EntityAssociated)o;
            for (XRef xRef : node.getReferences()) {
                if (!refs.contains(xRef)) continue;
                entities.add(node.getEntity());
                continue block0;
            }
        }
        return entities;
    }

    @Override
    public void removeHighlights() {
        for (Object o : this.getNodes()) {
            Node node = (Node)o;
            node.setHighlight(false);
        }
        for (Object o : this.getEdges()) {
            Edge edge = (Edge)o;
            edge.setHighlight(false);
        }
    }

    public abstract Set<Node> getRelatedStates(EntityHolder var1);

    public abstract Set<Node> getRelatedStates(Collection<EntityHolder> var1);

    public abstract void replaceComplexMembersWithComplexes(Collection<Node> var1);

    public abstract BioPAXGraph excise(PathwayHolder var1);

    public abstract PathwayHolder getPathway();

    public abstract void setPathway(PathwayHolder var1);

    public abstract void registerContentsToPathway();

    public static BioPAXGraph newInstance(Model model, List<String> pathwayMemberIDs, String pathwayName) {
        if (model.getLevel() == BioPAXLevel.L3) {
            return new BioPAXL3Graph(model, pathwayMemberIDs, pathwayName);
        }
        if (model.getLevel() == BioPAXLevel.L2) {
            return new BioPAXL2Graph(model, pathwayMemberIDs, pathwayName);
        }
        throw new IllegalArgumentException("Unsupported BioPAX leve: " + (Object)((Object)model.getLevel()));
    }

    public static BioPAXGraph newInstance(Model model) {
        if (model.getLevel() == BioPAXLevel.L3) {
            return new BioPAXL3Graph(model);
        }
        if (model.getLevel() == BioPAXLevel.L2) {
            return new BioPAXL2Graph(model);
        }
        throw new IllegalArgumentException("Unsupported BioPAX leve: " + (Object)((Object)model.getLevel()));
    }

    public static BioPAXGraph newInstance(Model model, PathwayHolder holder) {
        if (model.getLevel() == BioPAXLevel.L3) {
            return new BioPAXL3Graph(model, holder != null ? holder.l3p : null);
        }
        if (model.getLevel() == BioPAXLevel.L2) {
            return new BioPAXL2Graph(model, holder != null ? holder.l2p : null);
        }
        throw new IllegalArgumentException("Unsupported BioPAX leve: " + (Object)((Object)model.getLevel()));
    }
}

