/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model;

import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.gvt.model.EdgeModel;

public class EdgeBendpoint
implements Bendpoint {
    private Connection connection;
    private float weight = 0.5f;
    private Dimension d1;
    private Dimension d2;

    public EdgeBendpoint() {
    }

    public EdgeBendpoint(Connection conn) {
        this.setConnection(conn);
    }

    public EdgeBendpoint(int dim1w, int dim1h, int dim2w, int dim2h) {
        this.d1 = new Dimension(dim1w, dim1h);
        this.d2 = new Dimension(dim2w, dim2h);
    }

    protected Connection getConnection() {
        return this.connection;
    }

    @Override
    public Point getLocation() {
        Point a1 = this.getConnection().getSourceAnchor().getReferencePoint();
        Point a2 = this.getConnection().getTargetAnchor().getReferencePoint();
        Point p = new Point();
        Dimension dim1 = this.d1.getCopy();
        Dimension dim2 = this.d2.getCopy();
        this.getConnection().translateToAbsolute(dim1);
        this.getConnection().translateToAbsolute(dim2);
        p.x = (int)((float)(a1.x + dim1.width) * (1.0f - this.weight) + this.weight * (float)(a2.x + dim2.width));
        p.y = (int)((float)(a1.y + dim1.height) * (1.0f - this.weight) + this.weight * (float)(a2.y + dim2.height));
        this.getConnection().translateToRelative(p);
        return p;
    }

    public Point getLocationFromModel(EdgeModel model) {
        Dimension dim1 = model.getSource().getSize();
        Dimension dim2 = model.getTarget().getSize();
        Point a1 = model.getSource().getLocationAbs().translate(dim1.getScaled(0.5));
        Point a2 = model.getTarget().getLocationAbs().translate(dim2.getScaled(0.5));
        Point p = new Point();
        dim1 = this.d1.getCopy();
        dim2 = this.d2.getCopy();
        p.x = (int)((float)(a1.x + dim1.width) * (1.0f - this.weight) + this.weight * (float)(a2.x + dim2.width));
        p.y = (int)((float)(a1.y + dim1.height) * (1.0f - this.weight) + this.weight * (float)(a2.y + dim2.height));
        return p;
    }

    public void setConnection(Connection conn) {
        this.connection = conn;
    }

    public void setRelativeDimensions(Dimension dim1, Dimension dim2) {
        this.d1 = dim1;
        this.d2 = dim2;
    }

    public void setWeight(float w) {
        this.weight = w;
    }

    public Dimension getFirstRelativeDimension() {
        return this.d1;
    }

    public Dimension getSecondRelativeDimension() {
        return this.d2;
    }

    public float getWeight() {
        return this.weight;
    }

    public String toString() {
        return this.d1.width + "," + this.d1.height + "," + this.d2.width + "," + this.d2.height;
    }
}

