/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public abstract class GraphObject {
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    protected String text;
    protected String tooltipText;
    protected Font textFont;
    protected Color textColor;
    protected Color color;
    protected boolean highlight;
    protected Color highlightColor;
    protected Map<Object, Object> dataMap = new HashMap<Object, Object>(1);
    public static final String P_TOOLTIP_TEXT = "_tooltipText";
    public static final String P_TEXT = "_text";
    public static final String P_TEXTFONT = "_textFont";
    public static final String P_TEXTCOLOR = "_textColor";
    public static final String P_COLOR = "_color";
    public static final String P_HIGHLIGHT = "_highlight";
    public static final String P_HIGHLIGHTCOLOR = "_highlightColor";

    protected GraphObject() {
    }

    public void setText(String text) {
        this.text = text;
        this.firePropertyChange(P_TEXT, null, this.text);
    }

    public String getText() {
        return this.text;
    }

    public void setTextFont(Font font) {
        this.textFont = font;
        this.firePropertyChange(P_TEXTFONT, null, this.textFont);
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
        this.firePropertyChange(P_TEXTCOLOR, null, this.textColor);
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public String getTooltipText() {
        return this.tooltipText;
    }

    public void setTooltipText(String tooltipText) {
        this.tooltipText = tooltipText;
        this.firePropertyChange(P_TOOLTIP_TEXT, null, this.tooltipText);
    }

    public void setColor(Color c) {
        this.color = c;
        this.firePropertyChange(P_COLOR, null, this.color);
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
        this.firePropertyChange(P_HIGHLIGHT, null, this.highlight);
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
        this.firePropertyChange(P_HIGHLIGHTCOLOR, null, this.highlightColor);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    public void firePropertyChange(String propName, Object oldValue, Object newValue) {
        this.listeners.firePropertyChange(propName, oldValue, newValue);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    public void putLabel(Object label, Object value) {
        this.dataMap.put(label, value);
    }

    public void putLabel(Object label) {
        this.dataMap.put(label, null);
    }

    public boolean hasLabel(Object label) {
        return this.dataMap.containsKey(label);
    }

    public boolean hasLabel(Object label, Object value) {
        return this.dataMap.containsKey(label) && this.dataMap.get(label).equals(value);
    }

    public void removeLabel(Object label) {
        this.dataMap.remove(label);
    }

    public Object getLabel(Object label) {
        return this.dataMap.get(label);
    }

    public Set<Object> getAllLabels() {
        return this.dataMap.keySet();
    }
}

