/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.basicsif;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.gvt.model.GraphObject;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl3.BioPAXEdge;
import org.gvt.model.sifl3.SIFEdge;

public class BasicSIFEdge
extends BioPAXEdge {
    protected SIFEdge.EdgeType type;
    protected Set<String> mediators;
    protected Map<GraphObject, BasicSIFEdge> substitutionMap;
    protected String key;

    public BasicSIFEdge(NodeModel source, NodeModel target, String tag, String mediators) {
        super(source, target);
        this.type = SIFEdge.typeMap.get(tag);
        this.setTooltipText(tag);
        this.setColor(this.type.getColor());
        if (this.type.isDirected()) {
            this.setArrow("Target");
        }
        if (!this.type.isSolid()) {
            this.setStyle("Dashed");
        }
        this.mediators = new HashSet<String>();
        if (mediators != null) {
            Collections.addAll(this.mediators, mediators.split(" |;"));
        }
        this.setKey(source.getText() + " " + tag + " " + target.getText());
    }

    public BasicSIFEdge(BioPAXEdge excised, Map<NodeModel, NodeModel> map) {
        super(excised, map);
        this.type = ((BasicSIFEdge)excised).type;
        this.mediators = ((BasicSIFEdge)excised).mediators;
    }

    @Override
    public int getSign() {
        return 0;
    }

    @Override
    public boolean isDirected() {
        return this.type.isDirected();
    }

    @Override
    public boolean isBreadthEdge() {
        return true;
    }

    @Override
    public String getIDHash() {
        return "";
    }

    public SIFType getType() {
        return this.type.getIntType();
    }

    public String getTag() {
        return this.type.getTag();
    }

    public Set<String> getMediators() {
        return this.mediators;
    }

    public Set<String> getMediators(Set<GraphObject> nodes) {
        if (this.substitutionMap == null) {
            return this.mediators;
        }
        if (nodes.isEmpty()) {
            return this.mediators;
        }
        HashSet<String> meds = new HashSet<String>();
        for (GraphObject node : nodes) {
            if (!this.substitutionMap.containsKey(node)) continue;
            meds.addAll(this.substitutionMap.get(node).getMediators(nodes));
        }
        if (!meds.isEmpty()) {
            return meds;
        }
        return this.mediators;
    }

    public void addSubstitution(BasicSIFEdge edge, NodeModel node) {
        if (this.substitutionMap == null) {
            this.substitutionMap = new HashMap<GraphObject, BasicSIFEdge>();
        }
        this.substitutionMap.put(node, edge);
        this.mediators.addAll(edge.getMediators());
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Set<BasicSIFEdge> getLeaf() {
        HashSet<BasicSIFEdge> leaf = new HashSet<BasicSIFEdge>();
        if (this.substitutionMap == null) {
            leaf.add(this);
        } else {
            for (BasicSIFEdge child : this.substitutionMap.values()) {
                leaf.addAll(child.getLeaf());
            }
        }
        return leaf;
    }

    @Override
    public List<String[]> getInspectable() {
        List<String[]> list = super.getInspectable();
        list.add(new String[]{"Type", this.type.getTag()});
        if (this.getTooltipText() != null) {
            list.add(new String[]{"Tooltip", this.getTooltipText()});
        }
        return list;
    }
}

