/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.basicsif;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.cbio.causality.analysis.Graph;
import org.cbio.causality.analysis.GraphList;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.gvt.model.CompoundModel;
import org.gvt.model.GraphObject;
import org.gvt.model.NodeModel;
import org.gvt.model.basicsif.BasicSIFEdge;
import org.gvt.model.basicsif.BasicSIFGroup;
import org.gvt.model.basicsif.BasicSIFNode;
import org.gvt.model.biopaxl3.BioPAXEdge;
import org.gvt.model.biopaxl3.BioPAXL3Graph;
import org.gvt.model.biopaxl3.BioPAXNode;
import org.gvt.util.ChEBI;
import org.gvt.util.Conf;

public class BasicSIFGraph
extends BioPAXL3Graph {
    public BasicSIFGraph() {
        super((Model)null);
        this.setGraphType("BASIC_SIF");
    }

    public BasicSIFGraph(Graph graph) {
        this();
        HashMap<String, BasicSIFNode> nodeMap = new HashMap<String, BasicSIFNode>();
        if (graph instanceof GraphList) {
            for (Graph g : ((GraphList)graph).getGraphs()) {
                this.loadFromGraph(g, nodeMap);
            }
        } else {
            this.loadFromGraph(graph, nodeMap);
        }
    }

    public BasicSIFGraph(InputStream is, int mediatorColNum) {
        this();
        HashMap<String, BasicSIFNode> nodeMap = new HashMap<String, BasicSIFNode>();
        HashSet<String> memory = new HashSet<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String line = reader.readLine();
            while (line != null) {
                String[] token = line.split("\t");
                if (token.length == 1) {
                    if (!nodeMap.containsKey(token[0])) {
                        nodeMap.put(token[0], new BasicSIFNode(this, token[0], token[0]));
                    }
                } else if (token.length >= 3) {
                    SIFEnum type;
                    if (Conf.getBoolean("CONVERT_INTERACTS_WITH_TO_IN_COMPLEX_WITH") && token[1].equals("interacts-with")) {
                        token[1] = "in-complex-with";
                    }
                    if ((type = SIFEnum.typeOf(token[1])) != null) {
                        if (!nodeMap.containsKey(token[0])) {
                            nodeMap.put(token[0], new BasicSIFNode(this, token[0], token[0]));
                        }
                        if (!nodeMap.containsKey(token[2])) {
                            nodeMap.put(token[2], new BasicSIFNode(this, token[2], token[2]));
                        }
                        String key = token[0] + token[1] + token[2];
                        String rev = token[2] + token[1] + token[0];
                        if (!(memory.contains(key) || !type.isDirected() && memory.contains(rev))) {
                            new BasicSIFEdge((NodeModel)nodeMap.get(token[0]), (NodeModel)nodeMap.get(token[2]), type.getTag(), token.length > mediatorColNum ? token[mediatorColNum] : null);
                            memory.add(key);
                        }
                    }
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            System.err.println("Cannot read the input stream!");
            e.printStackTrace();
        }
        if (Conf.getBoolean("USE_SIF_GROUPING")) {
            this.groupSimilarNodes();
        }
    }

    private void loadFromGraph(Graph graph, Map<String, BasicSIFNode> nodeMap) {
        boolean directed = graph.isDirected();
        HashSet<String> memory = new HashSet<String>();
        for (String gene : graph.getSymbols()) {
            if (!nodeMap.containsKey(gene)) {
                nodeMap.put(gene, new BasicSIFNode(this, gene, gene));
            }
            for (String neigh : directed ? graph.getDownstream(gene) : graph.getNeighbors(gene)) {
                if (!nodeMap.containsKey(neigh)) {
                    nodeMap.put(neigh, new BasicSIFNode(this, neigh, neigh));
                }
                String key = gene + "\t" + neigh;
                String rev = neigh + "\t" + gene;
                if (memory.contains(key) || !directed && memory.contains(rev)) continue;
                new BasicSIFEdge(nodeMap.get(gene), nodeMap.get(neigh), graph.getEdgeType(), graph.getMediatorsInString(gene, neigh));
                memory.add(key);
            }
        }
        if (Conf.getBoolean("USE_SIF_GROUPING")) {
            this.groupSimilarNodes();
        }
    }

    public void replaceChEBIIDsWithNames() {
        for (Object o : this.getNodes()) {
            BasicSIFNode node;
            String name;
            if (!(o instanceof BasicSIFNode) || (name = ChEBI.getName((node = (BasicSIFNode)o).getText())) == null) continue;
            node.setText(name);
        }
    }

    public void writeLayout(OutputStream os) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
        for (Object o : this.getNodes()) {
            if (!(o instanceof BasicSIFNode)) continue;
            BasicSIFNode node = (BasicSIFNode)o;
            Point p = node.getLocationAbs();
            writer.write(node.getText() + "\t" + p.x + "\t" + p.y + "\n");
        }
        writer.close();
    }

    public void loadLayout(Map<String, Point> locMap) {
        for (Object o : this.getNodes()) {
            BasicSIFNode node;
            Point p;
            if (!(o instanceof BasicSIFNode) || (p = locMap.get((node = (BasicSIFNode)o).getText())) == null) continue;
            node.setLocationAbs(p);
        }
        for (Object o : this.getNodes()) {
            if (!(o instanceof CompoundModel)) continue;
            ((CompoundModel)o).calculateSizeUp();
        }
    }

    public void write(OutputStream os) {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
            for (Object o : this.getEdges()) {
                BasicSIFEdge edge = (BasicSIFEdge)o;
                for (BasicSIFNode basicSIFNode : this.getNonGroupNodes(edge.getSource())) {
                    for (BasicSIFNode target : this.getNonGroupNodes(edge.getTarget())) {
                        writer.write(basicSIFNode.getText() + "\t");
                        writer.write(edge.getTag() + "\t");
                        writer.write(target.getText());
                        Set<String> mediators = edge.getMediators(new HashSet<GraphObject>(Arrays.asList(basicSIFNode, target)));
                        writer.write(mediators.isEmpty() ? "\n" : "\t");
                        String s = "";
                        for (String mediator : mediators) {
                            s = s + mediator + ";";
                        }
                        if (!mediators.isEmpty()) {
                            s = s.substring(0, s.length() - 1);
                        }
                        writer.write(s + "\n");
                    }
                }
            }
            for (Object o : this.getChildren()) {
                String text;
                if (!(o instanceof BasicSIFGroup) || (text = ((BasicSIFGroup)o).getText()) == null || text.isEmpty()) continue;
                for (String string : text.split(",")) {
                    String string2 = string.trim();
                    SIFEnum sifType = SIFEnum.typeOf(string2);
                    if (sifType == null) continue;
                    BasicSIFNode[] members = this.getNonGroupNodes((BasicSIFGroup)o);
                    for (int i = 0; i < members.length; ++i) {
                        for (int j = 0; j < members.length; ++j) {
                            if (i == j || !sifType.isDirected() && members[i].getText().compareTo(members[i].getText()) >= 0) continue;
                            writer.write(members[i].getText() + "\t");
                            writer.write(string2 + "\t");
                            writer.write(members[j].getText() + "\n");
                        }
                    }
                }
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private BasicSIFNode[] getNonGroupNodes(NodeModel node) {
        if (node instanceof BasicSIFGroup) {
            return ((BasicSIFGroup)node).getChildren().toArray(new BasicSIFNode[((BasicSIFGroup)node).getChildren().size()]);
        }
        return new BasicSIFNode[]{(BasicSIFNode)node};
    }

    @Override
    public BioPAXL3Graph excise(Collection<org.patika.mada.graph.GraphObject> objects, boolean keepHighlights) {
        GraphObject orig;
        BasicSIFGraph graph = new BasicSIFGraph();
        HashMap<NodeModel, NodeModel> map = new HashMap<NodeModel, NodeModel>();
        for (org.patika.mada.graph.GraphObject object : objects) {
            if (!(object instanceof BasicSIFNode)) continue;
            orig = (BasicSIFNode)object;
            BasicSIFNode ex = new BasicSIFNode((BioPAXNode)orig, graph);
            map.put((NodeModel)orig, ex);
        }
        for (org.patika.mada.graph.GraphObject object : objects) {
            if (!(object instanceof BasicSIFEdge)) continue;
            orig = (BasicSIFEdge)object;
            new BasicSIFEdge((BioPAXEdge)orig, map);
        }
        if (Conf.getBoolean("USE_SIF_GROUPING")) {
            graph.groupSimilarNodes();
        }
        return graph;
    }

    public void groupSimilarNodes() {
        HashMap<NodeModel, Set<String>> incomingMap = new HashMap<NodeModel, Set<String>>();
        HashMap<NodeModel, Set<String>> outgoingMap = new HashMap<NodeModel, Set<String>>();
        for (Object e : this.getNodes()) {
            String key;
            BasicSIFEdge edge;
            NodeModel node = (NodeModel)e;
            if (!incomingMap.containsKey(node)) {
                incomingMap.put(node, new HashSet());
            }
            if (!outgoingMap.containsKey(node)) {
                outgoingMap.put(node, new HashSet());
            }
            for (Object oo : node.getTargetConnections()) {
                edge = (BasicSIFEdge)oo;
                assert (edge.getTarget() == node);
                key = edge.getTag() + " " + edge.getSource().getText();
                ((Set)incomingMap.get(node)).add(key);
                if (edge.isDirected()) continue;
                ((Set)outgoingMap.get(node)).add(key);
            }
            for (Object oo : node.getSourceConnections()) {
                edge = (BasicSIFEdge)oo;
                assert (edge.getSource() == node);
                key = edge.getTag() + " " + edge.getTarget().getText();
                ((Set)outgoingMap.get(node)).add(key);
                if (edge.isDirected()) continue;
                ((Set)incomingMap.get(node)).add(key);
            }
        }
        for (Set set : this.findGroups(this.getNodes(), incomingMap, outgoingMap)) {
            HashSet<BasicSIFNode> members = new HashSet<BasicSIFNode>();
            for (NodeModel m : set) {
                members.add((BasicSIFNode)m);
            }
            new BasicSIFGroup(this, members);
        }
        for (Object object : this.getEdges()) {
            BasicSIFEdge edge = (BasicSIFEdge)object;
            if (edge.substitutionMap == null || edge.substitutionMap.isEmpty()) continue;
            BasicSIFEdge hidden = edge.substitutionMap.values().iterator().next();
            while (hidden.substitutionMap != null && !hidden.substitutionMap.isEmpty()) {
                hidden = hidden.substitutionMap.values().iterator().next();
            }
            edge.setColor(hidden.getColor());
            edge.setHighlight(hidden.isHighlight());
            edge.setWidth(hidden.getWidth());
            String tooltip = "";
            for (BasicSIFEdge leaf : edge.getLeaf()) {
                if (leaf.getText() == null || leaf.getText().isEmpty()) continue;
                tooltip = tooltip + leaf.getTooltipText() + "\n";
            }
            if (tooltip.isEmpty()) continue;
            edge.setTooltipText(tooltip.trim());
            edge.setText("o");
        }
    }

    private Set<Set<NodeModel>> findGroups(Collection<NodeModel> nodes, Map<NodeModel, Set<String>> incomingMap, Map<NodeModel, Set<String>> outgoingMap) {
        HashSet<Set<NodeModel>> groups = new HashSet<Set<NodeModel>>();
        for (NodeModel node : nodes) {
            Set<NodeModel> group = this.getSimilarNodes(node, nodes, incomingMap, outgoingMap);
            if (group.isEmpty() || this.betterToSkipGrouping(group, incomingMap, outgoingMap) || this.contains(groups, group)) continue;
            groups.add(group);
        }
        return groups;
    }

    private boolean betterToSkipGrouping(Set<NodeModel> group, Map<NodeModel, Set<String>> incomingMap, Map<NodeModel, Set<String>> outgoingMap) {
        if (group.size() > 3) {
            return false;
        }
        HashSet<String> names = new HashSet<String>();
        for (NodeModel node : group) {
            names.add(node.getText());
        }
        NodeModel node = group.iterator().next();
        HashSet<String> conn = new HashSet<String>();
        for (String s : incomingMap.get(node)) {
            conn.add(s.substring(s.indexOf(" ") + 1));
        }
        for (String s : outgoingMap.get(node)) {
            conn.add(s.substring(s.indexOf(" ") + 1));
        }
        conn.removeAll(names);
        return conn.isEmpty();
    }

    private boolean contains(Set<Set<NodeModel>> groups, Set<NodeModel> group) {
        for (Set<NodeModel> g : groups) {
            if (g.size() != group.size() || !g.containsAll(group)) continue;
            return true;
        }
        return false;
    }

    private Set<NodeModel> getSimilarNodes(NodeModel node, Collection<NodeModel> nodes, Map<NodeModel, Set<String>> incomingMap, Map<NodeModel, Set<String>> outgoingMap) {
        HashSet<NodeModel> sim = new HashSet<NodeModel>();
        for (NodeModel n : nodes) {
            if (!this.similar(n, node, incomingMap, outgoingMap)) continue;
            sim.add(n);
        }
        if (sim.size() > 1) {
            return sim;
        }
        return Collections.emptySet();
    }

    private boolean similar(NodeModel n1, NodeModel n2, Map<NodeModel, Set<String>> incomingMap, Map<NodeModel, Set<String>> outgoingMap) {
        if (incomingMap.get(n1).size() != incomingMap.get(n2).size() || outgoingMap.get(n1).size() != outgoingMap.get(n2).size()) {
            return false;
        }
        if (incomingMap.get(n1).containsAll((Collection)incomingMap.get(n2)) && outgoingMap.get(n1).containsAll((Collection)outgoingMap.get(n2))) {
            return true;
        }
        HashSet<String> n1_in = new HashSet<String>((Collection)incomingMap.get(n1));
        HashSet<String> n2_in = new HashSet<String>((Collection)incomingMap.get(n2));
        HashSet<String> n1_out = new HashSet<String>((Collection)outgoingMap.get(n1));
        HashSet<String> n2_out = new HashSet<String>((Collection)outgoingMap.get(n2));
        this.removeCommon(n1_in, n2_in);
        this.removeCommon(n1_out, n2_out);
        return this.containssOnlyInterEdges(n1.getText(), n2.getText(), this.getParsed(n1_in), this.getParsed(n2_in)) && this.containssOnlyInterEdges(n1.getText(), n2.getText(), this.getParsed(n1_out), this.getParsed(n2_out));
    }

    private void removeCommon(Set<String> set1, Set<String> set2) {
        HashSet<String> temp = new HashSet<String>(set1);
        set1.removeAll(set2);
        set2.removeAll(temp);
    }

    private boolean containssOnlyInterEdges(String name1, String name2, Map<String, Set<String>> edges1, Map<String, Set<String>> edges2) {
        for (String type : edges1.keySet()) {
            if (!edges2.containsKey(type)) {
                return false;
            }
            assert (!edges1.get(type).isEmpty());
            if (edges1.get(type).size() == 1 && edges1.get(type).iterator().next().equals(name2)) continue;
            return false;
        }
        for (String type : edges2.keySet()) {
            if (!edges1.containsKey(type)) {
                return false;
            }
            assert (!edges2.get(type).isEmpty());
            if (edges2.get(type).size() == 1 && edges2.get(type).iterator().next().equals(name1)) continue;
            return false;
        }
        return true;
    }

    private Map<String, Set<String>> getParsed(Set<String> edges) {
        HashMap<String, Set<String>> parsed = new HashMap<String, Set<String>>();
        for (String edge : edges) {
            String[] tok = edge.split(" ");
            if (!parsed.containsKey(tok[0])) {
                parsed.put(tok[0], new HashSet());
            }
            ((Set)parsed.get(tok[0])).add(tok[1]);
        }
        return parsed;
    }

    public void format(List<String> lines) {
        Map<String, BasicSIFEdge> edgeMap = this.getEdgeMap();
        Map<String, BasicSIFNode> nodeMap = this.getNodeMap();
        for (BasicSIFNode node : nodeMap.values()) {
            if (!node.getShape().startsWith("RPPA")) continue;
            node.setShape("RoundRect");
        }
        HashSet<BasicSIFNode> nodesWthInfo = new HashSet<BasicSIFNode>();
        for (String line : lines) {
            String[] token = line.split("\t");
            if (token.length < 2) continue;
            if (token[0].equals("node")) {
                for (BasicSIFNode node : this.findNodes(token[1], nodeMap)) {
                    if (token[2].equals("color")) {
                        node.setColor(this.stringToColor(token[3]));
                        continue;
                    }
                    if (token[2].equals("bordercolor")) {
                        node.setBorderColor(this.stringToColor(token[3]));
                        continue;
                    }
                    if (token[2].equals("borderwidth")) {
                        node.setBorderWidth(Integer.parseInt(token[3]));
                        continue;
                    }
                    if (token[2].equals("highlight")) {
                        node.setHighlight(token[3].equals("on"));
                        continue;
                    }
                    if (token[2].equals("highlightcolor")) {
                        node.setHighlightColor(this.stringToColor(token[3]));
                        continue;
                    }
                    if (token[2].equals("textcolor")) {
                        node.setTextColor(this.stringToColor(token[3]));
                        continue;
                    }
                    if (token[2].equals("tooltip")) {
                        node.setTooltipText(token[3].replaceAll("\\\\n", "\n"));
                        continue;
                    }
                    if (token[2].equals("shape")) {
                        node.setShape(token[3]);
                        continue;
                    }
                    if (!token[2].equals("rppasite")) continue;
                    if (!node.getShape().startsWith("RPPA")) {
                        Dimension size = node.getSize();
                        size.height = 32;
                        node.setSize(size);
                    }
                    String s = !node.getShape().startsWith("RPPA") ? "RPPA" : node.getShape();
                    node.setShape(s + ";" + token[3]);
                    nodesWthInfo.add(node);
                }
                continue;
            }
            if (!token[0].equals("edge")) continue;
            for (BasicSIFEdge edge : this.findEdges(token[1], edgeMap)) {
                if (token[2].equals("color")) {
                    edge.setColor(this.stringToColor(token[3]));
                    continue;
                }
                if (token[2].equals("width")) {
                    edge.setWidth(Integer.parseInt(token[3]));
                    continue;
                }
                if (token[2].equals("highlight")) {
                    edge.setHighlight(token[3].equals("on"));
                    continue;
                }
                if (!token[2].equals("highlightcolor")) continue;
                edge.setHighlightColor(this.stringToColor(token[3]));
            }
        }
        for (BasicSIFNode node : nodeMap.values()) {
            if (nodesWthInfo.contains(node)) continue;
            Dimension size = node.getSize();
            size.height = 20;
            node.setSize(size);
        }
    }

    public List<String> getCurrentFormat() {
        ArrayList<String> lines = new ArrayList<String>();
        Map<String, BasicSIFEdge> edgeMap = this.getEdgeMap();
        Map<String, BasicSIFNode> nodeMap = this.getNodeMap();
        for (BasicSIFNode node : nodeMap.values()) {
            String pre = "node\t" + node.getText() + "\t";
            lines.add(pre + "color\t" + this.colorToString(node.getColor()));
            lines.add(pre + "bordercolor\t" + this.colorToString(node.getBorderColor()));
            lines.add(pre + "borderwidth\t" + node.getBorderWidth());
            lines.add(pre + "highlight\t" + node.isHighlight());
            if (node.getHighlightColor() != null) {
                lines.add(pre + "highlightcolor\t" + this.colorToString(node.getHighlightColor()));
            }
            lines.add(pre + "textcolor\t" + this.colorToString(node.getTextColor()));
            if (node.getTooltipText() == null) continue;
            lines.add(pre + "tooltip\t" + node.getTooltipText());
        }
        HashSet<BasicSIFEdge> mem = new HashSet<BasicSIFEdge>();
        for (String key : edgeMap.keySet()) {
            BasicSIFEdge edge = edgeMap.get(key);
            if (mem.contains(edge)) continue;
            mem.add(edge);
            String pre = "edge\t" + key + "\t";
            lines.add(pre + "color\t" + this.colorToString(edge.getColor()));
            lines.add(pre + "width\t" + edge.getWidth());
            lines.add(pre + "highlight\t" + edge.isHighlight());
            if (edge.getHighlightColor() == null) continue;
            lines.add(pre + "highlightcolor\t" + this.colorToString(edge.getHighlightColor()));
        }
        return lines;
    }

    private Map<String, BasicSIFEdge> getEdgeMap() {
        HashMap<String, BasicSIFEdge> map = new HashMap<String, BasicSIFEdge>();
        for (Object o : this.getEdges()) {
            if (!(o instanceof BasicSIFEdge)) continue;
            BasicSIFEdge edge = (BasicSIFEdge)o;
            for (String key : this.getSubstitutionKeys(edge, null)) {
                map.put(key, edge);
            }
        }
        return map;
    }

    private Set<String> getSubstitutionKeys(BasicSIFEdge edge, Set<String> keys) {
        if (keys == null) {
            keys = new HashSet<String>();
        }
        if (edge.substitutionMap == null) {
            keys.add(edge.getKey());
        } else {
            for (BasicSIFEdge e : edge.substitutionMap.values()) {
                this.getSubstitutionKeys(e, keys);
            }
        }
        return keys;
    }

    private Color stringToColor(String s) {
        String[] c = s.split(" ");
        try {
            return new Color(null, Integer.parseInt(c[0]), Integer.parseInt(c[1]), Integer.parseInt(c[2]));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Color(null, 0, 0, 0);
        }
    }

    private String colorToString(Color c) {
        return c.getRed() + " " + c.getGreen() + " " + c.getBlue();
    }

    private Map<String, BasicSIFNode> getNodeMap() {
        HashMap<String, BasicSIFNode> map = new HashMap<String, BasicSIFNode>();
        for (Object o : this.getNodes()) {
            if (!(o instanceof BasicSIFNode)) continue;
            BasicSIFNode node = (BasicSIFNode)o;
            map.put(node.getText(), node);
        }
        return map;
    }

    private Collection<BasicSIFNode> findNodes(String s, Map<String, BasicSIFNode> nodeMap) {
        if (s.equals("all-nodes")) {
            return nodeMap.values();
        }
        HashSet<BasicSIFNode> set = new HashSet<BasicSIFNode>();
        for (String name : s.split(";")) {
            if (!nodeMap.containsKey(name)) continue;
            set.add(nodeMap.get(name));
        }
        return set;
    }

    private Collection<BasicSIFEdge> findEdges(String s, Map<String, BasicSIFEdge> edgeMap) {
        if (s.equals("all-edges")) {
            return edgeMap.values();
        }
        HashSet<BasicSIFEdge> set = new HashSet<BasicSIFEdge>();
        for (String name : s.split(";")) {
            if (!edgeMap.containsKey(name)) continue;
            set.add(edgeMap.get(name));
        }
        return set;
    }
}

