/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.Level2Element;
import org.biopax.paxtools.model.level2.openControlledVocabulary;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.biopax.paxtools.model.level2.sequenceFeature;
import org.biopax.paxtools.model.level2.sequenceInterval;
import org.biopax.paxtools.model.level2.sequenceLocation;
import org.biopax.paxtools.model.level2.sequenceParticipant;
import org.biopax.paxtools.model.level2.sequenceSite;
import org.biopax.paxtools.model.level2.smallMolecule;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.gvt.model.CompoundModel;
import org.gvt.model.EntityAssociated;
import org.gvt.model.biopaxl2.BioPAXNode;
import org.gvt.model.biopaxl2.EffectorFirstHalf;
import org.gvt.model.biopaxl2.NonModulatedEffector;
import org.gvt.util.EntityHolder;
import org.gvt.util.ID;
import org.patika.mada.graph.Edge;
import org.patika.mada.graph.Node;

public class Actor
extends BioPAXNode
implements EntityAssociated {
    protected physicalEntity entity;
    protected List<physicalEntityParticipant> participants;
    public static final int DEFAULT_HEIGHT = 20;
    public static final int DEFAULT_UBIQUE_HEIGHT = 15;
    public static final int DEFAULT_INFO_BULB = 6;
    public static final int MIN_INITIAL_WIDTH = 40;
    public static final Color SMALL_MOL_BG_COLOR = new Color(null, 255, 255, 255);

    public Actor(CompoundModel root) {
        super(root);
        this.setColor(new Color(null, 150, 150, 150));
        this.setText("Actor");
        this.setSize(new Dimension(50, 20));
        this.setShape("RoundRect");
    }

    public Actor(CompoundModel root, physicalEntity entity2, List<physicalEntityParticipant> participants) {
        this(root);
        this.entity = entity2;
        this.participants = participants;
        this.sortParticipants();
        this.configFromModel();
    }

    public Actor(Actor excised, CompoundModel root) {
        super(excised, root);
        this.entity = excised.getEntity().l2pe;
        this.participants = excised.getParticipants();
        this.sortParticipants();
        this.getReferences().clear();
        this.configFromModel();
    }

    protected void sortParticipants() {
        Collections.sort(this.participants, new Comparator<physicalEntityParticipant>(){

            @Override
            public int compare(physicalEntityParticipant p1, physicalEntityParticipant p2) {
                return ID.get(p1).compareTo(ID.get(p2));
            }
        });
    }

    @Override
    public void configFromModel() {
        int width;
        int height;
        String names = this.extractReferences(this.entity);
        String name = Actor.getDisplayName(this.entity);
        if (name == null) {
            name = "noname";
        }
        this.setText(name);
        this.setTooltipText(names);
        List<String> infos = this.getInfoStrings();
        if (this.isUbique()) {
            height = infos.isEmpty() ? 15 : 27;
            FontData data = this.getTextFont().getFontData()[0];
            data.setHeight(6);
            this.setTextFont(new Font(null, data));
            if (this.getName().startsWith("Phosphate") || this.getName().startsWith("phosphate") || this.getName().startsWith("Orthophosphate") || this.getName().startsWith("orthophosphate") || this.getName().startsWith("PPi") || this.getName().equals("Pi")) {
                this.setText("P");
            } else if (this.getName().startsWith("NTP [")) {
                this.setText("NTP");
            }
            width = Math.max(this.suggestInitialWidth(), 15);
        } else {
            width = this.suggestInitialWidth();
            if (!(this.entity instanceof smallMolecule) && width < 40) {
                width = 40;
            }
            height = infos.isEmpty() ? 20 : 32;
        }
        this.setSize(new Dimension(width, height));
        if (this.entity instanceof smallMolecule) {
            this.setColor(SMALL_MOL_BG_COLOR);
        } else {
            this.setColor(this.getStringSpecificColor(this.getText()));
        }
        String shp = "RoundRect";
        if (!infos.isEmpty()) {
            shp = shp + "WithInfo";
            for (String info : infos) {
                shp = shp + ";" + info;
            }
        }
        this.setShape(shp);
    }

    @Override
    public EntityHolder getEntity() {
        return new EntityHolder(this.entity);
    }

    public List<physicalEntityParticipant> getParticipants() {
        return this.participants;
    }

    @Override
    public Collection<? extends Level2Element> getRelatedModelElements() {
        return this.participants;
    }

    public static String getShortestNameInParanthesis(String longName) {
        int i;
        int mark = 0;
        String shortName = longName;
        while ((i = longName.indexOf("(", mark)) > 0 && longName.indexOf(")", i) > i) {
            String s = longName.substring(longName.indexOf("(", mark) + 1, longName.indexOf(")", i));
            mark = longName.indexOf(")", i);
            if (s.length() >= shortName.length()) continue;
            shortName = s;
        }
        return shortName;
    }

    public List<String> getInfoStrings() {
        sequenceParticipant seq;
        Set<sequenceFeature> set;
        physicalEntityParticipant par;
        ArrayList<String> list = new ArrayList<String>();
        if (!this.participants.isEmpty() && (par = this.participants.get(0)) instanceof sequenceParticipant && (set = (seq = (sequenceParticipant)par).getSEQUENCE_FEATURE_LIST()) != null) {
            for (sequenceFeature feat : set) {
                Set<sequenceLocation> locSet;
                String featStr = feat.getSHORT_NAME();
                if (featStr == null || featStr.length() == 0) {
                    openControlledVocabulary ocv = feat.getFEATURE_TYPE();
                    if (ocv == null) {
                        System.err.println("Has sequence feature with no feature short name or feature type: " + this);
                    } else if (ocv.getTERM() == null || ocv.getTERM().isEmpty()) {
                        System.err.println("Encountered an OCV without any term: " + this);
                    } else {
                        featStr = ocv.getTERM().iterator().next();
                    }
                }
                if ((locSet = feat.getFEATURE_LOCATION()) == null) {
                    System.err.println("sequence feature has a null feature location: " + this);
                    continue;
                }
                for (sequenceLocation loc : locSet) {
                    sequenceInterval interval;
                    if (loc instanceof sequenceSite) {
                        featStr = featStr + " @" + ((sequenceSite)loc).getSEQUENCE_POSITION();
                        continue;
                    }
                    if (!(loc instanceof sequenceInterval) || (interval = (sequenceInterval)loc).getSEQUENCE_INTERVAL_BEGIN() == null || interval.getSEQUENCE_INTERVAL_END() == null) continue;
                    featStr = featStr + " [" + interval.getSEQUENCE_INTERVAL_BEGIN().getSEQUENCE_POSITION() + "-" + interval.getSEQUENCE_INTERVAL_END().getSEQUENCE_POSITION() + "]";
                }
                list.add(featStr);
            }
        }
        return list;
    }

    public boolean hasInfoString() {
        sequenceParticipant seq;
        Set<sequenceFeature> set;
        physicalEntityParticipant par;
        return !this.participants.isEmpty() && (par = this.participants.get(0)) instanceof sequenceParticipant && (set = (seq = (sequenceParticipant)par).getSEQUENCE_FEATURE_LIST()) != null && !set.isEmpty();
    }

    public Color getEntitySpecificColor() {
        if (this.entity == null) {
            return null;
        }
        return super.getStringSpecificColor(ID.get(this.entity));
    }

    @Override
    public boolean isEvent() {
        return false;
    }

    @Override
    public boolean sameEntity(Node n) {
        return n instanceof Actor && this.entity.equals(((Actor)n).getEntity());
    }

    @Override
    public boolean isBreadthNode() {
        return true;
    }

    @Override
    public String getIDHash() {
        return ID.get(this.entity) + this.edgeHash();
    }

    public String edgeHash() {
        if (this.participants.isEmpty()) {
            return "";
        }
        String hash = null;
        for (physicalEntityParticipant p : this.participants) {
            if (hash != null && ID.get(p).compareTo(hash) >= 0) continue;
            hash = ID.get(p);
        }
        return hash;
    }

    public physicalEntityParticipant createNewPEP(Model model, String rdfid) {
        if (this.participants.isEmpty()) {
            physicalEntityParticipant pepNew = model.addNew(physicalEntityParticipant.class, rdfid);
            pepNew.setPHYSICAL_ENTITY(this.entity);
            return pepNew;
        }
        physicalEntityParticipant pep = this.participants.get(0);
        physicalEntityParticipant pepNew = (physicalEntityParticipant)model.addNew(pep.getModelInterface(), rdfid);
        pepNew.setCELLULAR_LOCATION(pep.getCELLULAR_LOCATION());
        if (pep instanceof sequenceParticipant) {
            for (sequenceFeature feat : ((sequenceParticipant)pep).getSEQUENCE_FEATURE_LIST()) {
                ((sequenceParticipant)pepNew).addSEQUENCE_FEATURE_LIST(feat);
            }
        }
        pepNew.setPHYSICAL_ENTITY(this.entity);
        return pepNew;
    }

    public boolean isUbique() {
        return this.entity instanceof smallMolecule && Actor.isUbiqueName(this.entity.getNAME());
    }

    public static boolean isUbiqueName(String name) {
        return name.startsWith("ATP") || name.startsWith("ADP") || name.startsWith("AMP") || name.startsWith("adenosine 5'-monophosphate") || name.startsWith("H2O") || name.startsWith("H+") || name.startsWith("Oxygen") || name.startsWith("O2") || name.startsWith("CO2") || name.startsWith("GDP") || name.startsWith("GTP") || name.startsWith("PPi") || name.equals("Pi") || name.startsWith("Phosphate") || name.startsWith("phosphate") || name.startsWith("Orthophosphate") || name.startsWith("orthophosphate") || name.startsWith("NTP");
    }

    private boolean isEffector() {
        for (Edge edge : this.getDownstream()) {
            if (!(edge instanceof EffectorFirstHalf) && !(edge instanceof NonModulatedEffector)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String[]> getInspectable() {
        physicalEntityParticipant pep;
        openControlledVocabulary loc;
        List<String[]> list = super.getInspectable();
        Actor.addNamesAndTypeAndID(list, this.entity);
        if (this.participants != null && !this.participants.isEmpty() && (loc = (pep = this.participants.get(0)).getCELLULAR_LOCATION()) != null) {
            list.add(new String[]{"Location", loc.toString()});
        }
        for (String info : this.getInfoStrings()) {
            String type = Character.isDigit(info.charAt(0)) ? "Stochiometry" : "Modification";
            list.add(new String[]{type, info});
        }
        Actor.addDataSourceAndXrefAndComments(list, this.entity);
        return list;
    }
}

