/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.level2.bioSource;
import org.biopax.paxtools.model.level2.dataSource;
import org.biopax.paxtools.model.level2.entity;
import org.biopax.paxtools.model.level2.openControlledVocabulary;
import org.biopax.paxtools.model.level2.sequenceEntity;
import org.biopax.paxtools.model.level2.smallMolecule;
import org.biopax.paxtools.model.level2.xref;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.gvt.command.CreateCommand;
import org.gvt.model.CompoundModel;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl2.BioPAXCompoundNode;
import org.gvt.model.biopaxl2.BioPAXL2Graph;
import org.gvt.model.biopaxl2.Compartment;
import org.gvt.model.biopaxl2.IBioPAXL2Node;
import org.gvt.model.biopaxl2.NodeUtil;
import org.gvt.util.ID;
import org.patika.mada.graph.Edge;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;
import org.patika.mada.util.ExperimentData;
import org.patika.mada.util.Representable;
import org.patika.mada.util.XRef;

public abstract class BioPAXNode
extends NodeModel
implements IBioPAXL2Node {
    private int id;
    private List<XRef> references;
    protected NodeUtil util;
    public static final String NAME_REF = "Name";
    public static final int PROPERTY_CHAR_LIMIT = 50;
    public static final int MAX_INITIAL_WIDTH = 100;

    public BioPAXNode(CompoundModel root) {
        CreateCommand command = new CreateCommand(root, this);
        command.execute();
        this.references = new ArrayList<XRef>();
        this.util = new NodeUtil(this);
    }

    public BioPAXNode(BioPAXNode excised, CompoundModel root) {
        this(root);
        this.id = excised.id;
        this.references.addAll(excised.getReferences());
        this.setShape(excised.getShape());
        this.setSize(excised.getSize());
        this.setColor(excised.getColor());
        this.setText(excised.getText());
        this.setTextColor(excised.getTextColor());
        this.setTooltipText(excised.getTooltipText());
        for (Object key : excised.getAllLabels()) {
            this.putLabel(key, excised.getLabel(key));
        }
        this.getGraph().putInExcisionMap(excised, this);
        this.putLabel("EXCISED_FROM", excised);
    }

    @Override
    public boolean isComplexMember() {
        return false;
    }

    @Override
    public void configFromModel() {
    }

    @Override
    public BioPAXL2Graph getGraph() {
        return this.util.getGraph();
    }

    public Compartment getCompartment() {
        return this.util.getCompartment();
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.getText();
    }

    public NodeUtil getUtil() {
        return this.util;
    }

    @Override
    public List<XRef> getReferences() {
        return this.references;
    }

    public void addReference(XRef ref) {
        if (!this.references.contains(ref)) {
            this.references.add(ref);
        }
    }

    @Override
    public List<XRef> getSecondaryReferences() {
        return Collections.emptyList();
    }

    protected String extractReferences(entity ent) {
        HashSet<String> nameSet = new HashSet<String>();
        if (ent.getSHORT_NAME() != null && ent.getSHORT_NAME().length() > 0) {
            this.addReference(new XRef(NAME_REF, ent.getSHORT_NAME()));
            if (ent.getSHORT_NAME() != null) {
                nameSet.add(ent.getSHORT_NAME());
            }
        }
        if (ent.getNAME() != null && ent.getNAME().length() > 0) {
            this.addReference(new XRef(NAME_REF, ent.getNAME()));
            nameSet.add(ent.getNAME());
        }
        for (String syn : ent.getSYNONYMS()) {
            if (syn == null) continue;
            XRef ref = new XRef(NAME_REF, syn);
            if (this.getReferences().contains(ref)) continue;
            this.addReference(ref);
            nameSet.add(syn);
        }
        for (xref xr : ent.getXREF()) {
            if (xr == null) continue;
            this.addReference(new XRef(xr));
        }
        String names = "";
        Iterator iter = nameSet.iterator();
        while (iter.hasNext()) {
            String nm = (String)iter.next();
            names = names + nm;
            if (!iter.hasNext()) continue;
            nm = nm + "\n";
        }
        return names;
    }

    protected int suggestInitialWidth() {
        Dimension dim = TextUtilities.INSTANCE.getStringExtents(this.getText(), this.getTextFont());
        int width = Math.min(dim.width + 4, 100);
        return width;
    }

    public String getShortestNameRef() {
        int shortest = Integer.MAX_VALUE;
        String name = null;
        for (XRef ref : this.references) {
            String value;
            if (!ref.getDb().equals(NAME_REF) || (value = ref.getRef()).length() >= shortest) continue;
            name = value;
            shortest = value.length();
        }
        return name;
    }

    public static String getDisplayName(entity ent) {
        String txt = BioPAXNode.extractGeneSymbol(ent);
        if (txt == null && !(ent instanceof smallMolecule)) {
            txt = ent.getSHORT_NAME();
        }
        if (txt == null) {
            txt = ent.getNAME();
            for (String syn : ent.getSYNONYMS()) {
                if (txt != null && syn.length() >= txt.length()) continue;
                txt = syn;
            }
            if (ent.getSHORT_NAME() != null && (txt == null || txt.length() > ent.getSHORT_NAME().length())) {
                txt = ent.getSHORT_NAME();
            }
        }
        return txt;
    }

    protected static String extractGeneSymbol(entity ent) {
        String sym = null;
        for (xref ref : ent.getXREF()) {
            String db = ref.getDB();
            if (db == null || !db.equalsIgnoreCase("GENE_SYMBOL") && !db.equalsIgnoreCase("HGNC SYMBOL") && !db.equalsIgnoreCase("GENESYMBOL") && !db.equalsIgnoreCase("GENE SYMBOL") && !db.equalsIgnoreCase("GENE-SYMBOL") && !db.equalsIgnoreCase("SYMBOL")) continue;
            sym = ref.getID();
            break;
        }
        return sym;
    }

    @Override
    public boolean fetchLocation(String pathwayRDFID) {
        return this.util.fetchLocation(pathwayRDFID);
    }

    @Override
    public void recordLocation() {
        this.util.recordLocation();
    }

    @Override
    public void eraseLocation() {
        this.util.eraseLocation();
    }

    @Override
    public String getIDHash() {
        return this.util.getIDHash();
    }

    @Override
    public boolean hasModelTag(String tag) {
        return this.util.hasModelTag(tag);
    }

    @Override
    public String fetchModelTag(String tag) {
        return this.util.fetchModelTag(tag);
    }

    @Override
    public Representable getRepresentableData(Object key) {
        return (Representable)this.getLabel(key);
    }

    @Override
    public ExperimentData getExperimentData(String type) {
        return (ExperimentData)this.getLabel(type);
    }

    @Override
    public void setExperimentData(ExperimentData data) {
        this.putLabel(data.getKey(), data);
    }

    @Override
    public boolean hasExperimentData(Object key) {
        return this.hasLabel(key);
    }

    @Override
    public boolean hasSignificantExperimentalChange(String type) {
        return this.hasExperimentData(type) && this.getExperimentData(type).isSignificant();
    }

    @Override
    public int getExperimentDataSign(String type) {
        return this.getExperimentData(type).getSign();
    }

    @Override
    public Collection<? extends Node> getParents() {
        CompoundModel p = this.getParentModel();
        ArrayList<BioPAXCompoundNode> col = new ArrayList<BioPAXCompoundNode>(1);
        if (p == null || p.isRoot()) {
            return col;
        }
        col.add((BioPAXCompoundNode)p);
        return col;
    }

    @Override
    public Collection<? extends Edge> getUpstream() {
        return this.getTargetConnections();
    }

    @Override
    public Collection<? extends Edge> getDownstream() {
        return this.getSourceConnections();
    }

    @Override
    public Collection<? extends Node> getChildren() {
        return new ArrayList(0);
    }

    @Override
    public boolean sameEntity(Node n) {
        return n.equals(this);
    }

    @Override
    public boolean isBreadthNode() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isHighlighted() {
        return this.isHighlight();
    }

    @Override
    public boolean isTranscriptionEvent() {
        return false;
    }

    @Override
    public Set<Node> getTabuNodes() {
        return Collections.emptySet();
    }

    @Override
    public Set<GraphObject> getRequisites() {
        HashSet<GraphObject> reqs = new HashSet<GraphObject>();
        if (this.getParentModel() instanceof Compartment) {
            reqs.add((GraphObject)((Object)this.getParentModel()));
        }
        return reqs;
    }

    @Override
    public List<String[]> getInspectable() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        return list;
    }

    public Color getStringSpecificColor(String name) {
        int[] c;
        int id = Math.abs(name.hashCode());
        int number1 = Math.abs((name + name).hashCode() * 97) % 1000;
        int number2 = Math.abs((name + name).hashCode() * 59) % 1000;
        int t = 350;
        c = new int[]{number1 % Math.min(255, t), number2 % Math.min(255, t - c[0]), Math.min(254, t - c[0] - c[1])};
        int p = 255;
        int r = c[0] + id % (p - c[0]);
        int g = c[1] + id % p * 97 % (p - c[1]);
        int b = c[2] + id % p * 59 % (p - c[2]);
        return new Color(null, r, g, b);
    }

    public static String formatInString(Set<openControlledVocabulary> set) {
        String s = "";
        for (openControlledVocabulary voc : set) {
            if (s.length() > 0) {
                s = s + ", ";
            }
            s = s + voc;
        }
        return s;
    }

    public static String classNameToString(String clsName) {
        clsName = clsName.substring(clsName.lastIndexOf(".") + 1, clsName.lastIndexOf("I"));
        clsName = clsName.substring(0, 1).toUpperCase() + clsName.substring(1);
        for (int i = 3; i < clsName.length(); ++i) {
            if (!Character.isLowerCase(clsName.charAt(i - 1)) || !Character.isUpperCase(clsName.charAt(i))) continue;
            clsName = clsName.substring(0, i) + " " + clsName.substring(i);
        }
        return clsName;
    }

    public static void addNamesAndTypeAndID(List<String[]> list, entity ent) {
        String type = BioPAXNode.classNameToString(ent.getClass().getName());
        list.add(new String[]{"Type", type});
        String s = ent.getNAME();
        if (s != null && s.length() > 0) {
            list.add(new String[]{NAME_REF, s});
        }
        if ((s = ent.getSHORT_NAME()) != null && s.length() > 0) {
            list.add(new String[]{"Short Name", s});
        }
        for (String synon : ent.getSYNONYMS()) {
            list.add(new String[]{"Synonym", synon});
        }
        list.add(new String[]{"ID", ID.get(ent)});
    }

    public static void addDataSourceAndXrefAndComments(List<String[]> list, entity ent) {
        bioSource src;
        for (dataSource ds : ent.getDATA_SOURCE()) {
            if (ds.getNAME().isEmpty()) continue;
            list.add(new String[]{"Data Source", ds.toString()});
        }
        for (xref xr : ent.getXREF()) {
            list.add(new String[]{"Reference", xr.toString()});
        }
        if (ent instanceof sequenceEntity && (src = ((sequenceEntity)ent).getORGANISM()) != null) {
            list.add(new String[]{"Organism", src.toString()});
        }
        for (String comment : ent.getCOMMENT()) {
            if (comment.contains("@Layout")) continue;
            boolean first = true;
            while (comment.length() > 50) {
                int cutIndex = comment.lastIndexOf(" ", 50);
                if (cutIndex < 0) {
                    cutIndex = 50;
                }
                String c = comment.substring(0, cutIndex);
                comment = comment.substring(cutIndex).trim();
                String prop = first ? "Comment" : "";
                list.add(new String[]{prop, c});
                first = false;
            }
            if (comment.trim().length() <= 0) continue;
            String prop = first ? "Comment" : "";
            list.add(new String[]{prop, comment.trim()});
        }
    }
}

