/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl2;

import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.gvt.model.CompoundModel;
import org.gvt.model.biopaxl2.Actor;
import org.gvt.model.biopaxl2.Complex;
import org.gvt.util.ID;
import org.patika.mada.graph.GraphObject;

public class ComplexMember
extends Actor {
    public ComplexMember(CompoundModel root) {
        super(root);
        assert (root instanceof Complex);
    }

    public ComplexMember(Complex root, physicalEntity entity2, List<physicalEntityParticipant> participants) {
        super(root, entity2, participants);
    }

    public ComplexMember(ComplexMember excised, Complex root) {
        super(excised, (CompoundModel)root);
    }

    @Override
    public boolean isComplexMember() {
        return true;
    }

    public Complex getParentComplex() {
        return (Complex)this.getParentModel();
    }

    @Override
    public List<String> getInfoStrings() {
        List<String> infos = super.getInfoStrings();
        int st = this.extractStochiometry();
        if (st > 1) {
            infos.add("" + st);
        }
        return infos;
    }

    protected int extractStochiometry() {
        int i;
        double s = ((physicalEntityParticipant)this.participants.get(0)).getSTOICHIOMETRIC_COEFFICIENT();
        if (s != BioPAXElement.UNKNOWN_DOUBLE && (i = (int)Math.round(s)) > 1) {
            return i;
        }
        return 1;
    }

    @Override
    public boolean hasInfoString() {
        if (super.hasInfoString()) {
            return true;
        }
        return this.extractStochiometry() > 1;
    }

    @Override
    public String getIDHash() {
        String hash = "";
        for (physicalEntityParticipant pep : this.participants) {
            hash = hash + ID.get(pep);
        }
        return ID.get(this.entity) + hash;
    }

    @Override
    public Set<GraphObject> getRequisites() {
        Set<GraphObject> reqs = super.getRequisites();
        reqs.add((GraphObject)((Object)this.getParentModel()));
        return reqs;
    }
}

