/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl2;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.model.level2.ControlType;
import org.biopax.paxtools.model.level2.Level2Element;
import org.biopax.paxtools.model.level2.control;
import org.biopax.paxtools.model.level2.evidence;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.gvt.model.CompoundModel;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl2.BioPAXNode;
import org.gvt.model.biopaxl2.Conversion;
import org.gvt.model.biopaxl2.EffectorFirstHalf;
import org.gvt.model.biopaxl2.EffectorSecondHalf;
import org.gvt.model.biopaxl2.Hub;
import org.gvt.model.biopaxl2.NonModulatedEffector;
import org.gvt.util.ID;
import org.patika.mada.graph.GraphObject;

public class Control
extends BioPAXNode {
    control con;
    private static final Color COLOR_ACTIVATE = new Color(null, 170, 170, 170);
    private static final Color COLOR_INHIBIT = new Color(null, 170, 170, 170);
    public static final Color EDGE_COLOR_ACTIVATE = new Color(null, 50, 150, 50);
    public static final Color EDGE_COLOR_INHIBIT = new Color(null, 150, 50, 50);

    public Control(CompoundModel root) {
        super(root);
        this.setColor(COLOR_ACTIVATE);
        this.setText("");
        this.setSize(new Dimension(9, 9));
        this.setShape("Diamond");
    }

    public Control(CompoundModel root, control con, NodeModel target, Map<String, NodeModel> map) {
        this(root);
        assert (target instanceof Conversion || target instanceof Control || target instanceof Hub);
        map.put(ID.get(con), this);
        Set<physicalEntityParticipant> pars = con.getCONTROLLER();
        for (physicalEntityParticipant par : pars) {
            NodeModel node = map.get(ID.get(par));
            new EffectorFirstHalf(node, this, par);
        }
        new EffectorSecondHalf(this, target, con);
        for (control c : con.isCONTROLLEDOf()) {
            if (map.containsKey(ID.get(c))) {
                Control mod = (Control)map.get(ID.get(c));
                new EffectorSecondHalf(mod, this, mod.getControl());
                continue;
            }
            if (c.isCONTROLLEDOf().isEmpty() && c.getCONTROLLER().size() == 1) {
                NodeModel source = map.get(ID.get(c.getCONTROLLER().iterator().next()));
                new NonModulatedEffector(source, this, c, c.getCONTROLLER().iterator().next(), con);
                continue;
            }
            Control ctrl = new Control(root, c, this, map);
            map.put(ID.get(c), ctrl);
        }
        this.con = con;
        this.configFromModel();
    }

    @Override
    public void configFromModel() {
        super.configFromModel();
        this.setTooltipText(this.con.getNAME());
        this.setColor(Control.isActivation(this.con) ? COLOR_ACTIVATE : COLOR_INHIBIT);
    }

    public Control(Control excised, CompoundModel root) {
        super(excised, root);
        this.con = excised.getControl();
    }

    public control getControl() {
        return this.con;
    }

    public static boolean isActivation(control cont) {
        boolean isActivation = true;
        ControlType type = cont.getCONTROL_TYPE();
        if (type != null) {
            if (type == ControlType.ACTIVATION || type == ControlType.ACTIVATION_ALLOSTERIC || type == ControlType.ACTIVATION_NONALLOSTERIC || type == ControlType.ACTIVATION_UNKMECH) {
                isActivation = true;
            } else if (type == ControlType.INHIBITION || type == ControlType.INHIBITION_ALLOSTERIC || type == ControlType.INHIBITION_COMPETITIVE || type == ControlType.INHIBITION_IRREVERSIBLE || type == ControlType.INHIBITION_NONCOMPETITIVE || type == ControlType.INHIBITION_OTHER || type == ControlType.INHIBITION_UNCOMPETITIVE || type == ControlType.INHIBITION_UNKMECH) {
                isActivation = false;
            } else assert (false) : "Unknown control type: " + (Object)((Object)type);
        }
        return isActivation;
    }

    @Override
    public Collection<? extends Level2Element> getRelatedModelElements() {
        return Arrays.asList(this.con);
    }

    @Override
    public boolean isEvent() {
        return true;
    }

    @Override
    public Set<GraphObject> getRequisites() {
        Set<GraphObject> reqs = super.getRequisites();
        reqs.addAll(this.getSourceConnections());
        reqs.addAll(this.getTargetConnections());
        return reqs;
    }

    @Override
    public List<String[]> getInspectable() {
        List<String[]> list = super.getInspectable();
        Control.addNamesAndTypeAndID(list, this.con);
        for (evidence ev : this.con.getEVIDENCE()) {
            list.add(new String[]{"Evidence", ev.toString()});
        }
        if (!this.con.getINTERACTION_TYPE().isEmpty()) {
            String s = Control.formatInString(this.con.getINTERACTION_TYPE());
            list.add(new String[]{"Interaction Type", s});
        }
        if (this.con.getCONTROL_TYPE() != null) {
            list.add(new String[]{"Control Type", this.con.getCONTROL_TYPE().toString()});
        }
        Control.addDataSourceAndXrefAndComments(list, this.con);
        return list;
    }

    @Override
    public String getIDHash() {
        return ID.get(this.con);
    }
}

