/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.model.level2.Level2Element;
import org.biopax.paxtools.model.level2.SpontaneousType;
import org.biopax.paxtools.model.level2.control;
import org.biopax.paxtools.model.level2.conversion;
import org.biopax.paxtools.model.level2.evidence;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.gvt.model.CompoundModel;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl2.BioPAXNode;
import org.gvt.model.biopaxl2.Compartment;
import org.gvt.model.biopaxl2.ComplexMember;
import org.gvt.model.biopaxl2.Control;
import org.gvt.model.biopaxl2.EffectorSecondHalf;
import org.gvt.model.biopaxl2.NonModulatedEffector;
import org.gvt.model.biopaxl2.Product;
import org.gvt.model.biopaxl2.Substrate;
import org.gvt.util.ID;
import org.patika.mada.graph.Edge;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;
import org.patika.mada.util.Ranker;

public class Conversion
extends BioPAXNode {
    private conversion conv;
    private boolean direction;
    private boolean t;
    private Set<Node> tabu;
    private static final Color COLOR = new Color(null, 170, 170, 170);
    public static final boolean LEFT_TO_RIGHT = true;
    public static final boolean RIGHT_TO_LEFT = false;

    public Conversion(CompoundModel root) {
        super(root);
        this.setColor(COLOR);
        this.setText("");
        this.setSize(new Dimension(12, 12));
        this.setShape("Rectangle");
    }

    public Conversion(CompoundModel root, conversion conv, boolean direction, Map<String, NodeModel> map) {
        this(root);
        this.conv = conv;
        this.direction = direction;
        this.configFromModel();
        this.buildConnections(root, conv, direction, map);
    }

    public Conversion(Conversion excised, CompoundModel root) {
        super(excised, root);
        this.conv = excised.getConversion();
        this.direction = excised.getDirection();
        this.configFromModel();
    }

    @Override
    public void configFromModel() {
        this.extractReferences(this.conv);
        this.setTooltipText(this.conv.getNAME());
        if (this.util.hasModelTag("DEPLETING_REACTION")) {
            this.setText("d");
        }
        if (this.util.hasModelTag("TRANSCRIPTION_TAG")) {
            this.t = true;
        }
    }

    public boolean isT() {
        return this.t;
    }

    public conversion getConversion() {
        return this.conv;
    }

    public boolean getDirection() {
        return this.direction;
    }

    @Override
    public Collection<? extends Level2Element> getRelatedModelElements() {
        return Arrays.asList(this.conv);
    }

    private void buildConnections(CompoundModel root, conversion conv, boolean direction, Map<String, NodeModel> map) {
        Set<physicalEntityParticipant> subsSet = direction ? conv.getLEFT() : conv.getRIGHT();
        Set<physicalEntityParticipant> prodSet = !direction ? conv.getLEFT() : conv.getRIGHT();
        for (physicalEntityParticipant par : subsSet) {
            NodeModel sub = map.get(ID.get(par));
            new Substrate(sub, this, par);
        }
        for (physicalEntityParticipant par : prodSet) {
            NodeModel prod = map.get(ID.get(par));
            new Product(this, prod, par);
        }
        if (!this.t && subsSet.isEmpty() && prodSet.size() == 1) {
            this.t = true;
            this.util.recordModelTag("TRANSCRIPTION_TAG", "");
        }
        for (control con : conv.isCONTROLLEDOf()) {
            if (map.containsKey(ID.get(con))) {
                Control cont = (Control)map.get(ID.get(con));
                new EffectorSecondHalf(cont, this, cont.getControl());
                continue;
            }
            if (con.isCONTROLLEDOf().isEmpty() && con.getCONTROLLER().size() == 1) {
                NodeModel source = map.get(ID.get(con.getCONTROLLER().iterator().next()));
                new NonModulatedEffector(source, this, con, con.getCONTROLLER().iterator().next(), conv);
                continue;
            }
            Control ctrl = new Control(root, con, this, map);
            map.put(ID.get(con), ctrl);
        }
    }

    public static String getPossibleCompartmentName(conversion conv) {
        HashSet<String> names = new HashSet<String>();
        for (physicalEntityParticipant par : conv.getLEFT()) {
            if (par.getCELLULAR_LOCATION() == null || par.getCELLULAR_LOCATION().getTERM().isEmpty()) continue;
            names.add(par.getCELLULAR_LOCATION().getTERM().iterator().next());
        }
        for (physicalEntityParticipant par : conv.getRIGHT()) {
            if (par.getCELLULAR_LOCATION() == null || par.getCELLULAR_LOCATION().getTERM().isEmpty()) continue;
            names.add(par.getCELLULAR_LOCATION().getTERM().iterator().next());
        }
        if (names.size() == 1) {
            return (String)names.iterator().next();
        }
        return null;
    }

    public static List<String> getPossibleCompartmentNames(conversion conv) {
        ArrayList<String> names = new ArrayList<String>();
        for (physicalEntityParticipant par : conv.getLEFT()) {
            if (par.getCELLULAR_LOCATION() == null) continue;
            names.add(par.getCELLULAR_LOCATION().getTERM().iterator().next());
        }
        for (physicalEntityParticipant par : conv.getRIGHT()) {
            if (par.getCELLULAR_LOCATION() == null) continue;
            names.add(par.getCELLULAR_LOCATION().getTERM().iterator().next());
        }
        return names;
    }

    public void selectBestCompartment() {
        CompoundModel comp;
        List<NodeModel> neighbors = this.getNeighborsList();
        Ranker<CompoundModel> r = new Ranker<CompoundModel>();
        for (NodeModel neigh : neighbors) {
            CompoundModel cm;
            if (neigh instanceof ComplexMember) {
                neigh = neigh.getParentModel();
            }
            if ((cm = neigh.getParentModel()) == null) continue;
            r.count(cm);
        }
        List list = r.getRankedList();
        if (list.isEmpty()) {
            return;
        }
        List firstGroup = list.get(0);
        if (firstGroup.size() == 1) {
            comp = (CompoundModel)firstGroup.get(0);
        } else {
            for (NodeModel neigh : neighbors) {
                CompoundModel cm;
                if (neigh instanceof ComplexMember) {
                    neigh = neigh.getParentModel();
                }
                if ((cm = neigh.getParentModel()) != null) {
                    cm = cm.getParentModel();
                }
                if (cm == null) continue;
                r.count(cm);
            }
            list = r.getRankedList();
            List secondGroup = list.get(0);
            assert (!secondGroup.isEmpty());
            if (secondGroup.size() == 1) {
                comp = (CompoundModel)secondGroup.get(0);
            } else {
                ArrayList copySec = new ArrayList(secondGroup);
                copySec.retainAll(firstGroup);
                if (!copySec.isEmpty()) {
                    secondGroup = copySec;
                }
                if (!((comp = (CompoundModel)secondGroup.get(0)) instanceof Compartment) && secondGroup.size() > 1) {
                    comp = (CompoundModel)secondGroup.get(1);
                }
            }
        }
        this.getParentModel().removeChild(this);
        comp.addChild(this);
        this.setParentModel(comp);
    }

    @Override
    public boolean isEvent() {
        return true;
    }

    @Override
    public boolean isTranscriptionEvent() {
        return this.isT();
    }

    @Override
    public Set<Node> getTabuNodes() {
        if (this.tabu == null) {
            this.tabu = new HashSet<Node>();
            for (Edge edge : this.getUpstream()) {
                if (!(edge instanceof Substrate)) continue;
                this.tabu.add(edge.getSourceNode());
            }
        }
        return new HashSet<Node>(this.tabu);
    }

    @Override
    public Set<GraphObject> getRequisites() {
        Set<GraphObject> reqs = super.getRequisites();
        reqs.addAll(this.getSourceConnections());
        reqs.addAll(this.getTargetConnections());
        return reqs;
    }

    @Override
    public List<String[]> getInspectable() {
        SpontaneousType spo;
        List<String[]> list = super.getInspectable();
        Conversion.addNamesAndTypeAndID(list, this.conv);
        for (evidence ev : this.conv.getEVIDENCE()) {
            list.add(new String[]{"Evidence", ev.toString()});
        }
        if (!this.conv.getINTERACTION_TYPE().isEmpty()) {
            String s = Conversion.formatInString(this.conv.getINTERACTION_TYPE());
            list.add(new String[]{"Interaction Type", s});
        }
        if ((spo = this.conv.getSPONTANEOUS()) != null) {
            list.add(new String[]{"Spontaneous", spo.toString()});
        }
        Conversion.addDataSourceAndXrefAndComments(list, this.conv);
        return list;
    }

    @Override
    public String getIDHash() {
        return ID.get(this.conv) + this.direction;
    }

    public boolean isDepleting() {
        return this.util.hasModelTag("DEPLETING_REACTION");
    }
}

