/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl2;

import java.util.List;
import java.util.Map;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl2.BioPAXEdge;
import org.gvt.util.ID;

public abstract class PEPBasedEdge
extends BioPAXEdge {
    private physicalEntityParticipant pep;

    public PEPBasedEdge(NodeModel source, NodeModel target, physicalEntityParticipant pep) {
        super(source, target);
        this.pep = pep;
    }

    public PEPBasedEdge(BioPAXEdge excised, Map<NodeModel, NodeModel> map) {
        super(excised, map);
        this.pep = ((PEPBasedEdge)excised).getPep();
    }

    public physicalEntityParticipant getPep() {
        return this.pep;
    }

    @Override
    public String getIDHash() {
        return ID.get(this.pep);
    }

    @Override
    public List<String[]> getInspectable() {
        List<String[]> list = super.getInspectable();
        list.add(new String[]{"ID", ID.get(this.pep)});
        list.add(new String[]{"Stochiometry", "" + this.pep.getSTOICHIOMETRIC_COEFFICIENT()});
        for (String comment : this.pep.getCOMMENT()) {
            if (comment.contains("@Layout")) continue;
            list.add(new String[]{"Comment", comment});
        }
        return list;
    }
}

