/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl3;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gvt.command.CreateConnectionCommand;
import org.gvt.model.EdgeModel;
import org.gvt.model.IBioPAXEdge;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl3.BioPAXL3Graph;
import org.gvt.model.biopaxl3.IBioPAXL3Node;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;

public abstract class BioPAXEdge
extends EdgeModel
implements IBioPAXEdge {
    protected int id;
    protected boolean transcription;

    public BioPAXEdge(NodeModel source, NodeModel target) {
        assert (source != null);
        assert (target != null);
        CreateConnectionCommand ccc = new CreateConnectionCommand();
        ccc.setSource(source);
        ccc.setTarget(target);
        ccc.setConnection(this);
        ccc.execute();
    }

    public BioPAXEdge(BioPAXEdge excised, Map<NodeModel, NodeModel> map) {
        this(map.get(excised.getSource()), map.get(excised.getTarget()));
        this.id = excised.getId();
        this.transcription = excised.isTranscription();
        this.setArrow(excised.getArrow());
        this.setColor(excised.getColor());
        this.setStyle(excised.getStyle());
        for (Object key : excised.getAllLabels()) {
            this.putLabel(key, excised.getLabel(key));
        }
        ((BioPAXL3Graph)((Node)((Object)this.getSource())).getGraph()).putInExcisionMap(excised, this);
        this.putLabel("EXCISED_FROM", excised);
    }

    @Override
    public boolean isTranscription() {
        return this.transcription;
    }

    public void setTranscription(boolean transcription) {
        this.transcription = transcription;
    }

    @Override
    public boolean isBreadthEdge() {
        return true;
    }

    @Override
    public boolean isCausative() {
        return this.isDirected() && this.getSign() != 0;
    }

    @Override
    public Node getSourceNode() {
        return (Node)((Object)this.getSource());
    }

    @Override
    public Node getTargetNode() {
        return (Node)((Object)this.getTarget());
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public boolean isPositive() {
        return this.getSign() == 1;
    }

    @Override
    public boolean isNegative() {
        return this.getSign() == -1;
    }

    @Override
    public boolean isPTM() {
        return !this.isTranscription();
    }

    @Override
    public boolean isEquivalenceEdge() {
        return false;
    }

    @Override
    public boolean isDirected() {
        return true;
    }

    @Override
    public boolean isHighlighted() {
        return this.isHighlight();
    }

    @Override
    public Set<GraphObject> getRequisites() {
        HashSet<GraphObject> reqs = new HashSet<GraphObject>();
        reqs.add((GraphObject)((Object)this.getSource()));
        reqs.add((GraphObject)((Object)this.getTarget()));
        return reqs;
    }

    @Override
    public List<String[]> getInspectable() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        return list;
    }

    @Override
    public String getIDHash() {
        return ((IBioPAXL3Node)this.getSourceNode()).getIDHash() + ((IBioPAXL3Node)this.getTargetNode()).getIDHash();
    }
}

