/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.level3.CellularLocationVocabulary;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Level3Element;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Xref;
import org.eclipse.swt.graphics.Color;
import org.gvt.model.CompoundModel;
import org.gvt.model.EntityAssociated;
import org.gvt.model.biopaxl3.BioPAXCompoundNode;
import org.gvt.model.biopaxl3.BioPAXNode;
import org.gvt.model.biopaxl3.ComplexMember;
import org.gvt.util.EntityHolder;
import org.gvt.util.ID;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.util.XRef;

public class ChbComplex
extends BioPAXCompoundNode
implements EntityAssociated {
    private Complex cmp;
    private static final Color COLOR = new Color(null, 140, 140, 140);

    public ChbComplex(CompoundModel root) {
        super(root);
        this.setText("Complex");
    }

    @Override
    public Collection<? extends Level3Element> getRelatedModelElements() {
        return Arrays.asList(this.cmp);
    }

    public ChbComplex(CompoundModel root, Complex cmp) {
        this(root);
        this.cmp = cmp;
        this.extractReferences();
        this.setText(cmp.getDisplayName() != null && !cmp.getDisplayName().isEmpty() ? cmp.getDisplayName() : (cmp.getStandardName() != null && !cmp.getStandardName().isEmpty() ? cmp.getStandardName() : (!cmp.getName().isEmpty() ? cmp.getName().iterator().next() : "noname")));
        this.setTooltipText(this.getText());
        this.setColor(COLOR);
    }

    public ChbComplex(ChbComplex toexcise, CompoundModel root) {
        super(toexcise, root);
        this.cmp = toexcise.getComplex();
    }

    private void extractReferences() {
        for (Xref xr : this.cmp.getXref()) {
            this.addReference(new XRef(xr));
        }
    }

    public Complex getComplex() {
        return this.cmp;
    }

    @Override
    public EntityHolder getEntity() {
        return new EntityHolder(this.cmp);
    }

    @Override
    public boolean isBreadthNode() {
        return true;
    }

    @Override
    public Set<GraphObject> getRequisites() {
        Set<GraphObject> reqs = super.getRequisites();
        reqs.addAll(this.getChildren());
        return reqs;
    }

    @Override
    public List<String[]> getInspectable() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        BioPAXNode.addNamesAndTypeAndID(list, this.cmp);
        CellularLocationVocabulary voc = this.cmp.getCellularLocation();
        if (voc != null && !voc.getTerm().isEmpty()) {
            list.add(new String[]{"Location", voc.getTerm().iterator().next()});
        }
        BioPAXNode.addDataSourceAndXrefAndComments(list, this.cmp);
        return list;
    }

    @Override
    public String getIDHash() {
        return ID.get(this.cmp);
    }

    public String suggestCompartmentNameUsingMembers() {
        return ChbComplex.suggestCompartmentNameUsingMembers(this.cmp.getComponent());
    }

    public static String suggestCompartmentNameUsingMembers(Set<PhysicalEntity> members) {
        ArrayList<String> names = new ArrayList<String>();
        for (PhysicalEntity mem : members) {
            CellularLocationVocabulary voc = mem.getCellularLocation();
            if (voc == null || voc.getTerm().isEmpty()) continue;
            names.add(voc.getTerm().iterator().next());
        }
        if (!names.isEmpty()) {
            return (String)names.get(0);
        }
        return null;
    }

    public List<ComplexMember> getRelatedMembers(PhysicalEntity pe) {
        ArrayList<ComplexMember> list = new ArrayList<ComplexMember>();
        for (Object o : this.getChildren()) {
            ComplexMember mem = (ComplexMember)o;
            if (mem.getEntity() != pe) continue;
            list.add(mem);
        }
        return list;
    }
}

