/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl3;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.Level3Element;
import org.biopax.paxtools.model.level3.Pathway;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.gvt.model.CompoundModel;
import org.gvt.model.biopaxl3.BioPAXNode;
import org.gvt.util.ID;
import org.gvt.util.NodeProvider;
import org.patika.mada.graph.GraphObject;

public class ChbPathway
extends BioPAXNode {
    Pathway pathway;
    private static final Color COLOR = new Color(null, 220, 210, 200);

    public ChbPathway(CompoundModel root) {
        super(root);
        this.setColor(COLOR);
        this.setText("P");
        this.setSize(new Dimension(20, 20));
        this.setShape("Diamond");
    }

    public ChbPathway(CompoundModel root, Pathway pathway2, NodeProvider prov) {
        this(root);
        prov.register(ID.get(pathway2), this);
        this.pathway = pathway2;
        this.configFromModel();
    }

    @Override
    public void configFromModel() {
        super.configFromModel();
        this.setTooltipText(this.pathway.getStandardName());
    }

    public ChbPathway(ChbPathway excised, CompoundModel root) {
        super(excised, root);
        this.pathway = excised.getPathway();
    }

    public Pathway getPathway() {
        return this.pathway;
    }

    @Override
    public Collection<? extends Level3Element> getRelatedModelElements() {
        return Arrays.asList(this.pathway);
    }

    @Override
    public boolean isEvent() {
        return false;
    }

    @Override
    public Set<GraphObject> getRequisites() {
        Set<GraphObject> reqs = super.getRequisites();
        return reqs;
    }

    @Override
    public List<String[]> getInspectable() {
        List<String[]> list = super.getInspectable();
        ChbPathway.addNamesAndTypeAndID(list, this.pathway);
        for (Evidence ev : this.pathway.getEvidence()) {
            list.add(new String[]{"Evidence", ev.toString()});
        }
        ChbPathway.addDataSourceAndXrefAndComments(list, this.pathway);
        return list;
    }

    @Override
    public String getIDHash() {
        return ID.get(this.pathway);
    }
}

