/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl3;

import java.util.ArrayList;
import org.biopax.paxtools.model.level3.Level3Element;
import org.eclipse.draw2d.geometry.Point;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl3.BioPAXL3Graph;
import org.gvt.model.biopaxl3.Compartment;
import org.gvt.model.biopaxl3.IBioPAXL3Node;

public class NodeUtil {
    private IBioPAXL3Node node;

    public NodeUtil(IBioPAXL3Node node) {
        this.node = node;
    }

    public BioPAXL3Graph getGraph() {
        NodeModel parent = (NodeModel)((Object)this.node);
        while ((parent = parent.getParentModel()) != null && !(parent instanceof BioPAXL3Graph)) {
        }
        return (BioPAXL3Graph)parent;
    }

    public Compartment getCompartment() {
        NodeModel parent = (NodeModel)((Object)this.node);
        while ((parent = parent.getParentModel()) != null && !(parent instanceof Compartment)) {
        }
        return (Compartment)parent;
    }

    public String fetchModelTag(String type) {
        String prefix = this.node.getIDHash() + "@" + type;
        for (Level3Element level3Element : this.node.getRelatedModelElements()) {
            for (String comment : level3Element.getComment()) {
                if (!comment.startsWith(prefix)) continue;
                return comment.substring(prefix.length() + 1);
            }
        }
        return null;
    }

    public boolean hasModelTag(String type) {
        String prefix = this.node.getIDHash() + "@" + type;
        for (Level3Element level3Element : this.node.getRelatedModelElements()) {
            for (String comment : level3Element.getComment()) {
                if (!comment.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    public void recordModelTag(String type, String tag) {
        String prefix = this.node.getIDHash() + "@" + type;
        tag = prefix + "@" + tag;
        for (Level3Element level3Element : this.node.getRelatedModelElements()) {
            this.removeCommentStartsWith(level3Element, prefix);
            level3Element.addComment(tag);
        }
    }

    public void removeModelTag(String type) {
        String prefix = this.node.getIDHash() + "@" + type;
        for (Level3Element level3Element : this.node.getRelatedModelElements()) {
            this.removeCommentStartsWith(level3Element, prefix);
        }
    }

    private void removeCommentStartsWith(Level3Element element, String prefix) {
        for (String com : new ArrayList<String>(element.getComment())) {
            if (!com.startsWith(prefix)) continue;
            element.removeComment(com);
        }
    }

    public String getIDHash() {
        return this.node.getName() != null ? this.node.getName() : "";
    }

    public boolean fetchLocation(String pathwayRDFID) {
        String type;
        String tag;
        if (pathwayRDFID == null) {
            pathwayRDFID = this.getGraph().getPathway().getRDFID();
        }
        if ((tag = this.fetchModelTag(type = "Layout@" + pathwayRDFID)) == null) {
            return false;
        }
        String[] terms = tag.split("@");
        assert (terms.length == 2) : "terms length: " + terms.length + "\n" + tag;
        this.node.setLocationAbs(new Point(Integer.parseInt(terms[0]), Integer.parseInt(terms[1])));
        return true;
    }

    public void recordLocation() {
        String pathwayRDFID = this.getGraph().getPathway().getRDFID();
        String type = "Layout@" + pathwayRDFID;
        String tag = this.node.getLocationAbs().x + "@" + this.node.getLocationAbs().y;
        this.recordModelTag(type, tag);
    }

    public void eraseLocation() {
        String pathwayRDFID = this.getGraph().getPathway().getRDFID();
        String type = "Layout@" + pathwayRDFID;
        this.removeModelTag(type);
    }
}

