/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl3;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.Interaction;
import org.eclipse.swt.graphics.Color;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl3.Actor;
import org.gvt.model.biopaxl3.BioPAXEdge;
import org.gvt.model.biopaxl3.BioPAXNode;
import org.gvt.model.biopaxl3.ChbComplex;
import org.gvt.util.ID;

public class Pairing
extends BioPAXEdge {
    Interaction inter;
    private static final Color COLOR = new Color(null, 100, 100, 100);

    public Pairing(Interaction inter, NodeModel pair1, NodeModel pair2) {
        super(pair1, pair2);
        assert (pair1 instanceof Actor || pair1 instanceof ChbComplex);
        assert (pair2 instanceof Actor || pair2 instanceof ChbComplex);
        this.inter = inter;
        this.setColor(COLOR);
    }

    public Pairing(Pairing excised, Map<NodeModel, NodeModel> map) {
        super(excised, map);
        this.inter = excised.getInteraction();
    }

    public Interaction getInteraction() {
        return this.inter;
    }

    @Override
    public int getSign() {
        return 0;
    }

    @Override
    public boolean isDirected() {
        return false;
    }

    @Override
    public String getIDHash() {
        return ID.get(this.inter);
    }

    @Override
    public List<String[]> getInspectable() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        BioPAXNode.addNamesAndTypeAndID(list, this.inter);
        for (Evidence ev : this.inter.getEvidence()) {
            list.add(new String[]{"Evidence", ev.toString()});
        }
        if (!this.inter.getInteractionType().isEmpty()) {
            String s = BioPAXNode.formatInString(this.inter.getInteractionType());
            list.add(new String[]{"Interaction Type", s});
        }
        BioPAXNode.addDataSourceAndXrefAndComments(list, this.inter);
        return list;
    }
}

