/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.sifl3;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.cbio.causality.signednetwork.SignedType;
import org.eclipse.swt.graphics.Color;
import org.gvt.model.GraphObject;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl3.BioPAXEdge;
import org.gvt.model.biopaxl3.IBioPAXL3Node;

public class SIFEdge
extends BioPAXEdge {
    private String tag;
    private boolean breadthEdge;
    private Set<String> mediators;
    protected Map<GraphObject, SIFEdge> substitutionMap;
    public static Map<String, EdgeType> typeMap = new HashMap<String, EdgeType>();
    private static final boolean SOLID = true;
    private static final boolean DASHED = false;

    public SIFEdge(NodeModel source, NodeModel target, String tag, Set<String> mediators) {
        super(source, target);
        this.tag = tag;
        this.setTooltipText(tag);
        EdgeType et = SIFEdge.getType(tag);
        this.setColor(et.color);
        if (et.directed) {
            this.setArrow("Target");
        }
        if (!et.solid) {
            this.setStyle("Dashed");
        }
        this.breadthEdge = !SIFEdge.getType((String)tag).noDistance;
        this.mediators = new HashSet<String>();
        if (mediators != null) {
            this.mediators.addAll(mediators);
        }
    }

    public String getTag() {
        return this.tag;
    }

    @Override
    public int getSign() {
        return SIFEdge.getType((String)this.tag).sign;
    }

    @Override
    public boolean isDirected() {
        return SIFEdge.getType((String)this.tag).directed;
    }

    @Override
    public boolean isBreadthEdge() {
        return this.breadthEdge;
    }

    @Override
    public List<String[]> getInspectable() {
        List<String[]> list = super.getInspectable();
        list.add(new String[]{"Type", this.tag});
        if (this.getTooltipText() != null && !this.getTooltipText().isEmpty()) {
            list.add(new String[]{"Tooltip", this.getTooltipText()});
        }
        return list;
    }

    private static void addType(EdgeType type) {
        typeMap.put(type.tag, type);
    }

    public static EdgeType getType(String tag) {
        return typeMap.get(tag);
    }

    public static boolean isDirected(String tag) {
        return SIFEdge.getType((String)tag).intType.isDirected();
    }

    @Override
    public String getIDHash() {
        return ((IBioPAXL3Node)this.getSourceNode()).getIDHash() + ((IBioPAXL3Node)this.getTargetNode()).getIDHash() + this.tag;
    }

    public Set<String> getMediators() {
        return this.mediators;
    }

    public Set<String> getMediators(Set<GraphObject> nodes) {
        if (this.substitutionMap == null) {
            return this.mediators;
        }
        if (nodes.isEmpty()) {
            return this.mediators;
        }
        HashSet<String> meds = new HashSet<String>();
        for (GraphObject node : nodes) {
            if (!this.substitutionMap.containsKey(node)) continue;
            meds.addAll(this.substitutionMap.get(node).getMediators(nodes));
        }
        if (!meds.isEmpty()) {
            return meds;
        }
        return this.mediators;
    }

    public void addSubstitution(SIFEdge edge, NodeModel node) {
        if (this.substitutionMap == null) {
            this.substitutionMap = new HashMap<GraphObject, SIFEdge>();
        }
        this.substitutionMap.put(node, edge);
        this.mediators.addAll(edge.getMediators());
    }

    static {
        SIFEdge.addType(new EdgeType(SIFEnum.NEIGHBOR_OF, new Color(null, 100, 120, 100), true, 0, false));
        SIFEdge.addType(new EdgeType(SIFEnum.INTERACTS_WITH, new Color(null, 255, 192, 203), true, 0, false));
        SIFEdge.addType(new EdgeType(SIFEnum.IN_COMPLEX_WITH, new Color(null, 150, 150, 150), true, 0, false));
        SIFEdge.addType(new EdgeType(SIFEnum.CONTROLS_STATE_CHANGE_OF, new Color(null, 50, 100, 150), true, 0, false));
        SIFEdge.addType(new EdgeType(SIFEnum.CONTROLS_TRANSPORT_OF, new Color(null, 100, 100, 150), true, 0, false));
        SIFEdge.addType(new EdgeType(SIFEnum.CONTROLS_PHOSPHORYLATION_OF, new Color(null, 100, 150, 100), true, 0, false));
        SIFEdge.addType(new EdgeType(SIFEnum.CATALYSIS_PRECEDES, new Color(null, 150, 50, 150), true, 0, false));
        SIFEdge.addType(new EdgeType(SIFEnum.CONTROLS_EXPRESSION_OF, new Color(null, 50, 150, 50), false, 0, false));
        SIFEdge.addType(new EdgeType(SIFEnum.CONSUMPTION_CONTROLLED_BY, new Color(null, 100, 120, 80), true, 0, false));
        SIFEdge.addType(new EdgeType(SIFEnum.CONTROLS_PRODUCTION_OF, new Color(null, 50, 120, 100), true, 0, false));
        SIFEdge.addType(new EdgeType(SIFEnum.CONTROLS_TRANSPORT_OF_CHEMICAL, new Color(null, 80, 130, 100), true, 0, false));
        SIFEdge.addType(new EdgeType(SIFEnum.CHEMICAL_AFFECTS, new Color(null, 100, 80, 80), true, 0, false));
        SIFEdge.addType(new EdgeType(SIFEnum.REACTS_WITH, new Color(null, 70, 120, 80), true, 0, true));
        SIFEdge.addType(new EdgeType(SIFEnum.USED_TO_PRODUCE, new Color(null, 70, 80, 120), true, 0, false));
        SIFEdge.addType(new EdgeType(SignedType.PHOSPHORYLATES, new Color(null, 0, 150, 0), true, 1, false));
        SIFEdge.addType(new EdgeType(SignedType.DEPHOSPHORYLATES, new Color(null, 150, 0, 0), true, -1, false));
        SIFEdge.addType(new EdgeType(SignedType.UPREGULATES_EXPRESSION, new Color(null, 0, 150, 0), false, 1, false));
        SIFEdge.addType(new EdgeType(SignedType.DOWNREGULATES_EXPRESSION, new Color(null, 150, 0, 0), false, -1, false));
        SIFEdge.addType(new EdgeType("activates-gtpase", true, new Color(null, 0, 150, 200), true, 1, false));
        SIFEdge.addType(new EdgeType("inhibits-gtpase", true, new Color(null, 200, 0, 170), true, -1, false));
        SIFEdge.addType(new EdgeType("TRANSCRIPTION", true, new Color(null, 150, 150, 0), false, 0, false));
        SIFEdge.addType(new EdgeType("DEGRADATION", true, new Color(null, 150, 0, 150), true, 0, false));
        SIFEdge.addType(new EdgeType("BINDS_TO", false, new Color(null, 100, 100, 100), true, 0, true));
        SIFEdge.addType(new EdgeType("in-same-group", false, new Color(null, 100, 100, 100), true, 0, false));
        SIFEdge.addType(new EdgeType("correlates-with", false, new Color(null, 100, 100, 100), true, 0, false));
        SIFEdge.addType(new EdgeType("activates", true, new Color(null, 50, 180, 50), true, 1, false));
        SIFEdge.addType(new EdgeType("inhibits", true, new Color(null, 180, 50, 50), true, -1, false));
    }

    public static class EdgeType {
        SIFType intType;
        String tag;
        Color color;
        boolean solid;
        boolean directed;
        int sign;
        boolean noDistance;

        private EdgeType(SIFType intType, Color color, boolean solid, int sign, boolean noDistance) {
            this.intType = intType;
            this.tag = intType.getTag();
            this.directed = intType.isDirected();
            this.color = color;
            this.solid = solid;
            this.sign = sign;
            this.noDistance = noDistance;
        }

        private EdgeType(String tag, boolean directed, Color color, boolean solid, int sign, boolean noDistance) {
            this.tag = tag;
            this.directed = directed;
            this.color = color;
            this.solid = solid;
            this.sign = sign;
            this.noDistance = noDistance;
        }

        public String getTag() {
            return this.tag;
        }

        public boolean isDirected() {
            return this.directed;
        }

        public SIFType getIntType() {
            return this.intType;
        }

        public Color getColor() {
            return this.color;
        }

        public boolean isSolid() {
            return this.solid;
        }

        public int getSign() {
            return this.sign;
        }

        public boolean isNoDistance() {
            return this.noDistance;
        }
    }
}

