/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.sifl3;

import java.util.Collection;
import java.util.List;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Level3Element;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.pattern.util.HGNC;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.gvt.model.CompoundModel;
import org.gvt.model.EntityAssociated;
import org.gvt.model.biopaxl3.Actor;
import org.gvt.model.biopaxl3.BioPAXNode;
import org.gvt.util.EntityHolder;
import org.gvt.util.ID;
import org.patika.mada.util.XRef;

public class SIFNode
extends BioPAXNode
implements EntityAssociated {
    private EntityReference entity;

    public SIFNode(CompoundModel root, EntityHolder entity2) {
        this(root, entity2.l3er);
        assert (entity2.l3er != null);
    }

    public SIFNode(CompoundModel root, EntityReference entity2) {
        super(root);
        this.entity = entity2;
        this.setShape("RoundRect");
        this.configFromModel();
        int width = this.suggestInitialWidth();
        if (!(entity2 instanceof SmallMoleculeReference) && width < 40) {
            width = 40;
        }
        int height = 20;
        this.setSize(new Dimension(width, height));
    }

    @Override
    public void configFromModel() {
        String name = SIFNode.extractGeneSymbol(this.entity);
        if (name == null) {
            name = this.entity.getDisplayName();
        }
        if (name == null && !this.entity.getName().isEmpty()) {
            name = this.entity.getName().iterator().next();
        }
        if (name == null) {
            name = "noname";
        }
        this.setText(name);
        this.setTooltipText(this.getText());
        if (this.entity instanceof SmallMoleculeReference) {
            this.setColor(Actor.SMALL_MOL_BG_COLOR);
        } else {
            this.setColor(this.getEntitySpecificColor());
        }
        String symbol = HGNC.getSymbol(name);
        if (symbol != null) {
            this.addReference(new XRef("HGNC SYMBOL", symbol));
        }
    }

    public Color getEntitySpecificColor() {
        return this.getStringSpecificColor(ID.get(this.entity));
    }

    @Override
    public EntityHolder getEntity() {
        return new EntityHolder(this.entity);
    }

    @Override
    public Collection<? extends Level3Element> getRelatedModelElements() {
        return null;
    }

    @Override
    public boolean isEvent() {
        return false;
    }

    @Override
    public boolean isBreadthNode() {
        return true;
    }

    @Override
    public List<String[]> getInspectable() {
        List<String[]> list = super.getInspectable();
        return list;
    }
}

