/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.controller.Completer;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.CatalysisDirectionType;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.MolecularInteraction;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.Stoichiometry;
import org.biopax.paxtools.model.level3.TemplateReaction;
import org.gvt.command.DeleteCommand;
import org.gvt.model.CompoundModel;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl3.Actor;
import org.gvt.model.biopaxl3.BioPAXL3Graph;
import org.gvt.model.biopaxl3.ChbComplex;
import org.gvt.model.biopaxl3.ChbControl;
import org.gvt.model.biopaxl3.ChbConversion;
import org.gvt.model.biopaxl3.ChbPathway;
import org.gvt.model.biopaxl3.ChbTempReac;
import org.gvt.model.biopaxl3.Compartment;
import org.gvt.model.biopaxl3.ComplexMember;
import org.gvt.model.biopaxl3.Hub;
import org.gvt.model.biopaxl3.Member;
import org.gvt.model.biopaxl3.Pairing;
import org.gvt.util.CompartmentManager;
import org.gvt.util.Conf;
import org.gvt.util.ID;
import org.gvt.util.NodeProvider;

public class BioPAXL3Converter
implements NodeProvider {
    public static boolean nestCompartments = true;
    Map<String, NodeModel> nodeMap;
    Map<String, Set<Actor>> nodeSetMap;
    Model model;
    Pathway pathway;
    BioPAXL3Graph root;
    Set<String> idsOfInterest;

    public BioPAXL3Converter(BioPAXL3Graph root) {
        this.root = root;
        this.nodeMap = new HashMap<String, NodeModel>();
        this.nodeSetMap = new HashMap<String, Set<Actor>>();
        this.model = root.getBiopaxModel();
        this.pathway = root.getPathway().l3p;
        this.populateEntitiesOfFocus();
    }

    public void convert() {
        Object ele;
        if (nestCompartments) {
            this.createAndNestCompartments();
        }
        for (String id : this.idsOfInterest) {
            ele = this.model.getByID(id);
            if (!(ele instanceof Conversion) && !(ele instanceof TemplateReaction) && (!(ele instanceof MolecularInteraction) || !Conf.drawPPI())) continue;
            this.getNode(ID.get((BioPAXElement)ele), this.root);
        }
        for (String id : this.idsOfInterest) {
            ele = this.model.getByID(id);
            if (!(ele instanceof Control) || !ChbControl.controlNeedsToBeANode((Control)ele, this)) continue;
            this.getNode(ID.get((BioPAXElement)ele), this.root);
        }
        HashSet<PhysicalEntity> reiter = new HashSet<PhysicalEntity>();
        HashMap existing = new HashMap();
        for (String id : this.idsOfInterest) {
            NodeModel node1 = this.getAnExistingNode(id);
            if (node1 == null || !(this.model.getByID(id) instanceof PhysicalEntity)) continue;
            reiter.add((PhysicalEntity)this.model.getByID(id));
        }
        while (!reiter.isEmpty()) {
            HashSet<PhysicalEntity> newEnts = new HashSet<PhysicalEntity>();
            for (PhysicalEntity pe : reiter) {
                EntityReference er;
                NodeModel node2;
                NodeModel node1 = this.getAnExistingNode(ID.get(pe));
                for (PhysicalEntity physicalEntity2 : pe.getMemberPhysicalEntity()) {
                    if (!this.needsToBeDisplayed(ID.get(physicalEntity2))) continue;
                    node2 = this.getAnExistingNode(ID.get(physicalEntity2));
                    if (node2 == null) {
                        node2 = this.getNode(ID.get(physicalEntity2), this.root);
                        newEnts.add(physicalEntity2);
                    }
                    if (existing.containsKey(node1) && ((Set)existing.get(node1)).contains(node2)) continue;
                    new Member(node1, node2);
                    if (!existing.containsKey(node1)) {
                        existing.put(node1, new HashSet());
                    }
                    ((Set)existing.get(node1)).add(node2);
                }
                if (pe instanceof SimplePhysicalEntity && (er = ((SimplePhysicalEntity)pe).getEntityReference()) != null && pe.getMemberPhysicalEntity().isEmpty()) {
                    for (EntityReference mem2 : er.getMemberEntityReference()) {
                        if (!this.needsToBeDisplayed(ID.get(mem2))) continue;
                        NodeModel node22 = this.getAnExistingNode(ID.get(mem2));
                        if (node22 == null) {
                            node22 = this.getNode(ID.get(mem2), this.root);
                        }
                        if (existing.containsKey(node1) && ((Set)existing.get(node1)).contains(node22)) continue;
                        new Member(node1, node22);
                        if (!existing.containsKey(node1)) {
                            existing.put(node1, new HashSet());
                        }
                        ((Set)existing.get(node1)).add(node22);
                    }
                }
                for (PhysicalEntity physicalEntity3 : pe.getMemberPhysicalEntityOf()) {
                    if (!this.needsToBeDisplayed(ID.get(physicalEntity3))) continue;
                    node2 = this.getAnExistingNode(ID.get(physicalEntity3));
                    if (node2 == null) {
                        node2 = this.getNode(ID.get(physicalEntity3), this.root);
                        newEnts.add(physicalEntity3);
                    }
                    if (existing.containsKey(node2) && ((Set)existing.get(node2)).contains(node1)) continue;
                    new Member(node2, node1);
                    if (!existing.containsKey(node2)) {
                        existing.put(node2, new HashSet());
                    }
                    ((Set)existing.get(node2)).add(node1);
                }
            }
            reiter = newEnts;
        }
        ArrayList<Compartment> remove = new ArrayList<Compartment>();
        for (Object o : this.root.getNodes()) {
            Compartment com;
            if (!(o instanceof Compartment) || !(com = (Compartment)o).getChildren().isEmpty()) continue;
            remove.add(com);
        }
        for (Compartment com : remove) {
            DeleteCommand command = new DeleteCommand();
            command.setChild(com);
            command.setParent(com.getParentModel());
            command.execute();
        }
        for (Pathway p : this.model.getObjects(Pathway.class)) {
            if (p.getDisplayName() != null) continue;
            if (p.getStandardName() != null) {
                p.setDisplayName(p.getStandardName());
                continue;
            }
            if (!p.getName().isEmpty()) {
                p.setDisplayName(p.getName().iterator().next());
                continue;
            }
            p.setDisplayName(ID.get(p));
        }
    }

    private Hub createMolecularInteraction(MolecularInteraction inter) {
        if (Hub.needsToRepresentedWithANode(inter, this)) {
            String compName = Hub.getPossibleCompartmentName(inter);
            if (nestCompartments) {
                compName = CompartmentManager.getUnifiedName(compName);
            }
            BioPAXL3Graph compart = compName == null ? this.root : (CompoundModel)this.nodeMap.get(compName);
            return new Hub(compart, inter, this);
        }
        ArrayList<NodeModel> interactors = new ArrayList<NodeModel>(2);
        for (Entity ent : inter.getParticipant()) {
            NodeModel node = this.getNode(ID.get(ent), this.root);
            if (node == null) continue;
            interactors.add(node);
        }
        assert (interactors.size() == 2) : "There are not 2 interactors. Size is " + interactors.size();
        new Pairing(inter, (NodeModel)interactors.get(0), (NodeModel)interactors.get(1));
        return null;
    }

    private NodeModel getAnExistingNode(String id) {
        if (this.nodeMap.containsKey(id)) {
            return this.nodeMap.get(id);
        }
        if (this.nodeSetMap.containsKey(id)) {
            return this.chooseOneOfMultipleNodes(id);
        }
        return null;
    }

    private NodeModel chooseOneOfMultipleNodes(String id) {
        ArrayList nodes = new ArrayList(this.nodeSetMap.get(id));
        Collections.sort(nodes, new Comparator<Actor>(){

            @Override
            public int compare(Actor o1, Actor o2) {
                return o1.getIDHash().compareTo(o2.getIDHash());
            }
        });
        return (NodeModel)nodes.get(0);
    }

    private ChbTempReac createTemplateReaction(TemplateReaction reac) {
        String compName = ChbTempReac.getPossibleCompartmentName(reac);
        if (compName != null && nestCompartments) {
            compName = CompartmentManager.getUnifiedName(compName);
        }
        BioPAXL3Graph compart = compName == null ? this.root : (CompoundModel)this.nodeMap.get(compName);
        ChbTempReac tempReac = new ChbTempReac(compart, reac, this);
        tempReac.selectBestCompartment();
        return tempReac;
    }

    private ChbConversion createConversion(Conversion conv) {
        BioPAXL3Graph compart;
        String compName = ChbConversion.getPossibleCompartmentName(conv);
        if (compName != null && nestCompartments) {
            compName = CompartmentManager.getUnifiedName(compName);
        }
        CompoundModel compoundModel = compart = compName == null ? this.root : (CompoundModel)this.nodeMap.get(compName);
        assert (compart != null);
        ChbConversion forwd = null;
        ChbConversion rever = null;
        if (this.evidenceExists(conv, true)) {
            forwd = new ChbConversion(compart, conv, true, this);
            forwd.selectBestCompartment();
        }
        if (this.evidenceExists(conv, false)) {
            rever = new ChbConversion(compart, conv, false, this);
            rever.selectBestCompartment();
        }
        if (forwd == null && rever == null) {
            forwd = new ChbConversion(compart, conv, true, this);
            forwd.selectBestCompartment();
        }
        if (forwd != null) {
            return forwd;
        }
        return rever;
    }

    private CompoundModel getCompartment(PhysicalEntity pe) {
        if (pe.getCellularLocation() != null && !pe.getCellularLocation().getTerm().isEmpty()) {
            Compartment comp;
            String compName = pe.getCellularLocation().getTerm().iterator().next();
            if (nestCompartments) {
                compName = CompartmentManager.getUnifiedName(compName);
            }
            if ((comp = (Compartment)this.nodeMap.get(compName)) == null) {
                comp = new Compartment(this.root, compName);
                this.nodeMap.put(compName, comp);
            }
            return comp;
        }
        return this.root;
    }

    private CompoundModel getCompartment(String compName) {
        Compartment comp;
        if (nestCompartments) {
            compName = CompartmentManager.getUnifiedName(compName);
        }
        if ((comp = (Compartment)this.nodeMap.get(compName)) == null) {
            comp = new Compartment(this.root, compName);
            this.nodeMap.put(compName, comp);
        }
        return comp;
    }

    private void populateEntitiesOfFocus() {
        this.idsOfInterest = new HashSet<String>();
        if (this.pathway != null) {
            Completer c = new Completer(SimpleEditorMap.L3);
            HashSet<BioPAXElement> s = new HashSet<BioPAXElement>();
            s.add(this.pathway);
            Set<BioPAXElement> completed = c.complete(s, this.model);
            for (BioPAXElement ele : completed) {
                this.idsOfInterest.add(ID.get(ele));
            }
        } else {
            for (BioPAXElement ele : this.model.getObjects()) {
                this.idsOfInterest.add(ID.get(ele));
            }
        }
    }

    private void createAndNestCompartments() {
        assert (nestCompartments);
        HashMap<String, CompoundModel> compMap = new HashMap<String, CompoundModel>();
        for (String id : this.idsOfInterest) {
            Compartment comp;
            PhysicalEntity pe;
            String compName;
            BioPAXElement ele = this.model.getByID(id);
            if (!(ele instanceof PhysicalEntity) || (compName = this.extractCellularLoc(pe = (PhysicalEntity)ele)) == null || (comp = (Compartment)this.nodeMap.get(compName = CompartmentManager.getUnifiedName(compName))) != null) continue;
            comp = new Compartment(this.root, compName);
            this.nodeMap.put(compName, comp);
            compMap.put(compName, comp);
        }
        CompartmentManager.nestCompartments(compMap);
    }

    private String extractCellularLoc(PhysicalEntity pe) {
        if (pe.getCellularLocation() != null && !pe.getCellularLocation().getTerm().isEmpty()) {
            return pe.getCellularLocation().getTerm().iterator().next();
        }
        return null;
    }

    private Compartment extractCompartment(PhysicalEntity pe) {
        String compName = this.extractCellularLoc(pe);
        if (compName != null) {
            if (nestCompartments) {
                compName = CompartmentManager.getUnifiedName(compName);
            }
            Compartment cmp = (Compartment)this.nodeMap.get(compName);
            assert (cmp != null);
            return cmp;
        }
        return null;
    }

    private NodeModel createSimplePhysicalEntity(Named peOrEr, CompoundModel relatedRoot) {
        assert (!(peOrEr instanceof Complex));
        assert (peOrEr instanceof EntityReference || peOrEr instanceof PhysicalEntity);
        if (peOrEr.getStandardName() == null) {
            EntityReference er;
            if (peOrEr.getDisplayName() != null) {
                peOrEr.setStandardName(peOrEr.getDisplayName());
            } else if (!peOrEr.getName().isEmpty()) {
                peOrEr.setStandardName(peOrEr.getName().iterator().next());
            } else if (peOrEr instanceof SimplePhysicalEntity && (er = ((SimplePhysicalEntity)peOrEr).getEntityReference()) != null) {
                peOrEr.setStandardName(er.getStandardName());
                if (peOrEr.getStandardName() == null && er.getName() != null && !er.getName().isEmpty()) {
                    peOrEr.setStandardName(er.getName().iterator().next());
                }
            }
        }
        if (peOrEr.getStandardName() == null) {
            peOrEr.setStandardName("noname");
        }
        CompoundModel parent = null;
        if (peOrEr instanceof PhysicalEntity) {
            parent = this.extractCompartment((PhysicalEntity)peOrEr);
        }
        if (parent == null) {
            parent = this.root;
        }
        Actor actor = peOrEr instanceof PhysicalEntity ? (Actor.isUbique((PhysicalEntity)peOrEr) ? new Actor(relatedRoot, (PhysicalEntity)peOrEr, null) : new Actor(parent, (PhysicalEntity)peOrEr, null)) : new Actor(parent, (EntityReference)peOrEr, null);
        if (actor.isUbique()) {
            if (!this.nodeSetMap.containsKey(ID.get(peOrEr))) {
                this.nodeSetMap.put(ID.get(peOrEr), new HashSet());
            }
            this.nodeSetMap.get(ID.get(peOrEr)).add(actor);
        } else {
            this.nodeMap.put(ID.get(peOrEr), actor);
        }
        return actor;
    }

    private void createComplexContent(ChbComplex c, Complex current_cmp, Complex top_cmp) {
        for (PhysicalEntity pe : current_cmp.getComponent()) {
            if (pe instanceof Complex && !((Complex)pe).getComponent().isEmpty()) {
                this.createComplexContent(c, (Complex)pe, top_cmp);
                continue;
            }
            ComplexMember cm = new ComplexMember(c, pe, (Entity)top_cmp);
            cm.setMultimerNo(this.getStoichiometry(current_cmp, pe));
            cm.setRelated(top_cmp);
            if (!this.nodeSetMap.containsKey(ID.get(pe))) {
                this.nodeSetMap.put(ID.get(pe), new HashSet());
            }
            this.nodeSetMap.get(ID.get(pe)).add(cm);
        }
    }

    private int getStoichiometry(Complex c, PhysicalEntity mem) {
        for (Stoichiometry st : c.getComponentStoichiometry()) {
            if (!st.getPhysicalEntity().equals(mem)) continue;
            return (int)st.getStoichiometricCoefficient();
        }
        return 1;
    }

    private boolean hasSingleMultimerMember(Complex c) {
        return c.getComponent().size() == 1 && c.getComponent().iterator().next() instanceof SimplePhysicalEntity && c.getComponentStoichiometry().size() == 1 && c.getComponentStoichiometry().iterator().next().getStoichiometricCoefficient() > 1.0f;
    }

    private boolean evidenceExists(Conversion conv, boolean direction) {
        for (Control cont : conv.getControlledOf()) {
            CatalysisDirectionType dir;
            if (!(cont instanceof Catalysis) || (dir = ((Catalysis)cont).getCatalysisDirection()) == null || !(direction ? dir == CatalysisDirectionType.LEFT_TO_RIGHT : dir == CatalysisDirectionType.RIGHT_TO_LEFT)) continue;
            return true;
        }
        ConversionDirectionType cd = conv.getConversionDirection();
        if (cd == ConversionDirectionType.REVERSIBLE) {
            return true;
        }
        return direction ? cd == ConversionDirectionType.LEFT_TO_RIGHT : cd == ConversionDirectionType.RIGHT_TO_LEFT;
    }

    private NodeModel createComplex(Complex cmp) {
        NodeModel nd;
        String nm;
        CompoundModel compart = this.getCompartment(cmp);
        if (compart == this.root && (nm = ChbComplex.suggestCompartmentNameUsingMembers(cmp.getComponent())) != null) {
            if (nestCompartments) {
                nm = CompartmentManager.getUnifiedName(nm);
            }
            compart = this.getCompartment(nm);
        }
        if (cmp.getComponent().isEmpty()) {
            nd = new Actor(compart, cmp, null);
        } else if (this.hasSingleMultimerMember(cmp)) {
            PhysicalEntity mem = cmp.getComponent().iterator().next();
            nd = new Actor(compart, mem, (Entity)cmp);
            ((Actor)nd).setMultimerNo(this.getStoichiometry(cmp, mem));
        } else {
            ChbComplex c = new ChbComplex(compart, cmp);
            this.createComplexContent(c, cmp, cmp);
            nd = c;
        }
        this.nodeMap.put(ID.get(cmp), nd);
        return nd;
    }

    @Override
    public NodeModel getNode(String id, CompoundModel relatedRoot) {
        if (this.nodeMap.containsKey(id)) {
            return this.nodeMap.get(id);
        }
        if (!this.needsToBeDisplayed(id)) {
            return null;
        }
        BioPAXElement ele = this.model.getByID(id);
        if (ele instanceof Complex) {
            return this.createComplex((Complex)ele);
        }
        if (ele instanceof PhysicalEntity || ele instanceof EntityReference) {
            return this.createSimplePhysicalEntity((Named)ele, relatedRoot);
        }
        if (ele instanceof Control) {
            return new ChbControl(relatedRoot, (Control)ele, this);
        }
        if (ele instanceof Pathway) {
            return new ChbPathway(relatedRoot, (Pathway)ele, this);
        }
        if (ele instanceof Conversion) {
            return this.createConversion((Conversion)ele);
        }
        if (ele instanceof TemplateReaction) {
            return this.createTemplateReaction((TemplateReaction)ele);
        }
        if (ele instanceof MolecularInteraction && Conf.drawPPI()) {
            return this.createMolecularInteraction((MolecularInteraction)ele);
        }
        return null;
    }

    @Override
    public boolean needsToBeDisplayed(String id) {
        return this.idsOfInterest.contains(id);
    }

    @Override
    public void register(String id, NodeModel node) {
        this.nodeMap.put(id, node);
    }
}

