/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.controller.Cloner;
import org.biopax.paxtools.controller.Completer;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.interaction;
import org.biopax.paxtools.model.level2.pathway;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.xref;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.query.QueryExecuter;
import org.biopax.paxtools.query.algorithm.Direction;
import org.biopax.paxtools.query.wrapperL3.Filter;
import org.gvt.util.EntityHolder;
import org.gvt.util.ID;
import org.gvt.util.PathwayHolder;
import org.patika.mada.util.XRef;

public class BioPAXUtil {
    private static final PathAccessor locAcc = new PathAccessor("PhysicalEntity/cellularLocation/term");

    public static List<String> namesOfUnemptyPathways(Model model) {
        ArrayList<String> list;
        block3: {
            block2: {
                list = new ArrayList<String>();
                if (model.getLevel() != BioPAXLevel.L3) break block2;
                for (Pathway p : model.getObjects(Pathway.class)) {
                    PathwayHolder ph = new PathwayHolder(p);
                    if (p.getPathwayComponent().isEmpty()) continue;
                    list.add(ph.getName());
                }
                break block3;
            }
            if (model.getLevel() != BioPAXLevel.L2) break block3;
            for (pathway p : model.getObjects(pathway.class)) {
                PathwayHolder ph = new PathwayHolder(p);
                if (p.getPATHWAY_COMPONENTS().isEmpty()) continue;
                list.add(ph.getName());
            }
        }
        return list;
    }

    public static int numberOfUnemptyPathways(Model model) {
        List<String> names = BioPAXUtil.namesOfUnemptyPathways(model);
        if (names == null) {
            return 0;
        }
        return names.size();
    }

    public static PathwayHolder createGlobalPathway(Model model, String name) {
        PathwayHolder h;
        block3: {
            block2: {
                h = new PathwayHolder(model, name);
                if (model.getLevel() != BioPAXLevel.L3) break block2;
                Pathway p = h.l3p;
                for (Interaction inter : model.getObjects(Interaction.class)) {
                    p.addPathwayComponent(inter);
                }
                break block3;
            }
            if (model.getLevel() != BioPAXLevel.L2) break block3;
            pathway p = h.l2p;
            for (interaction inter : model.getObjects(interaction.class)) {
                p.addPATHWAY_COMPONENTS(inter);
            }
        }
        return h;
    }

    public static Set<String> collectIDs(Collection<BioPAXElement> eles) {
        HashSet<String> set = new HashSet<String>();
        for (BioPAXElement ele : eles) {
            set.add(ID.get(ele));
        }
        return set;
    }

    public static PathwayHolder createPathway(Model model, String name, Collection<String> intids) {
        PathwayHolder h = new PathwayHolder(model, name);
        if (model.getLevel() == BioPAXLevel.L3) {
            Pathway p = h.l3p;
            for (String id : intids) {
                BioPAXElement ele = model.getByID(id);
                if (!(ele instanceof Interaction)) continue;
                p.addPathwayComponent((Interaction)ele);
            }
            Completer c = new Completer(SimpleEditorMap.L3);
            Set<BioPAXElement> set = new HashSet<BioPAXElement>();
            set.add(p);
            set = c.complete(set, model);
            HashSet<String> ids = new HashSet<String>();
            for (BioPAXElement ele : set) {
                ids.add(ID.get(ele));
            }
            ids.remove(ID.get(p));
            for (String id : intids) {
                if (ids.contains(id)) continue;
                p.addComment("#chibedata-pathwaymember@" + id);
            }
        } else {
            pathway p = h.l2p;
            for (interaction inter : model.getObjects(interaction.class)) {
                if (!intids.contains(ID.get(inter))) continue;
                p.addPATHWAY_COMPONENTS(inter);
            }
        }
        return h;
    }

    public static String makeUniquePathwayName(Model model, String name) {
        String offer;
        List<String> names;
        if (name == null) {
            name = "unnamed pathway";
        }
        if (!(names = BioPAXUtil.getPathwayNames(model)).contains(name)) {
            return name;
        }
        int i = 2;
        do {
            offer = name + " (" + i + ")";
            ++i;
        } while (names.contains(offer));
        return offer;
    }

    public static List<String> getPathwayNames(Model model) {
        ArrayList<String> names;
        block8: {
            block7: {
                if (model == null) {
                    return Collections.emptyList();
                }
                names = new ArrayList<String>();
                if (model.getLevel() != BioPAXLevel.L3) break block7;
                for (Pathway p : model.getObjects(Pathway.class)) {
                    if (p.getDisplayName() == null) {
                        if (p.getStandardName() != null) {
                            p.setDisplayName(p.getStandardName());
                        } else if (!p.getName().isEmpty()) {
                            p.setDisplayName(p.getName().iterator().next());
                        }
                    }
                    names.add(p.getDisplayName());
                }
                break block8;
            }
            if (model.getLevel() != BioPAXLevel.L2) break block8;
            for (pathway p : model.getObjects(pathway.class)) {
                names.add(p.getNAME());
            }
        }
        return names;
    }

    public static Map<String, PathwayHolder> getNameToPathwayMap(Model model) {
        HashMap<String, PathwayHolder> map;
        block3: {
            block2: {
                map = new HashMap<String, PathwayHolder>();
                if (model.getLevel() != BioPAXLevel.L3) break block2;
                for (Pathway p : model.getObjects(Pathway.class)) {
                    PathwayHolder ph = new PathwayHolder(p);
                    map.put(ph.getName(), ph);
                }
                break block3;
            }
            if (model.getLevel() != BioPAXLevel.L2) break block3;
            for (pathway p : model.getObjects(pathway.class)) {
                PathwayHolder ph = new PathwayHolder(p);
                map.put(ph.getName(), ph);
            }
        }
        return map;
    }

    public static PathwayHolder getPathwayOfNeighbors(Collection<EntityHolder> entHolds, Model model, String name) {
        PathwayHolder h = new PathwayHolder(model, name);
        if (h.isLevel3()) {
            HashSet<BioPAXElement> eles = new HashSet<BioPAXElement>();
            for (EntityHolder entHold : entHolds) {
                eles.add(entHold.l3er != null ? entHold.l3er : entHold.l3pe);
            }
            Set<BioPAXElement> result = QueryExecuter.runNeighborhood(eles, model, 1, Direction.BOTHSTREAM, new Filter[0]);
            for (BioPAXElement ele : result) {
                if (!(ele instanceof Interaction)) continue;
                h.l3p.addPathwayComponent((Interaction)ele);
            }
        } else {
            for (EntityHolder entHold : entHolds) {
                for (interaction inter : entHold.l2pe.getAllInteractions()) {
                    h.l2p.addPATHWAY_COMPONENTS(inter);
                }
            }
        }
        return h;
    }

    public static Set<EntityHolder> getEntities(Model model) {
        if (model == null) {
            return Collections.emptySet();
        }
        HashSet<EntityHolder> set = new HashSet<EntityHolder>();
        if (model.getLevel().equals((Object)BioPAXLevel.L3)) {
            for (EntityReference entityReference : model.getObjects(EntityReference.class)) {
                set.add(new EntityHolder(entityReference));
            }
            if (set.isEmpty()) {
                for (PhysicalEntity physicalEntity2 : model.getObjects(PhysicalEntity.class)) {
                    set.add(new EntityHolder(physicalEntity2));
                }
            }
        }
        if (model.getLevel().equals((Object)BioPAXLevel.L2)) {
            for (physicalEntity physicalEntity3 : model.getObjects(physicalEntity.class)) {
                set.add(new EntityHolder(physicalEntity3));
            }
        }
        return set;
    }

    public static Model excise(Model model, PathwayHolder ph) {
        SimpleEditorMap editorMap = SimpleEditorMap.get(model.getLevel());
        Completer c = new Completer(editorMap);
        Set<BioPAXElement> set = new HashSet<BioPAXElement>();
        set.add(ph.getPathway());
        set = c.complete(set, model);
        Cloner cloner = new Cloner(editorMap, model.getLevel().getDefaultFactory());
        return cloner.clone(model, set);
    }

    public static Set<BioPAXElement> getContent(Collection<EntityHolder> ehs) {
        HashSet<BioPAXElement> set = new HashSet<BioPAXElement>();
        for (EntityHolder eh : ehs) {
            set.add(eh.getEntity());
        }
        return set;
    }

    public static List<String> getCellularLocations(Model model) {
        if (model.getLevel() != BioPAXLevel.L3) {
            throw new IllegalArgumentException("Only level 3 is supported");
        }
        ArrayList<String> locs = new ArrayList<String>();
        for (Object o : locAcc.getValueFromModel(model)) {
            locs.add(o.toString());
        }
        Collections.sort(locs);
        return locs;
    }

    public static Set<BioPAXElement> getElementsAtLocations(Model model, Set<String> locs) {
        if (model.getLevel() != BioPAXLevel.L3) {
            throw new IllegalArgumentException("Only level 3 is supported");
        }
        HashSet<BioPAXElement> result = new HashSet<BioPAXElement>();
        for (PhysicalEntity pe : model.getObjects(PhysicalEntity.class)) {
            Set found = locAcc.getValueFromBean(pe);
            found.retainAll(locs);
            if (found.isEmpty()) continue;
            result.add(pe);
        }
        return result;
    }

    public static Set<EntityHolder> getRelatedEntities(Model model, Collection<XRef> refs) {
        HashSet<EntityHolder> ehs;
        block6: {
            HashSet<String> vals;
            block5: {
                vals = new HashSet<String>();
                for (XRef ref : refs) {
                    vals.add(ref.getRef());
                }
                ehs = new HashSet<EntityHolder>();
                if (model.getLevel() != BioPAXLevel.L3) break block5;
                for (EntityReference er : model.getObjects(EntityReference.class)) {
                    for (Xref xref2 : er.getXref()) {
                        if (!vals.contains(xref2.getId())) continue;
                        ehs.add(new EntityHolder(er));
                    }
                }
                break block6;
            }
            if (model.getLevel() != BioPAXLevel.L2) break block6;
            for (physicalEntity pe : model.getObjects(physicalEntity.class)) {
                for (xref ref : pe.getXREF()) {
                    if (!vals.contains(ref.getID())) continue;
                    ehs.add(new EntityHolder(pe));
                }
            }
        }
        return ehs;
    }

    public static Set<String> getInteractionIDs(Model model) {
        HashSet<String> ids;
        block3: {
            block2: {
                ids = new HashSet<String>();
                if (model.getLevel() != BioPAXLevel.L2) break block2;
                for (interaction inter : model.getObjects(interaction.class)) {
                    ids.add(ID.get(inter));
                }
                break block3;
            }
            if (model.getLevel() != BioPAXLevel.L3) break block3;
            for (Interaction inter : model.getObjects(Interaction.class)) {
                ids.add(ID.get(inter));
            }
        }
        return ids;
    }
}

