/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.util;

import java.awt.geom.Line2D;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.gvt.util.ChsRectangle;

public abstract class ChsGeometry {
    public static final double HALF_PI = 1.5707963267948966;
    public static final double ONE_AND_HALF_PI = 4.71238898038469;
    public static final double TWO_PI = Math.PI * 2;
    public static final double THREE_PI = Math.PI * 3;

    public static double[] getIntersection(ChsRectangle rectA, ChsRectangle rectB) {
        double[] result = new double[4];
        double p1x = rectA.getCenterX();
        double p1y = rectA.getCenterY();
        double p2x = rectB.getCenterX();
        double p2y = rectB.getCenterY();
        if (rectA.intersects(rectB)) {
            result[0] = p1x;
            result[1] = p1y;
            result[2] = p2x;
            result[3] = p2y;
            return result;
        }
        double topLeftAx = rectA.getX();
        double topLeftAy = rectA.getY();
        double topRightAx = rectA.getRight();
        double bottomLeftAx = rectA.getX();
        double bottomLeftAy = rectA.getBottom();
        double bottomRightAx = rectA.getRight();
        double halfWidthA = rectA.getWidthHalf();
        double halfHeightA = rectA.getHeightHalf();
        double topLeftBx = rectB.getX();
        double topLeftBy = rectB.getY();
        double topRightBx = rectB.getRight();
        double bottomLeftBx = rectB.getX();
        double bottomLeftBy = rectB.getBottom();
        double bottomRightBx = rectB.getRight();
        double halfWidthB = rectB.getWidthHalf();
        double halfHeightB = rectB.getHeightHalf();
        boolean clipPointAFound = false;
        boolean clipPointBFound = false;
        if (p1x == p2x) {
            if (p1y > p2y) {
                result[0] = p1x;
                result[1] = topLeftAy;
                result[2] = p2x;
                result[3] = bottomLeftBy;
                return result;
            }
            if (p1y < p2y) {
                result[0] = p1x;
                result[1] = bottomLeftAy;
                result[2] = p2x;
                result[3] = topLeftBy;
                return result;
            }
        } else if (p1y == p2y) {
            if (p1x > p2x) {
                result[0] = topLeftAx;
                result[1] = p1y;
                result[2] = topRightBx;
                result[3] = p2y;
                return result;
            }
            if (p1x < p2x) {
                result[0] = topRightAx;
                result[1] = p1y;
                result[2] = topLeftBx;
                result[3] = p2y;
                return result;
            }
        } else {
            int cardinalDirectionB;
            int cardinalDirectionA;
            double slopeA = rectA.height / rectA.width;
            double slopeB = rectB.height / rectB.width;
            double slopePrime = (p2y - p1y) / (p2x - p1x);
            if (-slopeA == slopePrime) {
                if (p1x > p2x) {
                    result[0] = bottomLeftAx;
                    result[1] = bottomLeftAy;
                    clipPointAFound = true;
                } else {
                    result[0] = topRightAx;
                    result[1] = topLeftAy;
                    clipPointAFound = true;
                }
            } else if (slopeA == slopePrime) {
                if (p1x > p2x) {
                    result[0] = topLeftAx;
                    result[1] = topLeftAy;
                    clipPointAFound = true;
                } else {
                    result[0] = bottomRightAx;
                    result[1] = bottomLeftAy;
                    clipPointAFound = true;
                }
            }
            if (-slopeB == slopePrime) {
                if (p2x > p1x) {
                    result[2] = bottomLeftBx;
                    result[3] = bottomLeftBy;
                    clipPointBFound = true;
                } else {
                    result[2] = topRightBx;
                    result[3] = topLeftBy;
                    clipPointBFound = true;
                }
            } else if (slopeB == slopePrime) {
                if (p2x > p1x) {
                    result[2] = topLeftBx;
                    result[3] = topLeftBy;
                    clipPointBFound = true;
                } else {
                    result[2] = bottomRightBx;
                    result[3] = bottomLeftBy;
                    clipPointBFound = true;
                }
            }
            if (clipPointAFound && clipPointBFound) {
                return result;
            }
            if (p1x > p2x) {
                if (p1y > p2y) {
                    cardinalDirectionA = ChsGeometry.getCardinalDirection(slopeA, slopePrime, 4);
                    cardinalDirectionB = ChsGeometry.getCardinalDirection(slopeB, slopePrime, 2);
                } else {
                    cardinalDirectionA = ChsGeometry.getCardinalDirection(-slopeA, slopePrime, 3);
                    cardinalDirectionB = ChsGeometry.getCardinalDirection(-slopeB, slopePrime, 1);
                }
            } else if (p1y > p2y) {
                cardinalDirectionA = ChsGeometry.getCardinalDirection(-slopeA, slopePrime, 1);
                cardinalDirectionB = ChsGeometry.getCardinalDirection(-slopeB, slopePrime, 3);
            } else {
                cardinalDirectionA = ChsGeometry.getCardinalDirection(slopeA, slopePrime, 2);
                cardinalDirectionB = ChsGeometry.getCardinalDirection(slopeB, slopePrime, 4);
            }
            if (!clipPointAFound) {
                switch (cardinalDirectionA) {
                    case 1: {
                        double tempPointAx;
                        double tempPointAy = topLeftAy;
                        result[0] = tempPointAx = p1x + -halfHeightA / slopePrime;
                        result[1] = tempPointAy;
                        break;
                    }
                    case 2: {
                        double tempPointAx = bottomRightAx;
                        double tempPointAy = p1y + halfWidthA * slopePrime;
                        result[0] = tempPointAx;
                        result[1] = tempPointAy;
                        break;
                    }
                    case 3: {
                        double tempPointAx;
                        double tempPointAy = bottomLeftAy;
                        result[0] = tempPointAx = p1x + halfHeightA / slopePrime;
                        result[1] = tempPointAy;
                        break;
                    }
                    case 4: {
                        double tempPointAx = bottomLeftAx;
                        double tempPointAy = p1y + -halfWidthA * slopePrime;
                        result[0] = tempPointAx;
                        result[1] = tempPointAy;
                    }
                }
            }
            if (!clipPointBFound) {
                switch (cardinalDirectionB) {
                    case 1: {
                        double tempPointBx;
                        double tempPointBy = topLeftBy;
                        result[2] = tempPointBx = p2x + -halfHeightB / slopePrime;
                        result[3] = tempPointBy;
                        break;
                    }
                    case 2: {
                        double tempPointBx = bottomRightBx;
                        double tempPointBy = p2y + halfWidthB * slopePrime;
                        result[2] = tempPointBx;
                        result[3] = tempPointBy;
                        break;
                    }
                    case 3: {
                        double tempPointBx;
                        double tempPointBy = bottomLeftBy;
                        result[2] = tempPointBx = p2x + halfHeightB / slopePrime;
                        result[3] = tempPointBy;
                        break;
                    }
                    case 4: {
                        double tempPointBx = bottomLeftBx;
                        double tempPointBy = p2y + -halfWidthB * slopePrime;
                        result[2] = tempPointBx;
                        result[3] = tempPointBy;
                    }
                }
            }
        }
        return result;
    }

    private static int getCardinalDirection(double slope, double slopePrime, int line) {
        if (slope > slopePrime) {
            return line;
        }
        return 1 + line % 4;
    }

    public static PrecisionPoint getIntersection(ChsRectangle rect, double p1x, double p1y, double p2x, double p2y) {
        double ip1x = 0.0;
        double ip1y = 0.0;
        double ip2x = 0.0;
        double ip2y = 0.0;
        boolean ip1Null = true;
        boolean ip2Null = true;
        double topLeftX = rect.x;
        double topLeftY = rect.y;
        double topRightX = rect.getRight();
        double bottomLeftX = rect.x;
        double bottomLeftY = rect.getBottom();
        double bottomRightX = rect.getRight();
        if (p1x == p2x) {
            if (p1y != p2y && p1x >= bottomLeftX && p1x <= bottomRightX) {
                if (topLeftY != bottomLeftY) {
                    ip1x = p1x;
                    ip1y = bottomLeftY;
                    ip2x = p1x;
                    ip2y = topLeftY;
                    ip2Null = false;
                    ip1Null = false;
                } else {
                    ip1x = p1x;
                    ip1y = topLeftY;
                    ip1Null = false;
                }
            }
        } else if (p1y == p2y) {
            if (p1y >= bottomLeftY && p1y <= topLeftY) {
                if (topLeftX != topRightX) {
                    ip1x = topRightX;
                    ip1y = p1y;
                    ip2x = p1x;
                    ip2y = topLeftY;
                    ip2Null = false;
                    ip1Null = false;
                } else {
                    ip1x = topLeftX;
                    ip1y = p1y;
                    ip1Null = false;
                }
            }
        } else {
            double tempPointY = topLeftY;
            double tempPointX = ChsGeometry.intersectsAtY(p1x, p2x, p1y, p2y, tempPointY);
            if (tempPointX != Double.NaN && tempPointX <= bottomRightX && tempPointX >= bottomLeftX) {
                ip1x = tempPointX;
                ip1y = topLeftY;
                ip1Null = false;
            }
            if ((tempPointX = ChsGeometry.intersectsAtY(p1x, p2x, p1y, p2y, tempPointY = bottomLeftY)) != Double.NaN && tempPointX <= bottomRightX && tempPointX >= bottomLeftX) {
                if (ip1Null) {
                    ip1x = tempPointX;
                    ip1y = bottomLeftY;
                    ip1Null = false;
                } else {
                    ip2x = tempPointX;
                    ip2y = bottomLeftY;
                    ip2Null = false;
                }
            }
            if ((tempPointY = ChsGeometry.intersectsAtX(p1x, p2x, p1y, p2y, tempPointX = bottomLeftX)) != Double.NaN && topLeftY < tempPointY && tempPointY < bottomLeftY) {
                if (ip1Null) {
                    ip1x = bottomLeftX;
                    ip1y = tempPointY;
                    ip1Null = false;
                } else {
                    ip2x = bottomLeftX;
                    ip2y = tempPointY;
                    ip2Null = false;
                }
            }
            if ((tempPointY = ChsGeometry.intersectsAtX(p1x, p2x, p1y, p2y, tempPointX = bottomRightX)) != Double.NaN && topLeftY < tempPointY && tempPointY < bottomLeftY) {
                if (ip1Null) {
                    ip1x = bottomRightX;
                    ip1y = tempPointY;
                    ip1Null = false;
                } else {
                    ip2x = bottomRightX;
                    ip2y = tempPointY;
                    ip2Null = false;
                }
            }
        }
        PrecisionPoint ip1 = null;
        PrecisionPoint ip2 = null;
        if (!ip1Null) {
            ip1 = new PrecisionPoint(ip1x, ip1y);
        }
        if (!ip2Null) {
            ip2 = new PrecisionPoint(ip2x, ip2y);
        }
        return ChsGeometry.findTheClosestPoint(p2x, p2y, ip1, ip2);
    }

    private static PrecisionPoint findTheClosestPoint(double refPointX, double refPointY, PrecisionPoint first, PrecisionPoint second) {
        PrecisionPoint temp = null;
        if (second == null && first != null) {
            temp = first;
        } else if (second != null && first == null) {
            temp = second;
        } else if (second != null && first != null) {
            double term1 = refPointX - first.preciseX;
            double term2 = refPointY - first.preciseY;
            double distanceFirst = term1 * term1 + term2 * term2;
            double distanceSecond = (term1 = refPointX - second.preciseX) * term1 + (term2 = refPointY - second.preciseY) * term2;
            temp = distanceFirst >= distanceSecond ? second : first;
        }
        return temp;
    }

    private static double intersectsAtX(double x1, double x2, double y1, double y2, double x) {
        double y = Double.NaN;
        if (x1 != x2) {
            if (x == x1) {
                y = y1;
            } else if (x == x2) {
                y = y2;
            } else {
                double tempY = y1 + (y2 - y1) * (x - x1) / (x2 - x1);
                if (tempY <= y1 && tempY >= y2 || tempY >= y1 && tempY <= y2) {
                    y = tempY;
                }
            }
        }
        return y;
    }

    private static double intersectsAtY(double x1, double x2, double y1, double y2, double y) {
        double x = Double.NaN;
        if (y1 != y2) {
            if (y == y1) {
                x = x1;
            } else if (y == y2) {
                x = x2;
            } else {
                double tempX = x1 + (x2 - x1) * (y - y1) / (y2 - y1);
                if (tempX <= x1 && tempX >= x2 || tempX >= x1 && tempX <= x2) {
                    x = tempX;
                }
            }
        }
        return x;
    }

    public static Point getIntersection(Point s1, Point s2, Point f1, Point f2) {
        int x1 = s1.x;
        int y1 = s1.y;
        int x2 = s2.x;
        int y2 = s2.y;
        int x3 = f1.x;
        int y3 = f1.y;
        int x4 = f2.x;
        int y4 = f2.y;
        int a1 = y2 - y1;
        int b1 = x1 - x2;
        int c1 = x2 * y1 - x1 * y2;
        int a2 = y4 - y3;
        int b2 = x3 - x4;
        int c2 = x4 * y3 - x3 * y4;
        int denom = a1 * b2 - a2 * b1;
        if (denom == 0) {
            return null;
        }
        int x = (b1 * c2 - b2 * c1) / denom;
        int y = (a2 * c1 - a1 * c2) / denom;
        return new Point(x, y);
    }

    public static double angleOfVector(double Cx, double Cy, double Nx, double Ny) {
        double C_angle;
        if (Cx != Nx) {
            C_angle = Math.atan((Ny - Cy) / (Nx - Cx));
            if (Nx < Cx) {
                C_angle += Math.PI;
            } else if (Ny < Cy) {
                C_angle += Math.PI * 2;
            }
        } else {
            C_angle = Ny < Cy ? 4.71238898038469 : 1.5707963267948966;
        }
        return C_angle;
    }

    public static double radian2degree(double rad) {
        return 180.0 * rad / Math.PI;
    }

    public static boolean doIntersect(PrecisionPoint p1, PrecisionPoint p2, PrecisionPoint p3, PrecisionPoint p4) {
        boolean result = Line2D.linesIntersect(p1.preciseX, p1.preciseY, p2.preciseX, p2.preciseY, p3.preciseX, p3.preciseY, p4.preciseX, p4.preciseY);
        return result;
    }

    private static void testClippingPoints() {
        ChsRectangle rectA = new ChsRectangle(5.0, 6.0, 2.0, 4.0);
        ChsRectangle rectB = new ChsRectangle(0.0, 4.0, 1.0, 4.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(1.0, 4.0, 1.0, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(1.0, 3.0, 3.0, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(2.0, 3.0, 2.0, 4.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(3.0, 3.0, 2.0, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(3.0, 2.0, 4.0, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(6.0, 3.0, 2.0, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(9.0, 2.0, 4.0, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(9.0, 3.0, 2.0, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(8.0, 3.0, 2.0, 4.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(11.0, 3.0, 3.0, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(11.0, 4.0, 1.0, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(10.0, 4.0, 1.0, 4.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(10.0, 5.0, 2.0, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(9.0, 4.5, 2.0, 4.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(10.0, 5.8, 0.4, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(11.0, 6.0, 2.0, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(10.0, 7.8, 0.4, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(9.0, 7.5, 1.0, 4.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(10.0, 7.0, 2.0, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(10.0, 9.0, 2.0, 6.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(11.0, 9.0, 2.0, 4.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(12.0, 8.0, 4.0, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(7.0, 9.0, 2.0, 4.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(8.0, 9.0, 4.0, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(10.0, 9.0, 2.0, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(6.0, 10.0, 2.0, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(3.0, 8.0, 4.0, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(3.0, 9.0, 2.0, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(2.0, 8.0, 4.0, 4.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(2.0, 8.0, 2.0, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(1.0, 8.0, 2.0, 4.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(1.0, 8.5, 1.0, 4.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(3.0, 7.0, 2.0, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(1.0, 7.5, 1.0, 4.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(3.0, 7.8, 0.4, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(1.0, 6.0, 2.0, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(3.0, 5.8, 0.4, 2.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(1.0, 5.0, 1.0, 3.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(1.0, 4.0, 3.0, 3.0);
        ChsGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new ChsRectangle(4.0, 4.0, 3.0, 3.0);
        rectB = new ChsRectangle(5.0, 6.0, 2.0, 4.0);
    }

    private static void findAndPrintClipPoints(ChsRectangle rectA, ChsRectangle rectB) {
        System.out.println("---------------------");
        double[] clipPoints = new double[4];
        System.out.println("RectangleA  X: " + rectA.x + "  Y: " + rectA.y + "  Width: " + rectA.width + "  Height: " + rectA.height);
        System.out.println("RectangleB  X: " + rectB.x + "  Y: " + rectB.y + "  Width: " + rectB.width + "  Height: " + rectB.height);
        clipPoints = ChsGeometry.getIntersection(rectA, rectB);
        System.out.println("Clip Point of RectA X:" + clipPoints[0] + " Y: " + clipPoints[1]);
        System.out.println("Clip Point of RectB X:" + clipPoints[2] + " Y: " + clipPoints[3]);
    }

    public static void main(String[] args) {
        ChsGeometry.testClippingPoints();
    }
}

