/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.cbio.causality.util.BaseDir;
import org.eclipse.swt.graphics.Color;

public enum Conf {
    DRAWPPI;

    public static final String DRAW_PPI_EDGES = "DRAW_PPI_EDGES";
    public static final String PATHWAY_COMMONS_URL = "PATHWAY_COMMONS_URL";
    public static final String PC_SIF_FILE = "PC_SIF_FILE";
    public static final String PC_SIF_FILE_URL = "PC_SIF_FILE_URL";
    public static final String REACTION_2_GENE_FILE = "REACTION_2_GENE_FILE";
    public static final String REACTION_2_GENE_FILE_URL = "REACTION_2_GENE_FILE_URL";
    public static final String PATHWAY_2_GENE_FILE = "PATHWAY_2_GENE_FILE";
    public static final String PATHWAY_2_GENE_FILE_URL = "PATHWAY_2_GENE_FILE_URL";
    public static final String CBIOPORTAL_URL = "CBIOPORTAL_URL";
    public static final String CBIOPORTAL_USE_CACHE = "CBIOPORTAL_USE_CACHE";
    public static final String CBIOPORTAL_CACHE_DIR = "CBIOPORTAL_CACHE_DIR";
    public static final String EXPERIMENT_UP_COLOR = "EXPERIMENT_UP_COLOR";
    public static final String EXPERIMENT_DOWN_COLOR = "EXPERIMENT_DOWN_COLOR";
    public static final String EXPERIMENT_MIDDLE_COLOR = "EXPERIMENT_MIDDLE_COLOR";
    public static final String EXPERIMENT_MAX_UPREGULATION = "EXPERIMENT_MAX_UPREGULATION";
    public static final String EXPERIMENT_NO_CHANGE_UPPER_BOUND = "EXPERIMENT_NO_CHANGE_UPPER_BOUND";
    public static final String EXPERIMENT_NO_CHANGE_LOWER_BOUND = "EXPERIMENT_NO_CHANGE_LOWER_BOUND";
    public static final String EXPERIMENT_MAX_DOWNREGULATION = "EXPERIMENT_MAX_DOWNREGULATION";
    public static final String DISPLAY_FRAGMENT_FEATURE = "DISPLAY_FRAGMENT_FEATURE";
    public static final String HIDE_COMPARTMENT_EDGE_THRESHOLD = "HIDE_COMPARTMENT_EDGE_THRESHOLD";
    public static final String USE_SIF_GROUPING = "USE_SIF_GROUPING";
    public static final String SPREAD_DOUBLE_EDGES = "SPREAD_DOUBLE_EDGES";
    public static final String DEFAULT = "DEFAULT";
    public static final String CONVERT_INTERACTS_WITH_TO_IN_COMPLEX_WITH = "CONVERT_INTERACTS_WITH_TO_IN_COMPLEX_WITH";
    public static final String CONF_FILENAME = "chibe-conf.txt";
    private static String[] pathCandidate;
    private static Map<String, String> conf;
    private static String baseDir;

    private static Map<String, String> parse(BufferedReader reader) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String line = reader.readLine();
            while (line != null) {
                if (!line.startsWith("#") && line.contains("=")) {
                    String[] tuple = line.split("=");
                    tuple[0] = tuple[0].trim();
                    tuple[1] = tuple[1].trim();
                    map.put(tuple[0], tuple[1]);
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }

    private static String getDefaultConfString() {
        String s = "";
        s = s + "DRAW_PPI_EDGES = true\n";
        s = s + "PATHWAY_COMMONS_URL = http://www.pathwaycommons.org/pc2/\n";
        s = s + "PC_SIF_FILE = DEFAULT\n";
        s = s + "PC_SIF_FILE_URL = http://cbio.mskcc.org/~ozgun/PC.sif.gz\n";
        s = s + "REACTION_2_GENE_FILE = DEFAULT\n";
        s = s + "REACTION_2_GENE_FILE_URL = https://raw.githubusercontent.com/PathwayAndDataAnalysis/repo/master/resource-files/reaction2gene.txt\n";
        s = s + "PATHWAY_2_GENE_FILE = DEFAULT\n";
        s = s + "PATHWAY_2_GENE_FILE_URL = https://raw.githubusercontent.com/PathwayAndDataAnalysis/repo/master/resource-files/pathway2gene.txt\n";
        s = s + "CBIOPORTAL_URL = http://www.cbioportal.org/public-portal/webservice.do?\n";
        s = s + "CBIOPORTAL_USE_CACHE = true\n";
        s = s + "CBIOPORTAL_CACHE_DIR = DEFAULT\n";
        s = s + "EXPERIMENT_UP_COLOR = 230 0 0\n";
        s = s + "EXPERIMENT_DOWN_COLOR = 0 0 230\n";
        s = s + "EXPERIMENT_MIDDLE_COLOR = 230 230 230\n";
        s = s + "EXPERIMENT_MAX_UPREGULATION = 2\n";
        s = s + "EXPERIMENT_NO_CHANGE_UPPER_BOUND = 1\n";
        s = s + "EXPERIMENT_NO_CHANGE_LOWER_BOUND = -1\n";
        s = s + "EXPERIMENT_MAX_DOWNREGULATION = -2\n";
        s = s + "DISPLAY_FRAGMENT_FEATURE = false\n";
        s = s + "HIDE_COMPARTMENT_EDGE_THRESHOLD = 20\n";
        s = s + "USE_SIF_GROUPING = true\n";
        s = s + "SPREAD_DOUBLE_EDGES = true\n";
        s = s + "CONVERT_INTERACTS_WITH_TO_IN_COMPLEX_WITH = true\n";
        return s.trim();
    }

    private static boolean writeDefaultConfFile(String file) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(Conf.getDefaultConfString());
            writer.close();
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String get(String property) {
        if (conf.containsKey(property)) {
            return conf.get(property);
        }
        return "";
    }

    public static Color getColor(String key) {
        String[] v;
        String val = Conf.get(key);
        if (val != null && (v = val.split(" ")).length == 3) {
            try {
                return new Color(null, Integer.parseInt(v[0]), Integer.parseInt(v[1]), Integer.parseInt(v[2]));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static double getNumber(String key) {
        String val = Conf.get(key);
        if (val != null) {
            try {
                return Double.parseDouble(val);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return 0.0;
    }

    public static boolean getBoolean(String key) {
        String val = Conf.get(key).toLowerCase();
        return val.equals("true");
    }

    private static File searchForConfFile() {
        for (String path : pathCandidate) {
            String confPath = path + CONF_FILENAME;
            File confFile = new File(confPath);
            if (!confFile.exists()) continue;
            return confFile;
        }
        return null;
    }

    private static void decideBaseDir() {
        String dir = System.getProperty("user.dir");
        if (Conf.isWritable(dir)) {
            baseDir = dir + File.separator;
        } else {
            dir = System.getProperty("user.home") + File.separator + ".chibe";
            File f = new File(dir);
            f.mkdir();
            if (Conf.isWritable(dir)) {
                baseDir = dir + File.separator;
            } else {
                throw new RuntimeException("Neither \"user.dir\" nor \"user.home\" are writable.");
            }
        }
        BaseDir.setDir(baseDir);
    }

    public static boolean isWritable(String loc) {
        Random r = new Random();
        String x = loc + File.separator + "tempchibefile" + r.nextInt(10000) + ".txt";
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(x));
            writer.write("test");
            writer.close();
            File f = new File(x);
            f.delete();
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static String getExperimentsDir() {
        return baseDir + "experiments" + File.separator;
    }

    public static String getPortalCacheDir() {
        String dir = !conf.containsKey(CBIOPORTAL_CACHE_DIR) || conf.get(CBIOPORTAL_CACHE_DIR).equals(DEFAULT) ? baseDir + "portal-cache" + File.separator : conf.get(CBIOPORTAL_CACHE_DIR);
        File f = new File(dir);
        if (!f.exists()) {
            f.mkdirs();
        }
        return dir;
    }

    public static boolean drawPPI() {
        return Conf.getBoolean(DRAW_PPI_EDGES);
    }

    public static String getBlacklistURL() {
        return "http://www.pathwaycommons.org/archives/PC2/v9/blacklist.txt";
    }

    public static String getBaseDir() {
        return baseDir;
    }

    static {
        Conf.decideBaseDir();
        pathCandidate = new String[]{System.getProperty("user.dir") + File.separator, Conf.class.getResource("").getFile() + File.separator, System.getProperty("user.home") + File.separator + ".chibe" + File.separator, ""};
        File confFile = Conf.searchForConfFile();
        if (confFile == null) {
            String file;
            int i = 0;
            while (!Conf.writeDefaultConfFile(file = pathCandidate[i++] + CONF_FILENAME)) {
            }
            confFile = Conf.searchForConfFile();
        }
        if (confFile != null) {
            try {
                conf = Conf.parse(new BufferedReader(new FileReader(confFile)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            conf = Conf.parse(new BufferedReader(new InputStreamReader(new ByteArrayInputStream(Conf.getDefaultConfString().getBytes()))));
        }
    }
}

