/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.util;

import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.xref;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.Xref;
import org.gvt.model.biopaxl2.BioPAXNode;
import org.gvt.util.ID;

public class EntityHolder {
    public physicalEntity l2pe;
    public PhysicalEntity l3pe;
    public EntityReference l3er;

    public EntityHolder(BioPAXElement element) {
        if (element instanceof physicalEntity) {
            this.l2pe = (physicalEntity)element;
        } else if (element instanceof PhysicalEntity) {
            this.l3pe = (PhysicalEntity)element;
            this.setReferenceFromPE();
        } else if (element instanceof EntityReference) {
            this.l3er = (EntityReference)element;
        } else {
            throw new IllegalArgumentException("Invalid object: " + element);
        }
    }

    private void setReferenceFromPE() {
        if (this.l3pe instanceof SimplePhysicalEntity) {
            this.l3er = ((SimplePhysicalEntity)this.l3pe).getEntityReference();
        }
    }

    public EntityHolder(physicalEntity l2pe) {
        this.l2pe = l2pe;
    }

    public EntityHolder(PhysicalEntity l3pe) {
        this.l3pe = l3pe;
        this.setReferenceFromPE();
    }

    public EntityHolder(EntityReference l3er) {
        this.l3er = l3er;
    }

    public int hashCode() {
        if (this.l2pe != null) {
            return this.l2pe.hashCode();
        }
        if (this.l3er != null) {
            return this.l3er.hashCode();
        }
        if (this.l3pe != null) {
            return this.l3pe.hashCode();
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EntityHolder) {
            EntityHolder eh = (EntityHolder)obj;
            if (this.l2pe != null) {
                return eh.l2pe != null && this.l2pe.equals(eh.l2pe);
            }
            if (this.l3er != null) {
                return eh.l3er != null && this.l3er.equals(eh.l3er);
            }
            if (this.l3pe != null) {
                return eh.l3pe != null && this.l3pe.equals(eh.l3pe);
            }
        }
        throw new RuntimeException("comparison with: " + obj);
    }

    public String getName() {
        if (this.l2pe != null) {
            String txt = BioPAXNode.getDisplayName(this.l2pe);
            if (txt != null) {
                return txt;
            }
            return ID.get(this.l2pe);
        }
        if (this.l3pe != null) {
            if (this.l3pe.getDisplayName() != null) {
                return this.l3pe.getDisplayName();
            }
            if (this.l3pe.getStandardName() != null) {
                return this.l3pe.getStandardName();
            }
            if (!this.l3pe.getName().isEmpty()) {
                return this.l3pe.getName().iterator().next();
            }
            return ID.get(this.l3pe);
        }
        if (this.l3er != null) {
            if (this.l3er.getDisplayName() != null) {
                return this.l3er.getDisplayName();
            }
            if (this.l3er.getStandardName() != null) {
                return this.l3er.getStandardName();
            }
            if (!this.l3er.getName().isEmpty()) {
                return this.l3er.getName().iterator().next();
            }
            return ID.get(this.l3er);
        }
        return null;
    }

    public String getID() {
        if (this.l2pe != null) {
            return ID.get(this.l2pe);
        }
        if (this.l3pe != null) {
            return ID.get(this.l3pe);
        }
        if (this.l3er != null) {
            return ID.get(this.l3er);
        }
        return null;
    }

    public boolean containsWord(String word) {
        block13: {
            block14: {
                block12: {
                    word = word.toLowerCase();
                    if (this.l2pe == null) break block12;
                    if (this.l2pe.getNAME() != null && this.l2pe.getNAME().toLowerCase().contains(word)) {
                        return true;
                    }
                    if (this.l2pe.getSHORT_NAME() != null && this.l2pe.getSHORT_NAME().toLowerCase().contains(word)) {
                        return true;
                    }
                    for (String s : this.l2pe.getSYNONYMS()) {
                        if (!s.toLowerCase().contains(word)) continue;
                        return true;
                    }
                    for (xref ref : this.l2pe.getXREF()) {
                        if (!ref.getID().toLowerCase().contains(word)) continue;
                        return true;
                    }
                    break block13;
                }
                if (this.l3pe == null) break block14;
                if (this.l3pe.getStandardName() != null && this.l3pe.getStandardName().toLowerCase().contains(word)) {
                    return true;
                }
                if (this.l3pe.getDisplayName() != null && this.l3pe.getDisplayName().toLowerCase().contains(word)) {
                    return true;
                }
                for (String s : this.l3pe.getName()) {
                    if (!s.toLowerCase().contains(word)) continue;
                    return true;
                }
                for (Xref ref : this.l3pe.getXref()) {
                    if (!ref.getId().toLowerCase().contains(word)) continue;
                    return true;
                }
                break block13;
            }
            if (this.l3er == null) break block13;
            if (this.l3er.getStandardName() != null && this.l3er.getStandardName().toLowerCase().contains(word)) {
                return true;
            }
            if (this.l3er.getDisplayName() != null && this.l3er.getDisplayName().toLowerCase().contains(word)) {
                return true;
            }
            for (String s : this.l3er.getName()) {
                if (!s.toLowerCase().contains(word)) continue;
                return true;
            }
            for (Xref ref : this.l3er.getXref()) {
                if (ref.getId() == null || !ref.getId().toLowerCase().contains(word)) continue;
                return true;
            }
        }
        return false;
    }

    public BioPAXElement getEntity() {
        if (this.l3er != null) {
            return this.l3er;
        }
        if (this.l3pe != null) {
            return this.l3pe;
        }
        return this.l2pe;
    }

    public Named getNamed() {
        if (this.l3pe != null) {
            return this.l3pe;
        }
        if (this.l3er != null) {
            return this.l3er;
        }
        return null;
    }
}

