/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.util;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.xmlbeans.XmlString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.graphdrawing.graphml.xmlns.DataType;
import org.graphdrawing.graphml.xmlns.EdgeType;
import org.graphdrawing.graphml.xmlns.GraphEdgedefaultType;
import org.graphdrawing.graphml.xmlns.GraphType;
import org.graphdrawing.graphml.xmlns.GraphmlDocument;
import org.graphdrawing.graphml.xmlns.GraphmlType;
import org.graphdrawing.graphml.xmlns.KeyForType;
import org.graphdrawing.graphml.xmlns.KeyType;
import org.graphdrawing.graphml.xmlns.KeyTypeType;
import org.graphdrawing.graphml.xmlns.NodeType;
import org.gvt.model.CompoundModel;
import org.gvt.model.EdgeBendpoint;
import org.gvt.model.EdgeModel;
import org.gvt.model.GraphObject;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl2.Complex;
import org.gvt.model.biopaxl3.ChbComplex;

public class GraphMLWriter {
    HashMap hashMap = new HashMap();
    GraphmlType newGraphml;
    KeyType xKey;
    KeyType yKey;
    KeyType heightKey;
    KeyType widthKey;
    KeyType colorKey;
    KeyType borderColorKey;
    KeyType textKey;
    KeyType textFontKey;
    KeyType textColorKey;
    KeyType shapeKey;
    KeyType clusterIDKey;
    KeyType marginKey;
    KeyType arrowKey;
    KeyType styleKey;
    KeyType bendpointKey;
    KeyType highlightColorKey;
    int marginSize = -1;
    boolean writeComplexMembers = false;

    public Object writeXMLFile(CompoundModel root) {
        GraphmlDocument newGraphmlDoc = GraphmlDocument.Factory.newInstance();
        this.newGraphml = newGraphmlDoc.addNewGraphml();
        this.xKey = this.newGraphml.addNewKey();
        this.xKey.setId("x");
        this.xKey.setFor(KeyForType.NODE);
        this.xKey.setAttrName("x");
        this.xKey.setAttrType(KeyTypeType.INT);
        this.yKey = this.newGraphml.addNewKey();
        this.yKey.setId("y");
        this.yKey.setFor(KeyForType.NODE);
        this.yKey.setAttrName("y");
        this.yKey.setAttrType(KeyTypeType.INT);
        this.heightKey = this.newGraphml.addNewKey();
        this.heightKey.setId("height");
        this.heightKey.setFor(KeyForType.NODE);
        this.heightKey.setAttrName("height");
        this.heightKey.setAttrType(KeyTypeType.INT);
        this.widthKey = this.newGraphml.addNewKey();
        this.widthKey.setId("width");
        this.widthKey.setFor(KeyForType.NODE);
        this.widthKey.setAttrName("width");
        this.widthKey.setAttrType(KeyTypeType.INT);
        this.shapeKey = this.newGraphml.addNewKey();
        this.shapeKey.setId("shape");
        this.shapeKey.setFor(KeyForType.NODE);
        this.shapeKey.setAttrName("shape");
        this.shapeKey.setAttrType(KeyTypeType.STRING);
        this.clusterIDKey = this.newGraphml.addNewKey();
        this.clusterIDKey.setId("clusterID");
        this.clusterIDKey.setFor(KeyForType.NODE);
        this.clusterIDKey.setAttrName("clusterID");
        this.clusterIDKey.setAttrType(KeyTypeType.STRING);
        this.marginKey = this.newGraphml.addNewKey();
        this.marginKey.setId("margin");
        this.marginKey.setFor(KeyForType.GRAPH);
        this.marginKey.setAttrName("margin");
        this.marginKey.setAttrType(KeyTypeType.INT);
        this.styleKey = this.newGraphml.addNewKey();
        this.styleKey.setId("style");
        this.styleKey.setFor(KeyForType.EDGE);
        this.styleKey.setAttrName("style");
        this.styleKey.setAttrType(KeyTypeType.STRING);
        this.arrowKey = this.newGraphml.addNewKey();
        this.arrowKey.setId("arrow");
        this.arrowKey.setFor(KeyForType.EDGE);
        this.arrowKey.setAttrName("arrow");
        this.arrowKey.setAttrType(KeyTypeType.STRING);
        this.bendpointKey = this.newGraphml.addNewKey();
        this.bendpointKey.setId("bendpoint");
        this.bendpointKey.setFor(KeyForType.EDGE);
        this.bendpointKey.setAttrName("bendpoint");
        this.bendpointKey.setAttrType(KeyTypeType.STRING);
        this.colorKey = this.newGraphml.addNewKey();
        this.colorKey.setId("color");
        this.colorKey.setFor(KeyForType.ALL);
        this.colorKey.setAttrName("color");
        this.colorKey.setAttrType(KeyTypeType.STRING);
        this.borderColorKey = this.newGraphml.addNewKey();
        this.borderColorKey.setId("borderColor");
        this.borderColorKey.setFor(KeyForType.ALL);
        this.borderColorKey.setAttrName("borderColor");
        this.borderColorKey.setAttrType(KeyTypeType.STRING);
        this.textKey = this.newGraphml.addNewKey();
        this.textKey.setId("text");
        this.textKey.setFor(KeyForType.ALL);
        this.textKey.setAttrName("text");
        this.textKey.setAttrType(KeyTypeType.STRING);
        this.textFontKey = this.newGraphml.addNewKey();
        this.textFontKey.setId("textFont");
        this.textFontKey.setFor(KeyForType.ALL);
        this.textFontKey.setAttrName("textFont");
        this.textFontKey.setAttrType(KeyTypeType.STRING);
        this.textColorKey = this.newGraphml.addNewKey();
        this.textColorKey.setId("textColor");
        this.textColorKey.setFor(KeyForType.ALL);
        this.textColorKey.setAttrName("textColor");
        this.textColorKey.setAttrType(KeyTypeType.STRING);
        this.highlightColorKey = this.newGraphml.addNewKey();
        this.highlightColorKey.setId("highlightColor");
        this.highlightColorKey.setFor(KeyForType.ALL);
        this.highlightColorKey.setAttrName("highlightColor");
        this.highlightColorKey.setAttrType(KeyTypeType.STRING);
        GraphType newGraph = this.newGraphml.addNewGraph();
        this.createTree(newGraph, root, "");
        return newGraphmlDoc;
    }

    public void createTree(GraphType rootGraph, CompoundModel root, String graphId) {
        String id;
        GraphObject model;
        rootGraph.setId(graphId);
        rootGraph.setEdgedefault(GraphEdgedefaultType.UNDIRECTED);
        if (!this.isReducedComplex(root)) {
            Iterator iter = root.getChildren().iterator();
            int i = 0;
            while (iter.hasNext()) {
                model = (NodeModel)iter.next();
                id = graphId + "n" + i;
                this.hashMap.put(model, id);
                NodeType newNode = rootGraph.addNewNode();
                newNode.setId(id);
                if (this.createNode(newNode, (NodeModel)model)) {
                    if (this.marginSize < 0) {
                        this.marginSize = CompoundModel.MARGIN_SIZE;
                    }
                    DataType marginData = rootGraph.addNewData();
                    marginData.setKey(this.marginKey.getId());
                    marginData.set(XmlString.Factory.newValue("" + this.marginSize));
                    GraphType newGraph = newNode.addNewGraph();
                    this.createTree(newGraph, (CompoundModel)model, newNode.getId() + ":");
                }
                ++i;
            }
        }
        if (graphId.equals("")) {
            int i = 0;
            Iterator edgeIter = root.getEdgeIterator(0, true, false);
            while (edgeIter.hasNext()) {
                model = (EdgeModel)edgeIter.next();
                id = graphId + "e" + i;
                EdgeType newEdge = rootGraph.addNewEdge();
                newEdge.setId(id);
                newEdge.setSource((String)this.hashMap.get(((EdgeModel)model).getSource()));
                newEdge.setTarget((String)this.hashMap.get(((EdgeModel)model).getTarget()));
                this.createEdge(newEdge, (EdgeModel)model);
                ++i;
            }
        }
        DataType marginData = rootGraph.addNewData();
        marginData.setKey(this.marginKey.getId());
        marginData.set(XmlString.Factory.newValue("" + this.marginSize));
    }

    public boolean createNode(NodeType newNode, NodeModel model) {
        DataType xData = newNode.addNewData();
        xData.setKey(this.xKey.getId());
        xData.set(XmlString.Factory.newValue("" + model.getConstraint().x));
        DataType yData = newNode.addNewData();
        yData.setKey(this.yKey.getId());
        yData.set(XmlString.Factory.newValue("" + model.getConstraint().y));
        DataType heightData = newNode.addNewData();
        heightData.setKey(this.heightKey.getId());
        heightData.set(XmlString.Factory.newValue("" + model.getConstraint().height));
        DataType widthData = newNode.addNewData();
        widthData.setKey(this.widthKey.getId());
        widthData.set(XmlString.Factory.newValue("" + model.getConstraint().width));
        DataType colorData = newNode.addNewData();
        colorData.setKey(this.colorKey.getId());
        RGB rgb = model.getColor().getRGB();
        colorData.set(XmlString.Factory.newValue(rgb.red + " " + rgb.green + " " + rgb.blue));
        DataType borderColorData = newNode.addNewData();
        borderColorData.setKey(this.borderColorKey.getId());
        rgb = model.getBorderColor().getRGB();
        borderColorData.set(XmlString.Factory.newValue(rgb.red + " " + rgb.green + " " + rgb.blue));
        DataType textData = newNode.addNewData();
        textData.setKey(this.textKey.getId());
        textData.set(XmlString.Factory.newValue(model.getText()));
        DataType textFontData = newNode.addNewData();
        textFontData.setKey(this.textFontKey.getId());
        Font f = model.getTextFont();
        textFontData.set(XmlString.Factory.newValue(f.getFontData()[0].toString()));
        DataType textColorData = newNode.addNewData();
        textColorData.setKey(this.textColorKey.getId());
        rgb = model.getTextColor().getRGB();
        textColorData.set(XmlString.Factory.newValue(rgb.red + " " + rgb.green + " " + rgb.blue));
        DataType clusterIDData = newNode.addNewData();
        clusterIDData.setKey(this.clusterIDKey.getId());
        clusterIDData.set(XmlString.Factory.newValue("" + model.getClusterIDs()));
        if (model.isHighlight()) {
            DataType highlightColorData = newNode.addNewData();
            highlightColorData.setKey(this.highlightColorKey.getId());
            Color highlightColor = model.getHighlightColor();
            rgb = highlightColor != null ? highlightColor.getRGB() : new RGB(255, 255, 0);
            highlightColorData.set(XmlString.Factory.newValue(rgb.red + " " + rgb.green + " " + rgb.blue));
        }
        if (model instanceof CompoundModel && !this.isReducedComplex(model)) {
            return true;
        }
        DataType shapeData = newNode.addNewData();
        shapeData.setKey(this.shapeKey.getId());
        shapeData.set(XmlString.Factory.newValue(model.getShape()));
        return false;
    }

    private boolean isReducedComplex(NodeModel model) {
        return !this.writeComplexMembers && (model instanceof ChbComplex || model instanceof Complex);
    }

    public void createEdge(EdgeType newEdge, EdgeModel model) {
        DataType colorData = newEdge.addNewData();
        colorData.setKey(this.colorKey.getId());
        RGB rgb = model.getColor().getRGB();
        colorData.set(XmlString.Factory.newValue(rgb.red + " " + rgb.green + " " + rgb.blue));
        DataType textData = newEdge.addNewData();
        textData.setKey(this.textKey.getId());
        textData.set(XmlString.Factory.newValue(model.getText()));
        DataType textFontData = newEdge.addNewData();
        textFontData.setKey(this.textFontKey.getId());
        Font f = model.getTextFont();
        textFontData.set(XmlString.Factory.newValue(f.getFontData()[0].toString()));
        DataType textColorData = newEdge.addNewData();
        textColorData.setKey(this.textColorKey.getId());
        rgb = model.getTextColor().getRGB();
        textColorData.set(XmlString.Factory.newValue(rgb.red + " " + rgb.green + " " + rgb.blue));
        DataType styleData = newEdge.addNewData();
        styleData.setKey(this.styleKey.getId());
        styleData.set(XmlString.Factory.newValue(model.getStyle()));
        DataType arrowData = newEdge.addNewData();
        arrowData.setKey(this.arrowKey.getId());
        arrowData.set(XmlString.Factory.newValue(model.getArrow()));
        Iterator bendpointIter = model.getBendpoints().iterator();
        while (bendpointIter.hasNext()) {
            DataType bendpointData = newEdge.addNewData();
            bendpointData.setKey(this.bendpointKey.getId());
            bendpointData.set(XmlString.Factory.newValue(((EdgeBendpoint)bendpointIter.next()).toString()));
        }
        DataType widthData = newEdge.addNewData();
        widthData.setKey(this.widthKey.getId());
        widthData.set(XmlString.Factory.newValue("" + model.getWidth()));
        if (model.isHighlight()) {
            DataType highlightColorData = newEdge.addNewData();
            highlightColorData.setKey(this.highlightColorKey.getId());
            rgb = model.getHighlightColor().getRGB();
            highlightColorData.set(XmlString.Factory.newValue(rgb.red + " " + rgb.green + " " + rgb.blue));
        }
    }
}

